/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common;

import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.FileRenderUtils;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.core.exception.CommonException;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class RenderIndexCommand
extends AbstractCommand<String> {
    public String execute(CmsInvoker invoker) {
        CmsTemplate homeTemplate = this.getCmsTemplateService().queryDefaultHomeTemplate();
        if (homeTemplate == null) {
            throw new CommonException("\u7cfb\u7edf\u6ca1\u6709\u53ef\u7528\u7684\u9996\u9875\u6a21\u677f\uff0c\u65e0\u6cd5\u751f\u6210\u9996\u9875");
        }
        try {
            this.deleteOldHomeFile();
            this.renderFile(homeTemplate);
        }
        catch (IOException e) {
            throw new CommonException("\u751f\u6210\u9996\u9875\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private void deleteOldHomeFile() throws IOException {
        File dashFolder = FileRenderUtils.getDashFolder();
        String subFolder = DateFormatUtils.format((Date)new Date(), (String)"/yyyyMMddHHmm");
        if (!(dashFolder = new File(dashFolder.getAbsolutePath() + subFolder)).exists()) {
            FileUtils.forceMkdir((File)dashFolder);
        }
        FileUtils.copyFileToDirectory((File)this.getIndexFile(), (File)dashFolder);
    }

    private void renderFile(CmsTemplate homeTemplate) throws IOException {
        homeTemplate = (CmsTemplate)this.getCmsTemplateService().queryObjById((Object)homeTemplate.getId());
        String template = homeTemplate.getTemplate();
        if (StringUtils.isBlank((String)template)) {
            throw new CommonException("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u9996\u9875");
        }
        File indexFile = this.getIndexFile();
        FileWriter writer = new FileWriter(indexFile);
        BeetlTemplateUtils.renderFromString((String)template, (Writer)writer, null);
    }

    private File getIndexFile() throws IOException {
        File rootFolder = FileRenderUtils.getRootFolder();
        File indexFile = new File(rootFolder.getAbsolutePath() + "/" + FileRenderUtils.INEDX_PAGE_FILE_NAME);
        if (!indexFile.exists()) {
            FileUtils.touch((File)indexFile);
        }
        return indexFile;
    }
}

