/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common.listener;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.ICmsCommand;
import com.els.base.cms.common.RenderArticleCommand;
import com.els.base.cms.common.RenderIndexCommand;
import com.els.base.cms.common.RenderModuleCommand;
import com.els.base.cms.common.event.ChangeTemplateEvent;
import com.els.base.cms.common.listener.ChangeTemplateListener;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.cms.module.service.CmsModuleService;
import com.els.base.cms.module.utils.TemplateTypeEnum;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.core.entity.IExample;
import com.els.base.core.event.BaseListener;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ChangeTemplateListener
implements BaseListener<ChangeTemplateEvent> {
    @Resource
    protected CmsInvoker invoker;
    @Resource
    protected ArticleService articleService;
    @Resource
    protected CmsModuleService cmsModuleService;

    public void onApplicationEvent(ChangeTemplateEvent event) {
        CmsTemplate oldTemplate = event.getOldTemplate();
        CmsTemplate newTemplate = event.getNewTemplate();
        Assert.isNotNull((Object)oldTemplate, (String)"\u65e7\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)newTemplate, (String)"\u65b0\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        if (oldTemplate.getTemplate().equals(newTemplate.getTemplate()) && oldTemplate.getIsDefault().equals(newTemplate.getIsDefault())) {
            return;
        }
        switch (1.$SwitchMap$com$els$base$cms$module$utils$TemplateTypeEnum[TemplateTypeEnum.getEnum((String)newTemplate.getType()).ordinal()]) {
            case 1: {
                this.invoker.invoke((ICmsCommand)new RenderIndexCommand());
                return;
            }
            case 2: {
                this.renderModule(this.invoker, newTemplate, oldTemplate);
                return;
            }
            case 3: {
                this.renderArticle(this.invoker, newTemplate, oldTemplate);
                return;
            }
        }
    }

    private void renderModule(CmsInvoker invoker, CmsTemplate newTemplate, CmsTemplate oldTemplate) {
        List list;
        CmsModuleExample example = new CmsModuleExample();
        CmsModuleExample.Criteria cri = example.createCriteria();
        cri.andModuleTemplateIdEqualTo(newTemplate.getId());
        if (!newTemplate.getTemplate().equals(oldTemplate.getTemplate()) || Constant.YES_INT.equals(newTemplate.getIsDefault())) {
            cri.andModuleTemplateIdIsNull();
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.cmsModuleService.queryAllObjByExample((IExample)example)))) {
            return;
        }
        for (CmsModule module : list) {
            invoker.invoke((ICmsCommand)new RenderModuleCommand(module));
        }
    }

    private void renderArticle(CmsInvoker invoker, CmsTemplate newTemplate, CmsTemplate oldTemplate) {
        List list;
        ArticleExample example = new ArticleExample();
        ArticleExample.Criteria criteria = example.createCriteria();
        criteria.andTemplateIdEqualTo(newTemplate.getId());
        if (!newTemplate.getIsDefault().equals(oldTemplate.getIsDefault()) || Constant.YES_INT.equals(newTemplate.getIsDefault())) {
            criteria.andTemplateIdIsNull();
        }
        if (CollectionUtils.isEmpty((Collection)(list = this.articleService.queryAllObjByExample((IExample)example)))) {
            return;
        }
        for (Article article : list) {
            invoker.invoke((ICmsCommand)new RenderArticleCommand(article));
        }
    }
}

