/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.module.command;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.els.base.cms.article.command.DeleteCommand;
import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.ICmsCommand;
import com.els.base.cms.common.RenderAllCommand;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeleteModuleCommand
extends AbstractCommand<String> {
    private List<String> ids;

    public DeleteModuleCommand(List<String> ids) {
        this.ids = ids;
    }

    public String execute(CmsInvoker invoker) {
        Assert.isNotEmpty((Collection)this.ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        CmsModuleExample example = new CmsModuleExample();
        example.createCriteria().andIdIn(this.ids);
        List moduleList = this.getCmsModuleService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)moduleList)) {
            return null;
        }
        for (CmsModule module : moduleList) {
            this.deleteArticleByModuleId(invoker, module.getId());
        }
        for (CmsModule module : moduleList) {
            this.getCmsModuleService().deleteObjById((Object)module.getId());
            this.removeModuleFile(module);
        }
        invoker.invoke((ICmsCommand)new RenderAllCommand());
        return null;
    }

    private void removeModuleFile(CmsModule module) {
    }

    private void deleteArticleByModuleId(CmsInvoker invoker, String id) {
        ArrayList<String> articleIds = new ArrayList<String>();
        ArticleExample articleExample = new ArticleExample();
        articleExample.createCriteria().andModuleIdEqualTo(id);
        List articleList = this.getArticleService().queryAllObjByExample((IExample)articleExample);
        if (CollectionUtils.isEmpty((Collection)articleList)) {
            return;
        }
        for (Article article : articleList) {
            articleIds.add(article.getId());
        }
        invoker.invoke((ICmsCommand)new DeleteCommand(articleIds));
    }
}

