/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.module.command;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.ICmsCommand;
import com.els.base.cms.common.RenderIndexCommand;
import com.els.base.cms.common.event.ChangeModuleEvent;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.Collection;
import java.util.List;
import org.springframework.context.ApplicationEvent;

public class EnableModuleCommand
extends AbstractCommand<String> {
    private List<String> ids;
    private boolean isEnable;

    public EnableModuleCommand(List<String> ids, boolean isEnable) {
        this.ids = ids;
        this.isEnable = isEnable;
    }

    public String execute(CmsInvoker invoker) {
        CmsModuleExample example = new CmsModuleExample();
        Integer oppStatus = this.isEnable ? Constant.NO_INT : Constant.YES_INT;
        example.createCriteria().andIdIn(this.ids).andStatusEqualTo(oppStatus);
        List moduleList = this.getCmsModuleService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)moduleList)) {
            return null;
        }
        example.clear();
        example.createCriteria().andIdIn(this.ids);
        CmsModule template = new CmsModule();
        template.setStatus(this.isEnable ? Constant.YES_INT : Constant.NO_INT);
        this.getCmsModuleService().modifyByExample(example, template);
        invoker.invoke((ICmsCommand)new RenderIndexCommand());
        if (!this.isEnable) {
            return null;
        }
        moduleList = this.getCmsModuleService().queryAllObjByExample((IExample)example);
        for (CmsModule module : moduleList) {
            SpringContextHolder.getApplicationContext().publishEvent((ApplicationEvent)new ChangeModuleEvent(module));
        }
        return null;
    }
}

