/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.template.command;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.cms.template.entity.CmsTemplate;
import com.els.base.cms.template.entity.CmsTemplateExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;

public class EnableTplCommand
extends AbstractCommand<String> {
    private List<String> ids;
    private boolean isEnable;

    public EnableTplCommand(List<String> ids, boolean isEnable) {
        this.ids = ids;
        this.isEnable = isEnable;
    }

    public String execute(CmsInvoker invoker) {
        CmsTemplateExample example = new CmsTemplateExample();
        if (!this.isEnable) {
            example.createCriteria().andIdIn(this.ids).andIsDefaultEqualTo(Constant.YES_INT);
            if (CollectionUtils.isNotEmpty((Collection)this.getCmsTemplateService().queryAllObjByExample((IExample)example))) {
                throw new CommonException("\u9ed8\u8ba4\u7684\u6a21\u677f\u4e0d\u80fd\u7981\u7528");
            }
            example.clear();
        }
        CmsModuleExample moduleExample = new CmsModuleExample();
        moduleExample.createCriteria().andModuleTemplateIdIn(this.ids);
        moduleExample.or().andArticleTemplateIdIn(this.ids);
        List moduleList = this.getCmsModuleService().queryAllObjByExample((IExample)moduleExample);
        if (CollectionUtils.isNotEmpty((Collection)moduleList)) {
            String message = MessageFormat.format("\u6a21\u677f[{0}}]\u5728\u95e8\u6237\u6a21\u5757[{1}]\u4f7f\u7528\u4e2d\uff0c\u65e0\u6cd5\u7981\u7528", ((CmsModule)moduleList.get(0)).getModuleTemplateName(), ((CmsModule)moduleList.get(0)).getName());
            throw new CommonException(message);
        }
        example.createCriteria().andIdIn(this.ids);
        CmsTemplate template = new CmsTemplate();
        template.setIsEnable(this.isEnable ? Constant.YES_INT : Constant.NO_INT);
        this.getCmsTemplateService().modifyByExample(example, template);
        return null;
    }
}

