/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common.tag;

import com.els.base.cms.banner.entity.CmsBanner;
import com.els.base.cms.banner.entity.CmsBannerExample;
import com.els.base.cms.banner.service.CmsBannerService;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.beetl.core.Context;
import org.beetl.core.GeneralVarTagBinding;
import org.beetl.core.VirtualAttributeEval;

public class BannerListTag
extends GeneralVarTagBinding
implements VirtualAttributeEval {
    private static final String ATTR_NAME_BEGIN = "begin";
    private static final String ATTR_NAME_END = "end";
    private static final String ATTR_NAME_IS_SHOW_ALL = "isShowAll";

    public Object eval(Object value, String attributeName, Context ctx) {
        if (value == null) {
            return value;
        }
        switch (attributeName) {
            default: 
        }
        String attrStr = value.toString();
        if (StringUtils.isBlank((String)attrStr) || !StringUtils.isNumeric((String)attrStr)) {
            return null;
        }
        return Integer.valueOf(attrStr);
    }

    public boolean isSupport(Class c, String attributeName) {
        if (attributeName.equals(ATTR_NAME_BEGIN)) {
            return c.equals(Integer.class);
        }
        if (attributeName.equals(ATTR_NAME_END)) {
            return c.equals(Integer.class);
        }
        return false;
    }

    public void render() {
        List<CmsBanner> banners = this.getAllBanner();
        if (CollectionUtils.isEmpty(banners)) {
            return;
        }
        Integer begin = (Integer)this.getAttributeValue(ATTR_NAME_BEGIN);
        Integer end = (Integer)this.getAttributeValue(ATTR_NAME_END);
        begin = begin == null || begin < 0 ? 0 : (begin >= banners.size() ? banners.size() - 1 : begin);
        end = end == null || end >= banners.size() ? banners.size() - 1 : end;
        for (int i = begin.intValue(); i <= end; ++i) {
            HashMap<String, Serializable> status = new HashMap<String, Serializable>();
            status.put("current", banners.get(i));
            status.put("index", Integer.valueOf(i));
            status.put("isFirst", Boolean.valueOf(i == begin));
            status.put("isLast", Boolean.valueOf(i == end));
            this.binds(new Object[]{status});
            this.doBodyRender();
        }
    }

    private List<CmsBanner> getAllBanner() {
        CmsBannerExample example = new CmsBannerExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("SORT_NO DESC");
        CmsBannerService cmsBannerService = (CmsBannerService)SpringContextHolder.getOneBean(CmsBannerService.class);
        return cmsBannerService.queryAllObjByExample((IExample)example);
    }
}

