/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.command;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
extends AbstractCommand<String> {
    private static final String GERNERATOR_CODE = "NOTICE_NO_GENERATOR";
    private Article article;

    public CreateCommand(Article article) {
        this.article = article;
    }

    @Override
    public String execute(CmsInvoker invoker) {
        this.valid(this.article);
        this.init(this.article);
        this.add(this.article);
        return null;
    }

    private void add(Article article) {
        this.getArticleService().addObj(article);
    }

    private void init(Article article) {
        article.setCreateTime(new Date());
        article.setStatus(Constant.NO_INT);
        if (!Constant.YES_INT.equals(article.getIsAllReceived()) && !Constant.NO_INT.equals(article.getIsAllReceived())) {
            article.setIsAllReceived(Constant.YES_INT);
        }
        if (StringUtils.isBlank((String)article.getModuleCode()) || StringUtils.isBlank((String)article.getModuleName())) {
            CmsModule module = (CmsModule)this.getCmsModuleService().queryObjById(article.getModuleId());
            article.setModuleCode(module.getCode());
            article.setModuleName(module.getName());
        }
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        article.setArticleNo(generateCodeService.getNextCode(GERNERATOR_CODE));
    }

    private void valid(Article article) {
        Assert.isNotBlank((String)article.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)article.getSummary(), (String)"\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)article.getContent(), (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)article.getModuleId(), (String)"\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)article.getCreateUserId(), (String)"\u521b\u5efa\u4ebaId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)article.getCreateUserName(), (String)"\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        if (article.getValidStartTime() != null && article.getValidEndTime() != null && article.getValidStartTime().getTime() > article.getValidEndTime().getTime()) {
            throw new CommonException("\u5f00\u59cb\u751f\u6548\u65f6\u95f4\uff0c\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
    }
}

