/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.common.AbstractCommand;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.FileRenderUtils;
import com.els.base.cms.common.ICmsCommand;
import com.els.base.cms.common.RenderArticleCommand;
import com.els.base.cms.common.RenderIndexCommand;
import com.els.base.cms.common.RenderModuleCommand;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.entity.CmsModuleExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class RenderAllCommand
extends AbstractCommand<String> {
    public String execute(CmsInvoker invoker) {
        CmsModuleExample example = new CmsModuleExample();
        example.createCriteria().andStatusEqualTo(Constant.YES_INT);
        List moduleList = this.getCmsModuleService().queryAllObjByExample((IExample)example);
        try {
            this.deleteAllArticleFile();
        }
        catch (IOException e) {
            throw new CommonException("\u6e05\u9664\u65e7\u6587\u7ae0\u5185\u5bb9\u5931\u8d25");
        }
        for (int i = 0; CollectionUtils.isNotEmpty((Collection)moduleList) && i < moduleList.size(); ++i) {
            List articleList = this.getArticleList((CmsModule)moduleList.get(i));
            for (int j = 0; CollectionUtils.isNotEmpty((Collection)articleList) && j < articleList.size(); ++j) {
                invoker.invoke((ICmsCommand)new RenderArticleCommand((Article)articleList.get(j)));
            }
            invoker.invoke((ICmsCommand)new RenderModuleCommand((CmsModule)moduleList.get(i)));
        }
        invoker.invoke((ICmsCommand)new RenderIndexCommand());
        return null;
    }

    private void deleteAllArticleFile() throws IOException {
        File dashFolder = FileRenderUtils.getDashFolder();
        String subFolderStr = DateFormatUtils.format((Date)new Date(), (String)"/yyyyMMddHHmm");
        File subFolder = FileRenderUtils.getSubFolder((File)dashFolder, (String)subFolderStr);
        File articleFolder = FileRenderUtils.getArticleFolder();
        FileUtils.copyDirectoryToDirectory((File)articleFolder, (File)subFolder);
        FileUtils.cleanDirectory((File)articleFolder);
    }

    private List<Article> getArticleList(CmsModule cmsModule) {
        ArticleExample example = new ArticleExample();
        example.createCriteria().andModuleIdEqualTo(cmsModule.getId()).andStatusEqualTo(Constant.YES_INT);
        return this.getArticleService().queryAllObjByExample((IExample)example);
    }
}

