/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.article.service.impl;

import com.els.base.cms.article.dao.ArticleMapper;
import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.entity.ArticleExample;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultArticleService")
public class ArticleServiceImpl
implements ArticleService {
    @Resource
    protected ArticleMapper articleMapper;

    @CacheEvict(value={"article"}, allEntries=true)
    public void addObj(Article t) {
        this.articleMapper.insertSelective(t);
    }

    @CacheEvict(value={"article"}, allEntries=true)
    public void deleteObjById(String id) {
        this.articleMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"article"}, allEntries=true)
    public void modifyObj(Article t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.articleMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"article"}, keyGenerator="redisKeyGenerator")
    public Article queryObjById(String id) {
        return this.articleMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"article"}, keyGenerator="redisKeyGenerator")
    public List<Article> queryAllObjByExample(ArticleExample example) {
        return this.articleMapper.selectByExampleWithBLOBs(example);
    }

    @Cacheable(value={"article"}, keyGenerator="redisKeyGenerator")
    public PageView<Article> queryObjByPage(ArticleExample example) {
        PageView<Article> pageView = example.getPageView();
        pageView.setQueryResult(this.articleMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"article"}, allEntries=true)
    public void modifyByExample(Article article, ArticleExample articleExample) {
        article.setId(null);
        this.articleMapper.updateByExampleSelective(article, articleExample);
    }
}

