/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.cms.common.listener;

import com.els.base.cms.article.entity.Article;
import com.els.base.cms.article.service.ArticleService;
import com.els.base.cms.common.CmsInvoker;
import com.els.base.cms.common.RenderArticleCommand;
import com.els.base.cms.common.RenderIndexCommand;
import com.els.base.cms.common.RenderModuleCommand;
import com.els.base.cms.common.event.ChangeArticleEvent;
import com.els.base.cms.module.entity.CmsModule;
import com.els.base.cms.module.service.CmsModuleService;
import com.els.base.core.event.BaseListener;
import com.els.base.core.utils.Constant;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ChangeArticleListener
implements BaseListener<ChangeArticleEvent> {
    @Resource
    private ArticleService articleService;
    @Resource
    private CmsModuleService cmsModuleService;
    @Resource
    private CmsInvoker invoker;

    public void onApplicationEvent(ChangeArticleEvent event) {
        Article oldArticle = event.getOldArticle();
        Article newArticle = event.getNewArticle();
        if (oldArticle == null) {
            if (!Constant.YES_INT.equals(newArticle.getStatus())) {
                return;
            }
            this.invoker.invoke(new RenderArticleCommand(event.getNewArticle()));
            CmsModule module = (CmsModule)this.cmsModuleService.queryObjById(newArticle.getModuleId());
            this.invoker.invoke(new RenderModuleCommand(module));
            this.invoker.invoke(new RenderIndexCommand());
            return;
        }
        if (newArticle == null) {
            if (!Constant.YES_INT.equals(oldArticle.getStatus())) {
                return;
            }
            CmsModule module = (CmsModule)this.cmsModuleService.queryObjById(oldArticle.getModuleId());
            this.invoker.invoke(new RenderModuleCommand(module));
            this.invoker.invoke(new RenderIndexCommand());
            return;
        }
        if (!Constant.YES_INT.equals(oldArticle.getStatus()) && !Constant.YES_INT.equals(newArticle.getStatus())) {
            return;
        }
        this.invoker.invoke(new RenderArticleCommand(event.getNewArticle()));
        CmsModule newModule = (CmsModule)this.cmsModuleService.queryObjById(newArticle.getModuleId());
        this.invoker.invoke(new RenderModuleCommand(newModule));
        if (!newArticle.getModuleId().equals(oldArticle.getModuleId())) {
            CmsModule oldModule = (CmsModule)this.cmsModuleService.queryObjById(oldArticle.getModuleId());
            this.invoker.invoke(new RenderModuleCommand(oldModule));
        }
        this.invoker.invoke(new RenderIndexCommand());
    }
}

