/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.IndustryMapper;
import com.els.base.company.entity.Industry;
import com.els.base.company.entity.IndustryExample;
import com.els.base.company.service.IndustryService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultIndustryService")
public class IndustryServiceImpl
implements IndustryService {
    private static final Integer YES_INABLED = 1;
    @Resource
    protected IndustryMapper industryMapper;

    @Override
    @CacheEvict(value={"industry"}, allEntries=true)
    public void addObj(Industry t) {
        IndustryExample example = new IndustryExample();
        example.createCriteria().andCodeEqualTo(t.getCode()).andIsEnableEqualTo(YES_INABLED);
        if (this.industryMapper.countByExample(example) > 0) {
            throw new CommonException("\u884c\u4e1a\u7f16\u7801\u5df2\u7ecf\u5b58\u5728!");
        }
        this.industryMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"industry"}, allEntries=true)
    public void deleteObjById(String id) {
        this.industryMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"industry"}, allEntries=true)
    public void modifyObj(Industry t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.industryMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"industry"}, keyGenerator="redisKeyGenerator")
    public Industry queryObjById(String id) {
        return this.industryMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"industry"}, keyGenerator="redisKeyGenerator")
    public List<Industry> queryAllObjByExample(IndustryExample example) {
        return this.industryMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"industry"}, keyGenerator="redisKeyGenerator")
    public PageView<Industry> queryObjByPage(IndustryExample example) {
        PageView<Industry> pageView = example.getPageView();
        pageView.setQueryResult(this.industryMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"industry"}, keyGenerator="redisKeyGenerator")
    public List<Industry> queryAllObj() {
        IndustryExample example = new IndustryExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List<Industry> allList = this.industryMapper.selectByExample(example);
        List<Industry> list = this.eachParent(allList);
        return list;
    }

    private List<Industry> eachParent(List<Industry> allList) {
        ArrayList<Industry> parentList = new ArrayList<Industry>();
        ArrayList<Industry> childList = new ArrayList<Industry>();
        for (Industry industry : allList) {
            String parentId = industry.getParentId();
            if (StringUtils.isBlank((String)parentId)) {
                parentList.add(industry);
                continue;
            }
            childList.add(industry);
        }
        for (int i = 0; i < parentList.size(); ++i) {
            Industry industryParent = (Industry)parentList.get(i);
            ArrayList<Industry> newList = new ArrayList<Industry>();
            for (int j = 0; j < childList.size(); ++j) {
                Industry industryChild = (Industry)childList.get(j);
                if (!industryParent.getId().equals(industryChild.getParentId())) continue;
                newList.add(industryChild);
            }
            industryParent.setIndustryList(newList);
        }
        return parentList;
    }

    @Override
    @Cacheable(value={"industry"}, keyGenerator="redisKeyGenerator")
    public List<Industry> queryByParentId(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            return null;
        }
        IndustryExample example = new IndustryExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(YES_INABLED);
        List<Industry> list = this.industryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (Industry industry : list) {
            industry.setIndustryList(this.queryByParentId(industry.getId()));
        }
        return list;
    }

    @Override
    @Cacheable(value={"industry"}, keyGenerator="redisKeyGenerator")
    public List<Industry> findTheNextCascadedIndustryInfo(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            return null;
        }
        IndustryExample example = new IndustryExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(YES_INABLED);
        List<Industry> list = this.industryMapper.selectByExample(example);
        return list;
    }

    @Override
    @CacheEvict(value={"industry"}, allEntries=true)
    public void deleteCascadedIndustryInfo(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            throw new CommonException("\u4e0a\u4e00\u7ea7\u4f20\u7684id\u4e3a\u7a7a!");
        }
        this.industryMapper.deleteByPrimaryKey(parentId);
        IndustryExample example = new IndustryExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(YES_INABLED);
        List<Industry> list = this.industryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (Industry industry : list) {
            this.deleteCascadedIndustryInfo(industry.getId());
        }
    }
}

