/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.exception;

import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonException
extends RuntimeException {
    private static final long serialVersionUID = 220200304312901149L;
    private static Logger logger = LoggerFactory.getLogger(CommonException.class);
    public static final Pattern SERIALIZE_PREFIX_PARTTERN = Pattern.compile("CommonException_content_start_\\s(.*?)\\s_end_", 32);
    private static final String SERIALIZE_PREFIX = "CommonException_content_start_\n{0}\n_end_";
    private String i18nCode;
    private Object[] i18nArgs;
    private Object data;

    public CommonException() {
    }

    public CommonException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public CommonException(String message, Throwable cause) {
        super(message, cause);
    }

    public CommonException(String message) {
        super(message);
    }

    public CommonException(String message, String i18nCode) {
        super(message);
        this.setI18nCode(i18nCode);
    }

    public CommonException(String message, String i18nCode, Object ... i18nArgs) {
        super(message);
        this.setI18nArgs(i18nArgs);
        this.setI18nCode(i18nCode);
    }

    public CommonException(String message, Object data) {
        super(message);
        this.setData(data);
    }

    public CommonException(Throwable cause) {
        super(cause);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getI18nCode() {
        return this.i18nCode;
    }

    public void setI18nCode(String i18nCode) {
        this.i18nCode = i18nCode;
    }

    public Object[] getI18nArgs() {
        return this.i18nArgs;
    }

    public void setI18nArgs(Object[] i18nArgs) {
        this.i18nArgs = i18nArgs;
    }

    @Override
    public String toString() {
        HashMap<String, String> exceptionContent = new HashMap<String, String>();
        exceptionContent.put("i18nCode", this.getI18nCode());
        exceptionContent.put("message", this.getMessage());
        try {
            String json = JsonUtils.writeValueAsString(exceptionContent);
            return MessageFormat.format(SERIALIZE_PREFIX, json);
        }
        catch (Exception e) {
            logger.warn("CommonException toString err", (Throwable)e);
            return super.toString();
        }
    }

    public static CommonException matchCommonException(String content) {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        Matcher matcher = SERIALIZE_PREFIX_PARTTERN.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String json = matcher.group(1);
        try {
            JsonNode treeNode = JsonUtils.getObjectMapper().readTree(json);
            if (!treeNode.isObject()) {
                return null;
            }
            String message = null;
            if (!treeNode.get("message").isNull()) {
                message = treeNode.get("message").asText();
            }
            String i18nCode = null;
            if (!treeNode.get("i18nCode").isNull()) {
                i18nCode = treeNode.get("i18nCode").asText();
            }
            return new CommonException(message, i18nCode);
        }
        catch (IOException e) {
            logger.warn("match CommomException from String failed", (Throwable)e);
            return null;
        }
    }
}

