/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanyAddressMapper;
import com.els.base.company.entity.CompanyAddress;
import com.els.base.company.entity.CompanyAddressExample;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyAddressService")
public class CompanyAddressServiceImpl
implements CompanyAddressService {
    @Resource
    protected CompanyAddressMapper companyAddressMapper;

    @Transactional
    @CacheEvict(value={"companyAddress"}, allEntries=true)
    public void addObj(CompanyAddress t) {
        if (StringUtils.isBlank((String)t.getAddress())) {
            throw new CommonException("\u5730\u5740\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "base_canot_be_null", new Object[]{"\u5730\u5740"});
        }
        if (StringUtils.isBlank((String)t.getAddressCode())) {
            throw new CommonException("\u516c\u53f8\u5730\u5740\u7f16\u7801\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "base_canot_be_null", new Object[]{"\u516c\u53f8\u5730\u5740\u7f16\u7801"});
        }
        CompanyAddressExample companyAddressExample = new CompanyAddressExample();
        companyAddressExample.createCriteria().andCompanyIdEqualTo(t.getCompanyId()).andAddressCodeEqualTo(t.getAddressCode()).andLanguageCodeEqualTo(t.getLanguageCode());
        if (this.companyAddressMapper.countByExample(companyAddressExample) > 0) {
            throw new CommonException("\u8bed\u8a00\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa", "base_is_exists", new Object[]{"\u8be5\u516c\u53f8\u4e0b\u8bed\u8a00\u7f16\u7801"});
        }
        t.setCreateTime(new Date());
        t.setUpdateTime(new Date());
        if (t.getDefaultAddress() != null && t.getDefaultAddress() == Constant.YES_INT) {
            CompanyAddressExample example = new CompanyAddressExample();
            example.createCriteria().andCompanyIdEqualTo(t.getCompanyId()).andAddressCodeEqualTo(t.getAddressCode());
            List<CompanyAddress> companyAddressList = this.companyAddressMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(companyAddressList)) {
                for (CompanyAddress companyAddress : companyAddressList) {
                    companyAddress.setDefaultAddress(Constant.NO_INT);
                    this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
                }
            }
        }
        this.companyAddressMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyAddress"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyAddressMapper.deleteByPrimaryKey(id);
    }

    @Transactional
    @CacheEvict(value={"companyAddress"}, allEntries=true)
    public void modifyObj(CompanyAddress t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (StringUtils.isBlank((String)t.getAddress())) {
            throw new CommonException("\u5730\u5740\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "base_canot_be_null", new Object[]{"\u5730\u5740"});
        }
        CompanyAddressExample companyAddressExample = new CompanyAddressExample();
        companyAddressExample.createCriteria().andCompanyIdEqualTo(t.getCompanyId()).andAddressCodeEqualTo(t.getAddressCode()).andLanguageCodeEqualTo(t.getLanguageCode()).andIdNotEqualTo(t.getId());
        if (this.companyAddressMapper.countByExample(companyAddressExample) > 0) {
            throw new CommonException("\u8bed\u8a00\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa", "base_is_exists", new Object[]{"\u8be5\u516c\u53f8\u4e0b\u8bed\u8a00\u7f16\u7801"});
        }
        t.setUpdateTime(new Date());
        if (t.getDefaultAddress() != null && t.getDefaultAddress() == Constant.YES_INT) {
            CompanyAddressExample example = new CompanyAddressExample();
            example.createCriteria().andCompanyIdEqualTo(t.getCompanyId()).andAddressCodeEqualTo(t.getAddressCode());
            List<CompanyAddress> companyAddressList = this.companyAddressMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(companyAddressList)) {
                for (CompanyAddress companyAddress : companyAddressList) {
                    companyAddress.setDefaultAddress(Constant.NO_INT);
                    this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
                }
            }
        }
        this.companyAddressMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyAddress"}, keyGenerator="redisKeyGenerator")
    public CompanyAddress queryObjById(String id) {
        return this.companyAddressMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyAddress"}, keyGenerator="redisKeyGenerator")
    public List<CompanyAddress> queryAllObjByExample(CompanyAddressExample example) {
        return this.companyAddressMapper.selectByExample(example);
    }

    @Cacheable(value={"companyAddress"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyAddress> queryObjByPage(CompanyAddressExample example) {
        PageView<CompanyAddress> pageView = example.getPageView();
        pageView.setQueryResult(this.companyAddressMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"companyAddress"}, keyGenerator="redisKeyGenerator")
    public List<CompanyAddress> queryByCompanyId(String companyId) {
        if (StringUtils.isEmpty((String)companyId)) {
            throw new CommonException("\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u516c\u53f8ID"});
        }
        CompanyAddressExample companyAddressExample = new CompanyAddressExample();
        companyAddressExample.or().andCompanyIdEqualTo(companyId).andIsEnableEqualTo(Constant.YES_INT);
        return this.queryAllObjByExample(companyAddressExample);
    }

    @Override
    @CacheEvict(value={"companyAddress"}, allEntries=true)
    public void deleteByExample(CompanyAddressExample example) {
        this.companyAddressMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"companyAddress"}, allEntries=true)
    public void insertBatch(List<CompanyAddress> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u516c\u53f8\u5730\u5740\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u516c\u53f8\u5730\u5740\u5217\u8868"});
        }
        for (CompanyAddress address : list) {
            this.companyAddressMapper.insertSelective(address);
        }
    }

    @Override
    @CacheEvict(value={"companyAddress"}, allEntries=true)
    public int isEnable(String id, Integer isEnable) {
        CompanyAddress companyAddress = this.companyAddressMapper.selectByPrimaryKey(id);
        companyAddress.setIsEnable(isEnable);
        return this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
    }

    @Override
    public List<CompanyAddress> queryByCompanyIdAndAddressCodeAndLanguageCode(String companyId, String addressCode, String languageCode) {
        if (StringUtils.isEmpty((String)companyId)) {
            throw new CommonException("\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u516c\u53f8ID"});
        }
        CompanyAddressExample companyAddressExample = new CompanyAddressExample();
        CompanyAddressExample.Criteria criteria = companyAddressExample.createCriteria();
        criteria.andCompanyIdEqualTo(companyId).andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isNotBlank((String)addressCode)) {
            criteria.andAddressCodeEqualTo(addressCode);
        }
        if (StringUtils.isNotBlank((String)languageCode)) {
            criteria.andLanguageCodeEqualTo(languageCode);
        }
        return this.companyAddressMapper.selectByExample(companyAddressExample);
    }

    @Override
    @CacheEvict(value={"companyAddress"}, allEntries=true)
    public void updateDefaultAddress(String companyId, String addressCode, String languageCode, Integer isDefaultAddress) {
        if (StringUtils.isEmpty((String)companyId)) {
            throw new CommonException("\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u516c\u53f8ID"});
        }
        if (StringUtils.isEmpty((String)addressCode)) {
            throw new CommonException("\u5b50\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u5b50\u516c\u53f8\u7f16\u7801"});
        }
        if (StringUtils.isEmpty((String)languageCode)) {
            throw new CommonException("\u516c\u53f8\u8bed\u8a00\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u516c\u53f8\u8bed\u8a00\u7f16\u7801"});
        }
        if (isDefaultAddress == null) {
            throw new CommonException("\u9ed8\u8ba4\u5730\u5740\u7f16\u7801\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u9ed8\u8ba4\u5730\u5740\u7f16\u7801"});
        }
        CompanyAddressExample companyAddressExample = new CompanyAddressExample();
        CompanyAddressExample.Criteria criteria = companyAddressExample.createCriteria();
        criteria.andCompanyIdEqualTo(companyId);
        criteria.andAddressCodeEqualTo(addressCode);
        List<CompanyAddress> list = this.companyAddressMapper.selectByExample(companyAddressExample);
        if (CollectionUtils.isNotEmpty(list)) {
            for (CompanyAddress companyAddress : list) {
                if (companyAddress.getLanguageCode().equals(languageCode)) {
                    companyAddress.setDefaultAddress(Constant.YES_INT);
                } else {
                    companyAddress.setDefaultAddress(Constant.NO_INT);
                }
                this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
            }
        }
    }

    @CacheEvict(value={"companyAddress"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyAddress> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.companyAddressMapper.insertBatch(list);
    }
}

