/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.command.MergeCompanyCommand;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.FinishFlagUtils;
import com.els.base.company.web.vo.MergeCompany;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.BaseCommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f01\u4e1a\u4fe1\u606f")
@Controller
@RequestMapping(value={"company"})
public class CompanyController {
    private static final String sourceCompanyId = null;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    protected BaseCommandInvoker invoker;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserService userService;
    @Resource
    protected CompanyPartnerMapper companyPartnerMapper;
    @Resource
    protected CompanyAddressService companyAddressService;
    @Resource
    protected GenerateCodeService generateCodeService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6ce8\u518c")
    @RequestMapping(value={"front/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Company company, @RequestParam String mailVerifCode, HttpSession session) {
        if (company == null) {
            throw new CommonException("\u516c\u53f8\u6ce8\u518c\u4fe1\u606f", "base_canot_be_null", new Object[]{"\u6ce8\u518c\u4fe1\u606f"});
        }
        if (StringUtils.isBlank((String)company.getCompanyFullName())) {
            throw new CommonException("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u516c\u53f8\u540d\u79f0"});
        }
        if (company.getCompanyFullName().length() > 255 || !company.getCompanyFullName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+")) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", new Object[]{"\u4f01\u4e1a\u5168\u79f0"});
        }
        if (StringUtils.isBlank((String)company.getMobilephone())) {
            throw new CommonException("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u624b\u673a\u53f7\u7801"});
        }
        String mailVerfCodeInSession = "123456";
        if (StringUtils.isBlank((String)mailVerifCode) || StringUtils.isBlank((String)mailVerfCodeInSession) || !mailVerfCodeInSession.equals(mailVerifCode)) {
            throw new CommonException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        String code = this.companyService.register(ProjectUtils.getProject(), company);
        return ResponseResult.success((Object)code);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Company company) {
        company.setProjectId(ProjectUtils.getProjectId());
        this.companyService.modifyObj(company);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        this.companyService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u4e0b\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findSupCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupCompanyByPage(@RequestParam(defaultValue="qualified") String roleEnum, @ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) QueryParamWapper wapper) {
        String purCompanyId;
        PageView<Company> pageData;
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(pageData = this.companyService.querySupplerCompanies(purCompanyId = ProjectUtils.getProject().getCompanyId(), example, roleEnum)).getQueryResult())) {
            return ResponseResult.success(pageData);
        }
        for (Company company : pageData.getQueryResult()) {
            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample.createCriteria();
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            List companyUserRefList = this.companyUserRefService.queryAllObjByExample((IExample)companyUserRefExample);
            if (CollectionUtils.isEmpty((Collection)companyUserRefList)) continue;
            ArrayList<String> userIds = new ArrayList<String>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            company.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
        }
        return ResponseResult.success(pageData);
    }

    @Deprecated
    @ApiOperation(httpMethod="GET", value="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u4e0b\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findSupplyCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupplyCompanyByPage(@RequestParam(defaultValue="qualified") String roleEnum, @ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        String purCompanyId;
        PageView<Company> pageData;
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        CompanyExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        if (CollectionUtils.isEmpty((Collection)(pageData = this.companyService.querySupplerCompanies(purCompanyId = ProjectUtils.getProject().getCompanyId(), example, roleEnum)).getQueryResult())) {
            return ResponseResult.success(pageData);
        }
        for (Company company : pageData.getQueryResult()) {
            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample.createCriteria();
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            List companyUserRefList = this.companyUserRefService.queryAllObjByExample((IExample)companyUserRefExample);
            if (CollectionUtils.isEmpty((Collection)companyUserRefList)) continue;
            ArrayList<String> userIds = new ArrayList<String>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            company.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u4e0b\u7684\u4f9b\u5e94\u5546\uff08\u6b64\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u65b0\u589e\u4e86\u4f9b\u5e94\u5546\u7684\u89d2\u8272\u662f\u5426\u5408\u683c\uff0c\u6f5c\u5165\uff0c\u6dd8\u6c70\uff0c\u4f9b\u5e94\u5546\u4e34\u65f6\u7f16\u7801\u7b49\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Company", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findSupplyCompanyAndSupplierStatusByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupplyCompanyAndSupplierStatusByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws JsonParseException, JsonMappingException, IOException {
        String purCompanyId;
        PageView<Company> pageData;
        String roleCode = wapper.getParamValue("partnerRoleCode");
        if (roleCode != null) {
            wapper.removeParam(roleCode);
        }
        List<String> list = null;
        if (StringUtils.isNotBlank((String)roleCode)) {
            list = (List<String>)JsonUtils.convertCollection((String)roleCode, List.class, null, (Class[])new Class[]{String.class});
        }
        if (CollectionUtils.isEmpty(list)) {
            list = Arrays.asList("stranger", "potenial", "qualified");
        }
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(pageData = this.companyService.querySupplerCompaniesAndRoleInfo(purCompanyId = ProjectUtils.getProject().getCompanyId(), example, list)).getQueryResult())) {
            return ResponseResult.success(pageData);
        }
        for (Company company : pageData.getQueryResult()) {
            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample.createCriteria();
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            List companyUserRefList = this.companyUserRefService.queryAllObjByExample((IExample)companyUserRefExample);
            if (CollectionUtils.isEmpty((Collection)companyUserRefList)) continue;
            ArrayList<String> userIds = new ArrayList<String>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            String supplierTemporaryCode = this.generateCodeService.getNextCode("SUPPLIER_TEMPORARY_CODE");
            company.setSupplierTemporaryCode(supplierTemporaryCode);
            company.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
            CompanyPartnerExample companyPartnerExample = new CompanyPartnerExample();
            companyPartnerExample.createCriteria().andPartnerCompanyIdEqualTo(company.getId()).andPartnerRoleCodeIn((List)list);
            List<CompanyPartner> companyPartnerList = this.companyPartnerMapper.selectByExample(companyPartnerExample);
            if (!CollectionUtils.isNotEmpty(companyPartnerList)) continue;
            company.setPartnerRoleCode(companyPartnerList.get(0).getPartnerRoleCode());
            company.setPartnerRoleName(companyPartnerList.get(0).getPartnerRoleName());
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u4e0b\u7684\u9500\u552e\u5546")
    @RequestMapping(value={"service/findSaleCompaniesByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findSaleCompaniesByPage(@ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        String companyId = CompanyUtils.currentCompanyId();
        PageView<Company> pageData = this.companyService.queryPurchaseCompaniesByPage(companyId, example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5f53\u524d\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/findCurrentCompany"})
    @ResponseBody
    public ResponseResult<Company> findCurrentCompany() {
        Company company = CompanyUtils.currentCompany();
        return ResponseResult.success((Object)company);
    }

    @ApiOperation(httpMethod="POST", value="\u6dfb\u52a0\u4f01\u4e1a\u4f19\u4f34")
    @RequestMapping(value={"service/addCompanyAsPartner"})
    @ResponseBody
    public ResponseResult<String> addCompanyAsPartner(@RequestBody CompanyPartner companyPartner) {
        if (companyPartner.getPartner() == null) {
            throw new CommonException("\u4f01\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4f01\u4e1a\u4fe1\u606f"});
        }
        if (StringUtils.isBlank((String)companyPartner.getPartner().getId())) {
            // empty if block
        }
        if (StringUtils.isBlank((String)companyPartner.getPartnerRoleCode())) {
            throw new CommonException("\u4f19\u4f34\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4f19\u4f34\u89d2\u8272\u7f16\u7801"});
        }
        companyPartner.setCompanyId(CompanyUtils.currentCompanyId());
        companyPartner.setProjectId(ProjectUtils.getProjectId());
        this.companyService.addCompanyAsSupplier(companyPartner);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528/\u7981\u6b62\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<Integer> isEnable(@ApiParam(value="\u4f01\u4e1aid") @RequestParam(required=true) String id, @ApiParam(value="\u542f\u7528\u4f201,\u7981\u7528\u4f200") Integer isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("Id\u4e3a\uff0c\u7a7a\u4e0d\u80fd\u7981\u7528\u6216\u542f\u7528", "id_is_blank");
        }
        int result = this.companyService.isEnable(id, isEnable);
        return ResponseResult.success((Object)result);
    }

    @ApiOperation(httpMethod="POST", value="\u7ed9\u4f9b\u5e94\u5546\u6dfb\u52a0\u8d26\u53f7")
    @RequestMapping(value={"service/addSupplierIntoUser"})
    @ResponseBody
    public ResponseResult<String> addSupplierIntoUser(@ApiParam(value="\u4f9b\u5e94\u5546ID") @RequestParam(required=true) String supplierId, @ApiParam(value="\u4f9b\u5e94\u5546\u767b\u9646\u8d26\u53f7\u540d\u79f0") @RequestBody User user) {
        if (StringUtils.isBlank((String)supplierId)) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isBlank((String)user.getLoginName())) {
            throw new CommonException("\u7528\u6237\u8d26\u53f7\u540d\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u8d26\u53f7\u540d"});
        }
        if (StringUtils.isBlank((String)user.getPassword())) {
            throw new CommonException("\u7528\u6237\u8d26\u53f7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u8d26\u53f7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (StringUtils.isBlank((String)user.getMobilePhone())) {
            throw new CommonException("\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u624b\u673a\u53f7"});
        }
        if (StringUtils.isBlank((String)user.getEmail())) {
            throw new CommonException("\u7528\u6237\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u90ae\u7bb1"});
        }
        if (StringUtils.isBlank((String)user.getNickName())) {
            throw new CommonException("\u7528\u6237\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u6635\u79f0"});
        }
        user.setProjectCode(ProjectUtils.getProject().getProjectCode());
        Company company = (Company)this.companyService.queryObjById(supplierId);
        if (company == null) {
            throw new CommonException("\u4f9b\u5e94\u5546 '" + supplierId + "\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u4f9b\u5e94\u5546"});
        }
        this.companyUserRefService.addSupplierIntoUser(company, user);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ed9\u91c7\u8d2d\u7528\u6237\u6dfb\u52a0\u4f9b\u5e94\u5546\u8d26\u53f7\u5173\u7cfb")
    @RequestMapping(value={"service/addSupplierIntoPurchaser"})
    @ResponseBody
    public ResponseResult<String> addSupplierIntoPurchaser(@ApiParam(value="\u7528\u6237ID") @RequestParam(required=true) String userId, @ApiParam(value="\u4f9b\u5e94\u5546\u5217\u8868") @RequestBody List<Company> companyList) {
        this.companyPurRefService.addSupplierIntoPurchaser(userId, CompanyUtils.currentCompany(), companyList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u7528\u6237\u5bf9\u5e94\u4f9b\u5e94\u5546\u4ee5\u53ca\u91c7\u8d2d\u5546\u7528\u6237")
    @RequestMapping(value={"service/findFriendGroup"})
    @ResponseBody
    public ResponseResult<List<FriendGroup>> findFriendGroup() {
        String userId = SpringSecurityUtils.getLoginUserId();
        List<FriendGroup> supplierUserList = this.companyPurRefService.querySupplyFriendGroup(userId);
        List<FriendGroup> purchaseUserList = this.companyPurRefService.queryPurchaseFriendGroup(CompanyUtils.currentCompanyId());
        ArrayList<FriendGroup> friendGroupList = new ArrayList<FriendGroup>();
        if (CollectionUtils.isNotEmpty(purchaseUserList)) {
            friendGroupList.addAll(purchaseUserList);
        }
        if (CollectionUtils.isNotEmpty(supplierUserList)) {
            friendGroupList.addAll(supplierUserList);
        }
        return ResponseResult.success(friendGroupList);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u4f01\u4e1a\u4e0b\u5168\u90e8\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findAllSupplyCompany"})
    @ResponseBody
    public ResponseResult<List<Company>> findAllSupplyCompany(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        List<Company> companyList = this.companyService.queryAllSupplerCompanies(CompanyUtils.currentCompanyId(), example);
        return ResponseResult.success(companyList);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u7684\u516c\u53f8\u7684\u5e10\u53f7", httpMethod="GET")
    @RequestMapping(value={"service/findByCompany"})
    @ResponseBody
    public ResponseResult<PageView<User>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        PageView<User> list = this.companyUserRefService.queryUserListOfCompanyByPage(CompanyUtils.currentCompanyId(), example);
        return ResponseResult.success(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u7684\u516c\u53f8\u7684\u5e10\u53f7\uff08\u73b0\u5728\u7528\u7684\u901a\u7528\u67e5\u8be2\u6761\u4ef6\uff09", httpMethod="POST")
    @RequestMapping(value={"service/findUserByCurrentCompany "})
    @ResponseBody
    public ResponseResult<PageView<User>> findUserByCurrentCompany(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<User> list = this.companyUserRefService.queryUserListOfCompanyByPage(CompanyUtils.currentCompanyId(), example);
        return ResponseResult.success(list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u7684\u516c\u53f8\u7684\u5e10\u53f7", httpMethod="GET")
    @RequestMapping(value={"service/findUserBySupCompany"})
    @ResponseBody
    public ResponseResult<PageView<User>> findUserBySupCompany(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        PageView<User> list = this.companyUserRefService.queryUserListOfOtherCompanyByPage(CompanyUtils.currentCompanyId(), example);
        return ResponseResult.success(list);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u767b\u5f55\u7684\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findCompanyInformation"})
    @ResponseBody
    public ResponseResult<Company> findCompany(@RequestParam(required=false) String supCompanySrmCode) {
        Company company = null;
        company = StringUtils.isBlank((String)supCompanySrmCode) ? CompanyUtils.currentCompany() : this.companyService.queryCompanyByCode(supCompanySrmCode);
        return ResponseResult.success((Object)company);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"service/updateCompany"})
    @ResponseBody
    public ResponseResult<Map<String, Integer>> updateCompany(@RequestBody Company company) {
        Integer companyStatus = FinishFlagUtils.getFinishFlag(company);
        company.setFinishFlag(companyStatus);
        company.setCompanyFullName(null);
        this.companyService.modifyCompany(ProjectUtils.getProject(), company);
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        map.put("enterpriseBaseInfo", companyStatus);
        return ResponseResult.success(map);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5408\u5e76")
    @RequestMapping(value={"service/mergeCompany"})
    @ResponseBody
    public ResponseResult<String> mergeCompany(@RequestBody MergeCompany vo) {
        MergeCompanyCommand command = new MergeCompanyCommand(vo.getTargetCompanyId(), vo.getSourceCompanyIdList());
        this.invoker.invoke((BaseCommand)command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u5c5e\u6027")
    @RequestMapping(value={"service/selectBysupplyProperties"})
    @ResponseBody
    public ResponseResult<PageView<Company>> selectBysupplyProperties(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestParam(defaultValue="qualified") String roleEnum, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyService.queryObjByPage((IExample)example);
        List companyList = null;
        companyList = pageData.getQueryResult().stream().filter(b -> !"".equals(b.getSupplyProperties()) && null != b.getSupplyProperties()).collect(Collectors.toList());
        companyList = companyList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Company>(Comparator.comparing(Company::getSupplyProperties))), ArrayList::new));
        pageData.setQueryResult(companyList);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u8d26\u6237\u7ec4")
    @RequestMapping(value={"service/selectBySupAccountGroup"})
    @ResponseBody
    public ResponseResult<PageView<Company>> selectBySupAccountGroup(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestParam(defaultValue="qualified") String roleEnum, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyService.queryObjByPage((IExample)example);
        List companyList = pageData.getQueryResult();
        companyList = companyList.stream().filter(b -> !"".equals(b.getSupAccountGroup()) && null != b.getSupAccountGroup()).collect(Collectors.toList());
        companyList = companyList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Company>(Comparator.comparing(Company::getSupAccountGroup))), ArrayList::new));
        pageData.setQueryResult(companyList);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5206\u9875\u67e5\u8be2\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findCompanyByPage(@ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseOrderHeader") @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyService.queryObjByPage((IExample)example);
        List companyNameList = pageData.getQueryResult();
        companyNameList = companyNameList.stream().filter(b -> !"".equals(b.getCompanyFullName()) && null != b.getCompanyFullName()).collect(Collectors.toList());
        companyNameList = companyNameList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Company>(Comparator.comparing(Company::getCompanyFullName))), ArrayList::new));
        pageData.setQueryResult(companyNameList);
        return ResponseResult.success((Object)pageData);
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\uff0c\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelBySelect(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Company") @RequestBody(required=false) QueryParamWapper wapper, String queryParams, HttpServletResponse response) throws IOException, ParseException, WriteException {
        String roleEnum = "qualified";
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)companyExample, (QueryParamWapper)wapper);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)companyExample, (QueryParamWapper)queryParamWapper);
        }
        List<Company> companyList = this.companyService.querySupplerCompany(purCompanyId, companyExample, roleEnum);
        List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKey();
        String fileName = String.format("\u4f9b\u5e94\u5546\u4e3b\u6570\u636e.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        FileData fileData = this.createEmptyPDF(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), fileName);
        File file = fileData.toFile();
        FileOutputStream os = new FileOutputStream(file);
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)os, titleAndModelKeys, companyList, (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e", null, (int)0);
        try {
            writableWorkbook.write();
            os.flush();
        }
        catch (Exception var16) {
            this.logger.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", (Throwable)var16);
        }
        finally {
            writableWorkbook.close();
            os.close();
        }
        return ResponseResult.success((Object)fileData);
    }

    private void setDownLoadHeader(HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/x-msdownload;");
    }

    private FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename);
        pdfFile.setFileSuffix("xls");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }

    public List<TitleAndModelKey> getTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"companySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"companyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b80\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8857\u9053/\u95e8\u724c\u53f7", (String)"address"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fd\u5bb6", (String)"country"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5730\u533a", (String)"city"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u624b\u673a\u53f7\u7801", (String)"mobilephone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fa\u5b9a\u7535\u8bdd", (String)"telephone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f20\u771f", (String)"fax"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"E-mail", (String)"email"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed8\u6b3e\u6761\u4ef6\u4ee3\u7801", (String)"payConditionsCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed8\u6b3e\u6761\u4ef6\u63cf\u8ff0", (String)"payConditionsDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ec4\u4ee3\u7801", (String)"groupCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ee3\u8868\u540d\u79f0", (String)"delegateType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"businessType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u4e1a\u7c7b\u578b", (String)"industrialType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u4e1a", (String)"industryDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5916\u90e8\u5236\u9020\u5546", (String)"externalManufacturer"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7edf\u9a6d\u79d1\u76ee", (String)"reconciliationAccountName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u8d27\u5e01", (String)"orderCurren"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fd\u9645\u8d38\u6613\u6761\u4ef6", (String)"internationalTradeCondition"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9500\u552e\u5458", (String)"salesman"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9500\u552e\u5458\u8054\u7cfb\u53f7\u7801", (String)"salesmanPhone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u4e8e\u6536\u8d27\u7684\u53d1\u7968\u9a8c\u8bc1", (String)"invoiceVerify"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u81ea\u52a8\u5efa\u7acb\u91c7\u8d2d\u8ba2\u5355", (String)"automaticPurchaseOrder"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u5458", (String)"purchasingStaff"));
        TitleAndModelKey plannedDeliveryTime = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u5212\u4ea4\u4ed8\u65f6\u95f4", (String)"plannedDeliveryTime");
        plannedDeliveryTime.setToObjConverter((StrToObjConverter)dateConverter);
        plannedDeliveryTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(plannedDeliveryTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5c5e\u6027", (String)"supplyProperties"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u8d26\u6237\u7ec4", (String)"supAccountGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u94f6\u884c\u56fd\u5bb6\u4ee3\u7801", (String)"openingBank"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d26\u6237\u6301\u6709\u4eba\u59d3\u540d", (String)"corporationLegalPerson"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u94f6\u884c\u4ee3\u7801", (String)"bankLineNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u94f6\u884c\u540d\u79f0", (String)"bankName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u94f6\u884c\u8d26\u6237\u53f7\u7801", (String)"bankAccount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u94f6\u884c\u8d26\u6237\u53f7\u7801", (String)"bankCode"));
        return titleAndModelKeys;
    }
}

