/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.command;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanySapRelation;
import com.els.base.company.entity.CompanySapRelationExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanySapRelationService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class MergeCompanyCommand
extends BaseCommand<Void> {
    private static final long serialVersionUID = 1L;
    private String targetCompanyId;
    private List<String> sourceCompanyIdList;

    public MergeCompanyCommand(String targetCompanyId, List<String> sourceCompanyIdList) {
        this.targetCompanyId = targetCompanyId;
        this.sourceCompanyIdList = sourceCompanyIdList;
    }

    public Void execute(ICommandInvoker context) {
        Assert.isNotBlank((String)this.targetCompanyId, (String)"\u76ee\u6807\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(this.sourceCompanyIdList, (String)"\u5f85\u5408\u5e76\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
        this.sourceCompanyIdList = this.sourceCompanyIdList.stream().filter(companyId -> !companyId.equals(this.targetCompanyId)).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(this.sourceCompanyIdList)) {
            return null;
        }
        Company target = (Company)this.getCompanyService().queryObjById(this.targetCompanyId);
        Assert.isNotNull((Object)target, (String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u76ee\u6807\u7684\u4f9b\u5e94\u5546");
        List<Company> sourceCompanyList = this.getSourceCompanyList(this.sourceCompanyIdList);
        this.disableSourceCompany(this.sourceCompanyIdList);
        this.addRelation(target, sourceCompanyList);
        this.mergerRole(this.targetCompanyId, this.sourceCompanyIdList);
        this.mergeUser(this.targetCompanyId, this.sourceCompanyIdList);
        this.disableUser(sourceCompanyList);
        this.modifyTargetCompanySapCode(target, sourceCompanyList);
        return null;
    }

    private void modifyTargetCompanySapCode(Company target, List<Company> sourceCompanyList) {
        List sapCompanyCodeList = sourceCompanyList.stream().flatMap(company -> Arrays.stream(company.getCompanySapCode().split(","))).collect(Collectors.toList());
        sapCompanyCodeList.addAll(Arrays.asList(target.getCompanySapCode().split(",")));
        sapCompanyCodeList = sapCompanyCodeList.stream().distinct().collect(Collectors.toList());
        sapCompanyCodeList.sort(String::compareTo);
        Company tmp = new Company();
        tmp.setId(target.getId());
        tmp.setCompanySapCode(StringUtils.join(sapCompanyCodeList, (String)","));
        this.getCompanyService().modifyObj(tmp);
    }

    private List<Company> getSourceCompanyList(List<String> sourceCompanyIdList) {
        CompanyExample example = new CompanyExample();
        example.createCriteria().andIdIn((List)sourceCompanyIdList);
        List sourceCompanyList = this.getCompanyService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)sourceCompanyList) || sourceCompanyList.size() != sourceCompanyIdList.size()) {
            throw new CommonException("\u7cfb\u7edf\u4e0d\u5b58\u5728\u8be5\u5f85\u5408\u5e76\u7684\u4f9b\u5e94\u5546");
        }
        for (Company company : sourceCompanyList) {
            if (Constant.YES_INT.equals(company.getIsEnable())) continue;
            throw new CommonException(String.format("\u4f9b\u5e94\u5546 [%s] \u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u5408\u5e76", company.getCompanySapCode()));
        }
        return sourceCompanyList;
    }

    private void disableUser(List<Company> sourceCompanyList) {
        List loginNameList = sourceCompanyList.stream().map(Company::getCompanyCode).collect(Collectors.toList());
        UserExample userExample = new UserExample();
        userExample.createCriteria().andLoginNameIn(loginNameList);
        UserService userService = (UserService)SpringContextHolder.getOneBean(UserService.class);
        List list = userService.queryAllObjByExample((IExample)userExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (User user : list) {
            if (Constant.NO_INT.equals(user.getIsEnable())) continue;
            userService.disableUserById(user.getId());
        }
    }

    private void mergeUser(String targetCompanyId, List<String> sourceCompanyIdList) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdIn((List)sourceCompanyIdList);
        CompanyUserRef ref = new CompanyUserRef();
        ref.setCompanyId(targetCompanyId);
        ((CompanyUserRefService)SpringContextHolder.getOneBean(CompanyUserRefService.class)).modifyByExample(ref, example);
    }

    private void mergerRole(String targetCompanyId, List<String> sourceCompanyIdList) {
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andCompanyIdIn(sourceCompanyIdList);
        Role tmp = new Role();
        tmp.setCompanyId(targetCompanyId);
        ((RoleService)SpringContextHolder.getOneBean(RoleService.class)).modifyByExample(tmp, roleExample);
    }

    private void addRelation(Company target, List<Company> sourceCompanyList) {
        List sourceCompanyIdList = sourceCompanyList.stream().map(Company::getId).collect(Collectors.toList());
        CompanySapRelationExample example = new CompanySapRelationExample();
        example.createCriteria().andCompanyIdIn(sourceCompanyIdList);
        CompanySapRelation relation = new CompanySapRelation();
        relation.setCompanyId(target.getId());
        relation.setCompanyCode(target.getCompanyCode());
        this.getCompanySapRelationService().modifyByExample(relation, example);
    }

    private void disableSourceCompany(List<String> sourceCompanyIdList) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andIdIn((List)sourceCompanyIdList);
        Company tmp = new Company();
        tmp.setIsEnable(Constant.NO_INT);
        this.getCompanyService().modifyByExample(tmp, companyExample);
    }

    private CompanyService getCompanyService() {
        return (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    }

    private CompanySapRelationService getCompanySapRelationService() {
        return (CompanySapRelationService)SpringContextHolder.getOneBean(CompanySapRelationService.class);
    }
}

