/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.CompanyAddress;
import com.els.base.company.entity.CompanyAddressExample;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u516c\u53f8\u4e2a\u6027\u5730\u5740")
@Controller
@RequestMapping(value={"companyAddress"})
public class CompanyAddressController {
    @Resource
    protected CompanyAddressService companyAddressService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u516c\u53f8\u4e2a\u6027\u5730\u5740")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyAddress companyAddress) {
        companyAddress.setProjectId(ProjectUtils.getProjectId());
        companyAddress.setCompanyId(CompanyUtils.currentCompanyId());
        if (companyAddress.getIsEnable() == null) {
            companyAddress.setIsEnable(Constant.YES_INT);
        }
        this.companyAddressService.addObj(companyAddress);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u516c\u53f8\u4e2a\u6027\u5730\u5740")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyAddress companyAddress) {
        if (StringUtils.isBlank((String)companyAddress.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (companyAddress.getIsEnable() == null) {
            companyAddress.setIsEnable(Constant.YES_INT);
        }
        companyAddress.setProjectId(ProjectUtils.getProjectId());
        companyAddress.setCompanyId(CompanyUtils.currentCompanyId());
        this.companyAddressService.modifyObj(companyAddress);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u516c\u53f8\u4e2a\u6027\u5730\u5740")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyAddress companyAddress = (CompanyAddress)this.companyAddressService.queryObjById(id);
        if (companyAddress == null) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        this.companyAddressService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u516c\u53f8\u4e2a\u6027\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyAddress", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyAddress>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyAddressExample example = new CompanyAddressExample();
        example.setPageView((PageView<CompanyAddress>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" ADDRESS_CODE ASC ");
        CompanyAddressExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyAddressService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528/\u7981\u6b62\u4f01\u4e1a\u5730\u5740\u4fe1\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<Integer> isEnable(@ApiParam(value="\u4f01\u4e1a\u5730\u5740ID") @RequestParam(required=true) String id, @ApiParam(value="\u542f\u7528\u4f201,\u7981\u7528\u4f200") Integer isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("Id\u4e3a\uff0c\u7a7a\u4e0d\u80fd\u7981\u7528\u6216\u542f\u7528", "id_is_blank");
        }
        int result = this.companyAddressService.isEnable(id, isEnable);
        return ResponseResult.success((Object)result);
    }

    @ApiOperation(httpMethod="GET", value="\u6839\u636e\u516c\u53f8Id,\u516c\u53f8sap\u7f16\u7801\uff0c\u8bed\u8a00\u7f16\u7801\u8fd4\u56de\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="companyId", required=true, value="\u516c\u53f8ID", paramType="query", dataType="String"), @ApiImplicitParam(name="addressCode", required=false, value="\u5b50\u516c\u53f8\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="languageCode", required=false, value="\u8bed\u8a00\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/queryByCompanyIdAndAddressCodeAndLanguageCode"})
    @ResponseBody
    public ResponseResult<List<CompanyAddress>> queryByCompanyIdAndAddressCodeAndLanguageCode(@RequestParam(required=true) String companyId, @RequestParam String addressCode, @RequestParam String languageCode) {
        return ResponseResult.success(this.companyAddressService.queryByCompanyIdAndAddressCodeAndLanguageCode(companyId, addressCode, languageCode));
    }

    @ApiOperation(httpMethod="GET", value="\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="companyId", required=true, value="\u516c\u53f8ID", paramType="query", dataType="String"), @ApiImplicitParam(name="addressCode", required=false, value="\u5b50\u516c\u53f8\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="languageCode", required=false, value="\u8bed\u8a00\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="isDefaultAddress", required=false, value="\u9ed8\u8ba4\u5730\u5740", paramType="query", dataType="Integer")})
    @RequestMapping(value={"service/updateDefaultAddress"})
    @ResponseBody
    public ResponseResult<String> updateDefaultAddress(@RequestParam(required=true) String companyId, @RequestParam String addressCode, @RequestParam String languageCode, Integer isDefaultAddress) {
        this.companyAddressService.updateDefaultAddress(companyId, addressCode, languageCode, isDefaultAddress);
        return ResponseResult.success();
    }
}

