/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.command;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.SupplierStatusEnum;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.sinolifesdk.service.SinoLifeApiService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyApproveCmd
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    @Resource
    private CompanyService companyService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private SinoLifeApiService sinolifeApiService;
    private List<String> companyCodes;

    @Transactional
    public String execute(ICommandInvoker context) {
        List<Company> companyList = this.checkAndRetrieveCompanys();
        this.process(companyList);
        return null;
    }

    private List<Company> checkAndRetrieveCompanys() {
        if (CollectionUtils.isEmpty(this.companyCodes)) {
            throw new CommonException("companyCodes\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanyCodeIn((List)this.companyCodes);
        List tmpList = this.companyService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)tmpList)) {
            throw new CommonException("\u6240\u9009\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        tmpList.forEach(company -> {
            if (!SupplierStatusEnum.POTENIAL.code().equals(company.getSupplierStatusCode()) && !SupplierStatusEnum.NEW.code().equals(company.getSupplierStatusCode())) {
                throw new CommonException("\u53ea\u6709\u6f5c\u5728\u6216\u65b0\u589e\u4f9b\u5e94\u5546\u624d\u80fd\u63d0\u4ea4\u5ba1\u6838");
            }
        });
        return tmpList;
    }

    private void process(List<Company> companyList) {
        companyList.forEach(company -> {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("seq", company.getId());
            paramMap.put("applySource", 3);
            paramMap.put("applyType", StringUtils.isBlank((CharSequence)company.getBepAuditNo()) ? 1 : 2);
            paramMap.put("applyUser", company);
            paramMap.put("applyPhone", company);
            paramMap.put("applyDate", company);
            paramMap.put("applyReason", company);
            paramMap.put("applyUserBranch", company);
            paramMap.put("payeeNo", company.getCompanyCode());
            paramMap.put("payeeName", company.getCompanyFullName());
            paramMap.put("businessBook", company.getBusinessBook());
            paramMap.put("province", company.getProvince());
            paramMap.put("city", company.getCity());
            paramMap.put("corporateCode", company);
            paramMap.put("corporateRepresentative", company);
            paramMap.put("taxRegistration", company.getTaxCert());
            paramMap.put("contactPhone", company.getTelephone());
            paramMap.put("supplierType", Integer.valueOf(1).equals(company.getSupplierType()) ? "1" : "2");
            paramMap.put("industryClass", company.getIndustryCode());
            paramMap.put("supplierContacts", company);
            paramMap.put("supplierAddress", company);
            paramMap.put("isScan", company);
            paramMap.put("idType", company.getIdType());
            paramMap.put("idNo", company.getIdNumber());
            paramMap.put("taxpayerType", company);
            paramMap.put("invoiceType", company);
            paramMap.put("accountList", company);
            paramMap.put("fileList", company);
            paramMap.put("companyId", company.getId());
            paramMap.put("companyCode", company.getCompanyCode());
            paramMap.put("listenerClass", CompanyService.class);
            Map result = this.sinolifeApiService.payeeApprove(paramMap);
            if (!"Y".equals(result.get("flag"))) {
                throw new CommonException((String)result.get("message"));
            }
            company.setBepAuditSn((String)result.get("applyNo"));
            company.setBepAuditNo((String)result.get("bepVoucherNo"));
            this.companyService.modifyObj((Serializable)company);
            this.companyService.updateSupplierStatus((Company)company, SupplierStatusEnum.WAIT_FOR_AUDIT);
        });
    }

    public List<String> getCompanyCodes() {
        return this.companyCodes;
    }

    public void setCompanyCodes(List<String> companyCodes) {
        this.companyCodes = companyCodes;
    }
}

