/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.ggsync.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.ggsync.entity.SyncBudgetCenter;
import com.els.base.ggsync.entity.SyncBudgetCenterExample;
import com.els.base.ggsync.service.SyncBudgetCenterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u9884\u7b97\u4e2d\u5fc3\u57fa\u8868")
@Controller
@RequestMapping(value={"syncBudgetCenter"})
public class SyncBudgetCenterController {
    @Resource
    protected SyncBudgetCenterService syncBudgetCenterService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u9884\u7b97\u4e2d\u5fc3\u57fa\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SyncBudgetCenter", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SyncBudgetCenter>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SyncBudgetCenterExample example = new SyncBudgetCenterExample();
        example.setPageView((PageView<SyncBudgetCenter>)new PageView(pageNo, pageSize));
        example.createCriteria().andInvalidFlagEqualTo("N");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.syncBudgetCenterService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u627e\u6307\u5b9a\u90e8\u95e8\u7684\u9884\u7b97\u4e2d\u5fc3")
    @RequestMapping(value={"service/findAllByDeptNo"})
    @ResponseBody
    public ResponseResult<List<SyncBudgetCenter>> findAllByDeptNo(@RequestParam(required=false) String deptNo) {
        Assert.isNotBlank((String)deptNo, (String)"\u90e8\u95e8\u7f16\u53f7(deptNo)\u4e0d\u80fd\u4e3a\u7a7a");
        List<SyncBudgetCenter> result = this.syncBudgetCenterService.findAllByDeptNo(deptNo);
        return ResponseResult.success(result);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u627e\u6307\u5b9a\u5458\u5de5\u7684\u9884\u7b97\u4e2d\u5fc3")
    @RequestMapping(value={"service/findAllByEmployeeInfo"})
    @ResponseBody
    public ResponseResult<List<SyncBudgetCenter>> findAllByEmployeeInfo(@RequestParam(required=false) String deptNo, @RequestParam(required=false) String businessBook, @RequestParam(required=false) String employeeId) {
        Assert.isNotBlank((String)businessBook, (String)"\u516c\u53f8\u8d26\u5957(businessBook)\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)deptNo, (String)"\u90e8\u95e8\u7f16\u53f7(deptNo)\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)employeeId, (String)"\u5458\u5de5\u7f16\u53f7(employeeId)\u4e0d\u80fd\u4e3a\u7a7a");
        List<SyncBudgetCenter> ls = this.syncBudgetCenterService.findAllSeniorManagerBudgetCenter(businessBook, employeeId);
        if (CollectionUtils.isEmpty(ls)) {
            ls = this.syncBudgetCenterService.findAllByDeptNo(deptNo);
        }
        return ResponseResult.success(ls);
    }
}

