/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.BranchInfoMapper;
import com.els.base.company.entity.BranchInfo;
import com.els.base.company.entity.BranchInfoExample;
import com.els.base.company.service.BranchInfoService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBranchInfoService")
public class BranchInfoServiceImpl
implements BranchInfoService {
    @Resource
    protected BranchInfoMapper branchInfoMapper;

    @CacheEvict(value={"branchInfo"}, allEntries=true)
    public void addObj(BranchInfo t) {
        this.branchInfoMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"branchInfo"}, allEntries=true)
    public void addAll(List<BranchInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.branchInfoMapper.insertBatch(list);
    }

    @CacheEvict(value={"branchInfo"}, allEntries=true)
    public void deleteObjById(String id) {
        this.branchInfoMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"branchInfo"}, allEntries=true)
    public void deleteByExample(BranchInfoExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.branchInfoMapper.deleteByExample(example);
    }

    @CacheEvict(value={"branchInfo"}, allEntries=true)
    public void modifyObj(BranchInfo t) {
        Assert.isNotNull((Object)t.getBranchid(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.branchInfoMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"branchInfo"}, keyGenerator="redisKeyGenerator")
    public BranchInfo queryObjById(String id) {
        return this.branchInfoMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"branchInfo"}, keyGenerator="redisKeyGenerator")
    public List<BranchInfo> queryAllObjByExample(BranchInfoExample example) {
        return this.branchInfoMapper.selectByExample(example);
    }

    @Cacheable(value={"branchInfo"}, keyGenerator="redisKeyGenerator")
    public PageView<BranchInfo> queryObjByPage(BranchInfoExample example) {
        PageView<BranchInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.branchInfoMapper.selectByExampleByPage(example));
        return pageView;
    }
}

