/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.service.CompanyPartnerService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyPartnerService")
public class CompanyPartnerServiceImpl
implements CompanyPartnerService {
    @Resource
    protected CompanyPartnerMapper companyPartnerMapper;

    @CacheEvict(value={"companyPartner"}, allEntries=true)
    public void addObj(CompanyPartner t) {
        this.companyPartnerMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyPartner"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyPartnerMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyPartner"}, allEntries=true)
    public void modifyObj(CompanyPartner t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.companyPartnerMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyPartner"}, keyGenerator="redisKeyGenerator")
    public CompanyPartner queryObjById(String id) {
        return this.companyPartnerMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyPartner"}, keyGenerator="redisKeyGenerator")
    public List<CompanyPartner> queryAllObjByExample(CompanyPartnerExample example) {
        return this.companyPartnerMapper.selectByExample(example);
    }

    @Cacheable(value={"companyPartner"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyPartner> queryObjByPage(CompanyPartnerExample example) {
        PageView<CompanyPartner> pageView = example.getPageView();
        pageView.setQueryResult(this.companyPartnerMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"companyPartner"}, allEntries=true)
    public void modifyByExample(CompanyPartner companyPartner, CompanyPartnerExample example) {
        this.companyPartnerMapper.updateByExampleSelective(companyPartner, example);
    }

    @Override
    @CacheEvict(value={"companyPartner"}, allEntries=true)
    public void deleteAllExample(CompanyPartnerExample example) {
        this.companyPartnerMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyPartner"}, allEntries=true)
    public void deleteByExample(CompanyPartnerExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyPartnerMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyPartner"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyPartner> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyPartnerMapper.insertSelective((CompanyPartner)record));
    }
}

