/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.utils;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public abstract class CompanyUtils {
    private static CompanyPurRefService getCompanyPurRefService() {
        return (CompanyPurRefService)SpringContextHolder.getOneBean(CompanyPurRefService.class);
    }

    private static CompanyUserRefService getCompanyUserRefService() {
        return (CompanyUserRefService)SpringContextHolder.getOneBean(CompanyUserRefService.class);
    }

    private static CompanyService getCompanyService() {
        return (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    }

    public static Company currentCompany() {
        String companyId = CompanyUtils.getCompanyUserRefService().queryCompanyIdOfUser(SpringSecurityUtils.getLoginUserId());
        Company company = (Company)CompanyUtils.getCompanyService().queryObjById(companyId);
        if (company == null) {
            throw new CommonException("\u7528\u6237\u672a\u5206\u914d", "user_unassigned");
        }
        return company;
    }

    public static boolean isSupCompany() {
        return !CompanyUtils.isPurCompany();
    }

    public static boolean isPurCompany() {
        String currentCompanyId;
        String rootCompanyId = ProjectUtils.getProject().getCompanyId();
        if (rootCompanyId.equals(currentCompanyId = CompanyUtils.currentCompanyId())) {
            return true;
        }
        List<Company> childern = CompanyUtils.getCompanyService().queryChildCompany(rootCompanyId);
        if (CollectionUtils.isEmpty(childern)) {
            return false;
        }
        for (Company company : childern) {
            if (!company.getId().equals(currentCompanyId)) continue;
            return true;
        }
        return false;
    }

    public static String currentCompanyId() {
        return CompanyUtils.currentCompany().getId();
    }

    public static Company getPurCompanyOfCurrentCompany() {
        return CompanyUtils.getCompanyService().queryPurchaseCompanies(CompanyUtils.currentCompanyId());
    }

    public static List<Company> getSupCompanyOfCurrentUser() {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        List<Company> companyList = CompanyUtils.getCompanyPurRefService().queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), companyExample);
        if (companyList == null) {
            return new ArrayList<Company>();
        }
        return companyList;
    }

    public static List<String> getSupCompanyIdsOfCurrentUser() {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        ArrayList<String> companyIds = new ArrayList<String>();
        List<Company> list = CompanyUtils.getCompanyPurRefService().queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), companyExample);
        if (CollectionUtils.isEmpty(list)) {
            return companyIds;
        }
        for (Company company : list) {
            companyIds.add(company.getId());
        }
        return companyIds;
    }
}

