/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.Department;
import com.els.base.company.entity.DepartmentExample;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.web.vo.DepartmentVO;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u90e8\u95e8\u4fe1\u606f"})
@Controller
@RequestMapping(value={"department"})
public class DepartmentController {
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Department department) {
        department.setCompanyId(CompanyUtils.currentCompanyId());
        department.setProjectId(ProjectUtils.getProjectId());
        this.departmentService.addObj(department);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Department department) {
        if (StringUtils.isBlank((String)department.getId())) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        this.departmentService.modifyObj(department);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        Department department = new Department();
        department.setId(id);
        department.setIsEnable(Constant.NO_INT);
        this.departmentService.modifyObj(department);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u7684\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Department>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u4e0a\u7ea7id,\u4e0d\u4f20\u5219\u67e5\u8be2\u9876\u7ea7\u90e8\u95e8") String parentId) {
        DepartmentExample example = new DepartmentExample();
        example.setPageView((PageView<Department>)new PageView(pageNo, pageSize));
        DepartmentExample.Criteria cri = example.createCriteria();
        cri.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andParentIdIsNull().andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.departmentService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u7684\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/findDepartmentTree"})
    @ResponseBody
    public ResponseResult<List<Department>> findDepartmentTree() {
        DepartmentExample example = new DepartmentExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andParentIdIsNull().andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        List departmentList = this.departmentService.queryAllObjByExample((IExample)example);
        for (Department department : departmentList) {
            department.setSubDepList(this.departmentService.queryByParentId(department.getId()));
        }
        return ResponseResult.success((Object)departmentList);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u6240\u6709\u90e8\u95e8\uff0c\u5df2\u5b58\u5728\u7528\u6237\u4fe1\u606f\u5219\u6807\u8bc6\u7528\u6237\u5df2\u62e5\u6709\uff08\u65b0\u589e\uff09")
    @RequestMapping(value={"service/queryAllDepartmentWithAuthTag"})
    @ResponseBody
    public ResponseResult<List<Department>> queryAllDepartmentWithAuthTag(String userId) {
        return ResponseResult.success(this.departmentService.getDepartmentTree(userId, CompanyUtils.currentCompanyId()));
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u90e8\u95e8\u5185\u7684\u5e10\u53f7")
    @RequestMapping(value={"service/findUsersInDepartment"})
    @ResponseBody
    public ResponseResult<PageView<User>> findUsersInDepartment(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, String departmentId) {
        if (StringUtils.isBlank((String)departmentId)) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        return ResponseResult.success(this.departmentService.queryUsersInDepartmentByPage(pageNo, pageSize, departmentId));
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u90e8\u95e8\u5185\u7684\u5e10\u53f7")
    @RequestMapping(value={"service/addUserIntoDepartment"})
    @ResponseBody
    public ResponseResult<String> addUserIntoDepartment(String userId, String departmentId) {
        Department department = (Department)this.departmentService.queryObjById(departmentId);
        if (department == null) {
            throw new CommonException("\u627e\u4e0d\u5230\u90e8\u95e8", "not_found_depart");
        }
        if (!department.getCompanyId().equals(CompanyUtils.currentCompanyId())) {
            throw new CommonException("\u627e\u4e0d\u5230\u90e8\u95e8", "not_found_depart");
        }
        this.departmentService.addUserIntoDepartment(userId, departmentId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u7528\u6237\u6279\u91cf\u5206\u914d\u90e8\u95e8\u4fe1\u606f\uff08\u65b0\u589e\uff09")
    @RequestMapping(value={"service/addsUserIntoDepartment"})
    @ResponseBody
    public ResponseResult<String> addsUserIntoDepartment(String userId, List<String> departmentIds) {
        departmentIds.forEach(departmentId -> {
            Department department = (Department)this.departmentService.queryObjById(departmentId);
            if (department == null) {
                throw new CommonException("\u627e\u4e0d\u5230\u90e8\u95e8", "not_found_depart");
            }
            if (StringUtils.isBlank((String)department.getCompanyId())) {
                throw new CommonException("\u8be5\u90e8\u95e8\u5c1a\u672a\u5173\u8054\u516c\u53f8ID\uff0c\u64cd\u4f5c\u5931\u8d25", "not_found_depart");
            }
        });
        this.departmentService.addsUserIntoDepartment(userId, departmentIds);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u901a\u8fc7\u7528\u6237id\u548c\u516c\u53f8id\u52a0\u8f7d\u7528\u6237\u6240\u5c5e\u90e8\u95e8\u4fe1\u606f\uff0ccompanyId\u53ef\u7a7a\uff08\u65b0\u589e\uff09")
    @RequestMapping(value={"service/getDepartmentByUserId"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseResult<List<DepartmentVO>> getDepartmentByUserId(@RequestParam(required=true) String userId) {
        return ResponseResult.success(this.departmentService.getDepartmentByUserId(userId));
    }
}

