/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.datacleaning.service.impl;

import com.els.base.company.dao.DepartmentMapper;
import com.els.base.company.entity.Department;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.datacleaning.dao.BranchInfosMapper;
import com.els.base.datacleaning.entity.BranchInfos;
import com.els.base.datacleaning.entity.BranchInfosExample;
import com.els.base.datacleaning.service.BranchInfosService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBranchInfosService")
public class BranchInfosServiceImpl
implements BranchInfosService {
    @Resource
    protected BranchInfosMapper branchInfosMapper;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private DepartmentMapper departmentMapper;

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void addObj(BranchInfos t) {
        this.branchInfosMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void addAll(List<BranchInfos> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.branchInfosMapper.insertBatch(list);
    }

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void deleteObjById(String id) {
        this.branchInfosMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void deleteByExample(BranchInfosExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.branchInfosMapper.deleteByExample(example);
    }

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void modifyObj(BranchInfos t) {
        Assert.isNotNull((Object)t.getBranchid(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.branchInfosMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"branchInfos"}, keyGenerator="redisKeyGenerator")
    public BranchInfos queryObjById(String id) {
        return this.branchInfosMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"branchInfos"}, keyGenerator="redisKeyGenerator")
    public List<BranchInfos> queryAllObjByExample(BranchInfosExample example) {
        return this.branchInfosMapper.selectByExample(example);
    }

    @Cacheable(value={"branchInfos"}, keyGenerator="redisKeyGenerator")
    public PageView<BranchInfos> queryObjByPage(BranchInfosExample example) {
        PageView<BranchInfos> pageView = example.getPageView();
        pageView.setQueryResult(this.branchInfosMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"branchInfo"}, allEntries=true)
    public void branchDataCleaning(String companyId) {
        StringBuffer sb = new StringBuffer();
        List<BranchInfos> branchInfos = this.queryAllObjByExample(new BranchInfosExample());
        if (CollectionUtils.isEmpty(branchInfos)) {
            Assert.isNotNull(null, (String)"\u540c\u6b65\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        String projectId = "20180521121350-39be1c82d75a4abcd";
        branchInfos.forEach(branchInfo -> {
            Department department = new Department();
            department.setId(branchInfo.getBranchid());
            department.setParentId(branchInfo.getParent());
            department.setProjectId(projectId);
            department.setCompanyId(companyId);
            department.setDepartmentName(branchInfo.getName());
            department.setDepartmentCode(branchInfo.getBranchid());
            department.setDepartmentType(branchInfo.getGrade());
            department.setIsEnable(Constant.YES_INT);
            if (this.departmentMapper.insert(department) < 1) {
                sb.append(branchInfo.getBranchid() + "_");
            }
        });
        System.out.println("\u6709\u95ee\u9898\u7684\u6761\u6570id\u4e3a\uff1a");
        System.out.println(sb.toString());
    }
}

