/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.command;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.SupplierStatusEnum;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyApproveCmd
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    @Resource
    private CompanyService companyService;
    @Resource
    WorkFlowService workFlowService;
    private List<String> companyCodes;

    @Transactional
    public String execute(ICommandInvoker context) {
        List<Company> companyList = this.checkAndRetrieveCompanys();
        this.process(companyList);
        return null;
    }

    private List<Company> checkAndRetrieveCompanys() {
        if (CollectionUtils.isEmpty(this.companyCodes)) {
            throw new CommonException("companyCodes\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanyExample example = new CompanyExample();
        example.createCriteria().andCompanyCodeIn((List)this.companyCodes);
        List tmpList = this.companyService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)tmpList)) {
            throw new CommonException("\u6240\u9009\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
        }
        tmpList.forEach(company -> {
            if (!SupplierStatusEnum.POTENIAL.code().equals(company.getSupplierStatusCode()) && !SupplierStatusEnum.NEW.code().equals(company.getSupplierStatusCode())) {
                throw new CommonException("\u53ea\u6709\u6f5c\u5728\u6216\u65b0\u589e\u4f9b\u5e94\u5546\u624d\u80fd\u63d0\u4ea4\u5ba1\u6838");
            }
        });
        return tmpList;
    }

    private void process(List<Company> companyList) {
        companyList.forEach(company -> {
            ProcessStartVO process = ProcessStartVO.newInstance((String)"supplier_data", (String)company.getCompanyCode(), (String)company.getId(), (String)("/supManagement/supplierCompany?companyCode=" + company.getCompanyCode()));
            process.setListenerClass(CompanyService.class);
            this.workFlowService.startProcess(process);
            this.companyService.updateSupplierStatus((Company)company, SupplierStatusEnum.WAIT_FOR_AUDIT);
        });
    }

    public List<String> getCompanyCodes() {
        return this.companyCodes;
    }

    public void setCompanyCodes(List<String> companyCodes) {
        this.companyCodes = companyCodes;
    }
}

