/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.event.listener;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.event.CompanyCreatedSuccessEvent;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyCreatedSuccessListener
implements ApplicationListener<CompanyCreatedSuccessEvent> {
    @Resource
    private UserService userService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ProjectService projectService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private RoleService roleService;

    @Transactional
    public void onApplicationEvent(CompanyCreatedSuccessEvent event) {
        String nickName;
        Company company = (Company)event.getSource();
        Project project = (Project)this.projectService.queryObjById((Object)company.getProjectId());
        if (project == null || StringUtils.isBlank((String)project.getProjectCode())) {
            throw new CommonException("ProjectCode\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"ProjectCode"});
        }
        User t = new User();
        t.setLoginName(company.getCompanyCode());
        String string = nickName = StringUtils.isBlank((String)company.getCompanyName()) ? company.getCompanyFullName() : company.getCompanyName();
        if (StringUtils.isNotBlank((String)nickName)) {
            t.setNickName(nickName);
        }
        t.setPassword("123456");
        t.setIsEnable(Constant.YES_INT);
        t.setProjectCode(project.getProjectCode());
        try {
            this.userService.addObj((Serializable)t);
        }
        catch (Exception e) {
            throw new CommonException("\u8d26\u53f7\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage(), "base_fail");
        }
        CompanyUserRef userRef = new CompanyUserRef();
        userRef.setCompanyId(company.getId());
        userRef.setProjectId(company.getProjectId());
        userRef.setUserId(t.getId());
        this.companyUserRefService.addObj(userRef);
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Role role : list) {
                UserRole userRole = new UserRole();
                userRole.setRoleId(role.getId());
                userRole.setCreateTime(new Date());
                userRole.setUserId(t.getId());
                this.userRoleService.addObj((Serializable)userRole);
            }
        }
    }
}

