/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.BankInfoMapper;
import com.els.base.company.entity.BankInfo;
import com.els.base.company.entity.BankInfoExample;
import com.els.base.company.service.BankInfoService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBankInfoService")
public class BankInfoServiceImpl
implements BankInfoService {
    @Resource
    protected BankInfoMapper bankInfoMapper;

    @CacheEvict(value={"bankInfo"}, allEntries=true)
    public void addObj(BankInfo t) {
        this.bankInfoMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"bankInfo"}, allEntries=true)
    public void addAll(List<BankInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.bankInfoMapper.insertBatch(list);
    }

    @CacheEvict(value={"bankInfo"}, allEntries=true)
    public void deleteObjById(String bankCode) {
        this.bankInfoMapper.deleteByPrimaryKey(bankCode);
    }

    @CacheEvict(value={"bankInfo"}, allEntries=true)
    public void deleteByExample(BankInfoExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.bankInfoMapper.deleteByExample(example);
    }

    @CacheEvict(value={"bankInfo"}, allEntries=true)
    public void modifyObj(BankInfo t) {
        Assert.isNotNull((Object)t.getBankCode(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.bankInfoMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"bankInfo"}, keyGenerator="redisKeyGenerator")
    public BankInfo queryObjById(String bankCode) {
        return this.bankInfoMapper.selectByPrimaryKey(bankCode);
    }

    @Cacheable(value={"bankInfo"}, keyGenerator="redisKeyGenerator")
    public List<BankInfo> queryAllObjByExample(BankInfoExample example) {
        return this.bankInfoMapper.selectByExample(example);
    }

    @Cacheable(value={"bankInfo"}, keyGenerator="redisKeyGenerator")
    public PageView<BankInfo> queryObjByPage(BankInfoExample example) {
        PageView<BankInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.bankInfoMapper.selectByExampleByPage(example));
        return pageView;
    }
}

