/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanyMaterialCategoryMapper;
import com.els.base.company.entity.CompanyMaterialCategory;
import com.els.base.company.entity.CompanyMaterialCategoryExample;
import com.els.base.company.service.CompanyMaterialCategoryService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyMaterialCategoryService")
public class CompanyMaterialCategoryServiceImpl
implements CompanyMaterialCategoryService {
    @Resource
    protected CompanyMaterialCategoryMapper companyMaterialCategoryMapper;

    @CacheEvict(value={"companyMaterialCategory"}, allEntries=true)
    public void addObj(CompanyMaterialCategory t) {
        this.companyMaterialCategoryMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"companyMaterialCategory"}, allEntries=true)
    public void addAll(List<CompanyMaterialCategory> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.companyMaterialCategoryMapper.insertBatch(list);
    }

    @CacheEvict(value={"companyMaterialCategory"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyMaterialCategoryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyMaterialCategory"}, allEntries=true)
    public void deleteByExample(CompanyMaterialCategoryExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyMaterialCategoryMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyMaterialCategory"}, allEntries=true)
    public void modifyObj(CompanyMaterialCategory t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.companyMaterialCategoryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyMaterialCategory"}, keyGenerator="redisKeyGenerator")
    public CompanyMaterialCategory queryObjById(String id) {
        return this.companyMaterialCategoryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyMaterialCategory"}, keyGenerator="redisKeyGenerator")
    public List<CompanyMaterialCategory> queryAllObjByExample(CompanyMaterialCategoryExample example) {
        return this.companyMaterialCategoryMapper.selectByExample(example);
    }

    @Cacheable(value={"companyMaterialCategory"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyMaterialCategory> queryObjByPage(CompanyMaterialCategoryExample example) {
        PageView<CompanyMaterialCategory> pageView = example.getPageView();
        pageView.setQueryResult(this.companyMaterialCategoryMapper.selectByExampleByPage(example));
        return pageView;
    }
}

