/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyMaterialCategory;
import com.els.base.company.entity.CompanyMaterialCategoryExample;
import com.els.base.company.service.CompanyMaterialCategoryService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u516c\u53f8-\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u8868"})
@Controller
@RequestMapping(value={"companyMaterialCategory"})
public class CompanyMaterialCategoryController {
    @Resource
    protected CompanyMaterialCategoryService companyMaterialCategoryService;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u516c\u53f8-\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyMaterialCategory companyMaterialCategory) {
        this.companyMaterialCategoryService.addObj(companyMaterialCategory);
        return ResponseResult.success((Object)companyMaterialCategory.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u516c\u53f8-\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyMaterialCategory companyMaterialCategory) {
        Assert.isNotBlank((String)companyMaterialCategory.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.companyMaterialCategoryService.modifyObj(companyMaterialCategory);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u516c\u53f8-\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyMaterialCategoryExample example = new CompanyMaterialCategoryExample();
        example.createCriteria().andIdIn((List)ids);
        this.companyMaterialCategoryService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u516c\u53f8-\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyMaterialCategory", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyMaterialCategory>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyMaterialCategoryExample example = new CompanyMaterialCategoryExample();
        example.setPageView((PageView<CompanyMaterialCategory>)new PageView(pageNo, pageSize));
        example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyMaterialCategoryService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u516c\u53f8-\u7269\u6599\u5206\u7c7b\u5173\u7cfb\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/list"})
    @ResponseBody
    public ResponseResult<List<CompanyMaterialCategory>> list(@RequestParam(name="supCompanySrmCode", required=false) String companyCode) {
        Company company = null;
        if (StringUtils.isEmpty((Object)companyCode)) {
            company = CompanyUtils.currentCompany();
            if (company == null) {
                return ResponseResult.fail((ResponseCode)ResponseCode.Account_No_Login, null);
            }
        } else {
            company = this.companyService.queryCompanyByCode(companyCode);
            if (company == null) {
                return ResponseResult.fail((ResponseCode)ResponseCode.User_Not_Found, null);
            }
        }
        String projectId = ProjectUtils.getProjectId();
        CompanyMaterialCategoryExample example = new CompanyMaterialCategoryExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andCompanyIdEqualTo(company.getId());
        List listData = this.companyMaterialCategoryService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)listData).setExt1((Object)company.getSupplierClassification());
    }
}

