/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.codegenerator.service.impl;

import com.els.base.codegenerator.entity.GenerateCode;
import com.els.base.codegenerator.service.GenerateStrategy;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Component;

@Component
public class CompanyCodeGenerateStrategy
extends GenerateStrategy {
    private static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

    public List<String> generateNextCode(GenerateCode currentCode, int quantity) {
        ArrayList<String> result = new ArrayList<String>(quantity);
        String prefix = DateFormatUtils.format((Date)new Date(), (String)YYYYMMDDHHMMSS);
        Random random = new Random();
        for (int i = 0; i < quantity; ++i) {
            String code = prefix + this.generateSuffix(random);
            result.add(code);
        }
        return result;
    }

    private String generateSuffix(Random random) {
        int nextInt = random.nextInt(999999);
        return StringUtils.leftPad((String)Integer.toString(nextInt), (int)6, (char)'0');
    }
}

