/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.company.dao.CompanyUserRefMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.dao.user.UserMapper;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyUserRefService")
public class CompanyUserRefServiceImpl
implements CompanyUserRefService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyUserRefServiceImpl.class);
    @Resource
    protected CompanyUserRefMapper companyUserRefMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;
    @Resource
    protected RoleService roleService;
    @Resource
    protected UserRoleService userRoleService;
    @Autowired
    private UserMapper userMapper;

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void addObj(CompanyUserRef t) {
        this.companyUserRefMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyUserRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void modifyObj(CompanyUserRef t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyUserRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public CompanyUserRef queryObjById(String id) {
        return this.companyUserRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public List<CompanyUserRef> queryAllObjByExample(CompanyUserRefExample example) {
        return this.companyUserRefMapper.selectByExample(example);
    }

    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyUserRef> queryObjByPage(CompanyUserRefExample example) {
        PageView<CompanyUserRef> pageView = example.getPageView();
        pageView.setQueryResult(this.companyUserRefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void addUserIntoCompany(String userId, String companyId) {
        Company company = (Company)this.companyService.queryObjById(companyId);
        if (company == null) {
            throw new CommonException("companyId\u6ca1\u6709\u5bf9\u5e94\u7684\u5bf9\u8c61", "do_not_exists", new Object[]{"\u8be5\u516c\u53f8"});
        }
        CompanyUserRef ref = new CompanyUserRef();
        ref.setUserId(userId);
        ref.setProjectId(company.getProjectId());
        ref.setCompanyId(companyId);
        this.companyUserRefMapper.insertSelective(ref);
    }

    @Override
    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public String queryCompanyIdOfUser(String userId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List<CompanyUserRef> list = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0).getCompanyId();
    }

    @Override
    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public List<String> queryUserOfCompany(String companyId) {
        ArrayList<String> list = new ArrayList<String>();
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);
        List<CompanyUserRef> listCompanyUserRef = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(listCompanyUserRef)) {
            return null;
        }
        for (CompanyUserRef companyUserRef : listCompanyUserRef) {
            String userId = companyUserRef.getUserId();
            if (!StringUtils.isNotBlank((String)userId)) continue;
            list.add(userId);
        }
        return list;
    }

    @Override
    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    @Transactional
    public void addSupplierIntoUser(Company company, User user) {
        UserExample userEx1 = new UserExample();
        userEx1.createCriteria().andLoginNameEqualTo(user.getLoginName());
        if (this.userMapper.countByExample(userEx1) > 0) {
            throw new CommonException("\u76f8\u540c\u7528\u6237\u5df2\u5b58\u5728", "base_the_same_account");
        }
        UserExample userEx2 = new UserExample();
        userEx2.createCriteria().andMobilePhoneEqualTo(user.getMobilePhone());
        if (this.userMapper.countByExample(userEx2) > 0) {
            throw new CommonException("\u624b\u673a\u53f7\u5df2\u5b58\u5728", "base_the_same_mobile");
        }
        UserExample userEx3 = new UserExample();
        userEx3.createCriteria().andEmailEqualTo(user.getEmail());
        if (this.userMapper.countByExample(userEx3) > 0) {
            throw new CommonException("\u90ae\u7bb1\u5df2\u5b58\u5728", "base_the_same_email");
        }
        UserExample userEx4 = new UserExample();
        userEx4.createCriteria().andNickNameEqualTo(user.getNickName());
        if (this.userMapper.countByExample(userEx4) > 0) {
            throw new CommonException("\u6635\u79f0\u5df2\u5b58\u5728", "base_the_same_nickName");
        }
        if (!user.getLoginName().matches("^\\w([\\w\\-]){4,254}")) {
            throw new CommonException("\u5e10\u53f7\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002", "invaild_format", new Object[]{"\u8d26\u53f7", "\u5e10\u53f7\u9700\u89815\u4e2a\u4ee5\u4e0a\u5b57\u7b26\uff0c\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u6216\u6570\u5b57\uff0c\u6216\u8005\u6a2a\u6760\uff0c\u6216\u4e0b\u5212\u7ebf\u3002"});
        }
        if (user.getLoginName().length() > 255 || user.getQq().length() > 255 || user.getNickName().length() > 255 || user.getWechat().length() > 255 || user.getFax().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        user.setIsEnable(Constant.YES_INT);
        try {
            this.userService.addObj((Serializable)user);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5e10\u53f7\u5931\u8d25", (Throwable)e);
            throw new CommonException("\u6dfb\u52a0\u5e10\u53f7\u5931\u8d25", (Throwable)e);
        }
        CompanyUserRef companyUserRef = new CompanyUserRef();
        companyUserRef.setProjectId(company.getProjectId());
        companyUserRef.setCompanyId(company.getId());
        companyUserRef.setUserId(user.getId());
        this.companyUserRefMapper.insertSelective(companyUserRef);
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo("supplier");
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            UserRole t = new UserRole();
            t.setUserId(user.getId());
            t.setRoleId(((Role)list.get(0)).getId());
            t.setCreateTime(new Date());
            this.userRoleService.addObj((Serializable)t);
        }
    }

    @Override
    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public List<FriendGroup> findSupplierUser(CompanyUserRefExample companyUserRefExample) {
        List<CompanyUserRef> companyUserRefList = this.companyUserRefMapper.selectByExample(companyUserRefExample);
        ArrayList<FriendGroup> friendGroupList = new ArrayList<FriendGroup>();
        if (CollectionUtils.isNotEmpty(companyUserRefList)) {
            FriendGroup friendGroup = new FriendGroup();
            CompanyUserRef companyUserRef = companyUserRefList.get(0);
            if (companyUserRef != null) {
                friendGroup.setCompany((Company)this.companyService.queryObjById(companyUserRef.getCompanyId()));
                ArrayList<User> userList = new ArrayList<User>();
                for (CompanyUserRef companyUser : companyUserRefList) {
                    User user = (User)this.userService.queryObjById((Object)companyUser.getUserId());
                    if (user == null) continue;
                    userList.add(user);
                }
                if (CollectionUtils.isNotEmpty(userList)) {
                    friendGroup.setUserList(userList);
                }
                friendGroupList.add(friendGroup);
            }
            return friendGroupList;
        }
        return friendGroupList;
    }

    @Override
    public List<User> queryUserListOfCompany(String supCompanyId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdEqualTo(supCompanyId);
        List<CompanyUserRef> listCompanyUserRef = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(listCompanyUserRef)) {
            return null;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (CompanyUserRef ref : listCompanyUserRef) {
            userIds.add(ref.getUserId());
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIdIn(userIds);
        example.setOrderByClause("CREATE_TIME ASC");
        List userList = this.userService.queryAllObjByExample((IExample)userExample);
        return userList;
    }

    @Override
    public User queryMainUserOfCompany(String companyId) {
        Company company = (Company)this.companyService.queryObjById(companyId);
        if (company == null) {
            return null;
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andLoginNameEqualTo(company.getCompanyCode());
        List users = this.userService.queryAllObjByExample((IExample)userExample);
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            return (User)users.get(0);
        }
        CompanyUserRefExample userRefExample = new CompanyUserRefExample();
        userRefExample.createCriteria().andCompanyIdEqualTo(companyId);
        userRefExample.setOrderByClause("CREATE_TIME ASC");
        List<CompanyUserRef> refList = this.queryAllObjByExample(userRefExample);
        if (CollectionUtils.isEmpty(refList)) {
            return null;
        }
        return (User)this.userService.queryObjById((Object)refList.get(0).getUserId());
    }

    @Override
    public PageView<User> queryUserListOfCompanyByPage(String companyId, UserExample userExample) {
        PageView pageView = userExample.getPageView();
        pageView.setQueryResult(this.companyUserRefMapper.selectUserForCompanyByPage(companyId, userExample));
        return pageView;
    }

    @Override
    public PageView<User> queryUserListOfOtherCompanyByPage(String companyId, UserExample userExample) {
        PageView pageView = userExample.getPageView();
        pageView.setQueryResult(this.companyUserRefMapper.selectUserForOutCompanyByPage(companyId, userExample));
        return pageView;
    }

    @Override
    public List<String> queryUserOfcompanySapCode(String companySapCode) {
        Company company = this.companyService.queryCompanyBySapCode(companySapCode);
        if (company == null) {
            return null;
        }
        return this.queryUserOfCompany(company.getId());
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void deleteByExample(CompanyUserRefExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyUserRefMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyUserRef> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyUserRefMapper.insertSelective((CompanyUserRef)record));
    }

    @Override
    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void modifyByExample(CompanyUserRef record, CompanyUserRefExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u4fee\u6539");
        this.companyUserRefMapper.updateByExampleSelective(record, example);
    }

    @Override
    public int countByExample(CompanyUserRefExample example) {
        return this.companyUserRefMapper.countByExample(example);
    }
}

