/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.DepartmentMapper;
import com.els.base.company.dto.AcountSetAndDepartmentDto;
import com.els.base.company.dto.DepartmentDto;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.Department;
import com.els.base.company.entity.DepartmentExample;
import com.els.base.company.enums.DepartmentTypeEnum;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.DepartmentUtil;
import com.els.base.company.web.vo.DepartmentExcelVO;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDepartmentService")
public class DepartmentServiceImpl
implements DepartmentService {
    @Resource
    protected DepartmentMapper departmentMapper;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserService userService;

    @CacheEvict(value={"department"}, allEntries=true)
    public void addObj(Department t) {
        String id = UUIDGenerator.generateUUID();
        t.setId(id);
        if (StringUtils.isNotBlank((String)t.getParentId())) {
            Department department = this.queryObjById(t.getParentId());
            if (null == department) {
                throw new CommonException("\u6dfb\u52a0\u5931\u8d25\uff0c\u65e0\u6548\u7236\u7ea7id");
            }
            if (StringUtils.isBlank((String)department.getParent())) {
                t.setParent(department.getId() + "," + id);
            } else {
                t.setParent(department.getParent() + "," + id);
            }
        }
        t.setIsEnable(Constant.YES_INT);
        this.departmentMapper.insertSelective(t);
    }

    @CacheEvict(value={"department"}, allEntries=true)
    public void deleteObjById(String id) {
        this.departmentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"department"}, allEntries=true)
    public void modifyObj(Department t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.departmentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public Department queryObjById(String id) {
        return this.departmentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<Department> queryAllObjByExample(DepartmentExample example) {
        return this.departmentMapper.selectByExample(example);
    }

    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public PageView<Department> queryObjByPage(DepartmentExample example) {
        PageView<Department> pageView = example.getPageView();
        pageView.setQueryResult(this.departmentMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public PageView<User> queryUsersInDepartmentByPage(int pageNo, int pageSize, String departmentId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andDepartmentIdEqualTo(departmentId);
        List allUser = this.companyUserRefService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)allUser)) {
            return new PageView(pageNo, pageSize);
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        for (CompanyUserRef ref : allUser) {
            userIdList.add(ref.getUserId());
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIdIn(userIdList).andIsEnableEqualTo(Constant.YES_INT);
        userExample.setPageView(new PageView(pageNo, pageSize));
        return this.userService.queryObjByPage((IExample)userExample);
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<Department> queryByParentId(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            return null;
        }
        DepartmentExample example = new DepartmentExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<Department> departmentList = this.departmentMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(departmentList)) {
            return null;
        }
        for (Department department : departmentList) {
            department.setSubDepList(this.queryByParentId(department.getId()));
        }
        return departmentList;
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<DepartmentExcelVO> getDepartmentByUserId(String userId) {
        ArrayList<DepartmentExcelVO> departmentExcelVOS = new ArrayList<DepartmentExcelVO>();
        CompanyUserRefExample userRefExample = new CompanyUserRefExample();
        userRefExample.createCriteria().andUserIdEqualTo(userId);
        List refList = this.companyUserRefService.queryAllObjByExample((IExample)userRefExample);
        refList.forEach(ref -> {
            Department department = this.queryObjById(ref.getDepartmentId());
            departmentExcelVOS.add(this.getDepartment(new DepartmentExcelVO(), department));
        });
        return departmentExcelVOS;
    }

    private DepartmentExcelVO getDepartment(DepartmentExcelVO excelVO, Department model) {
        switch (model.getDepartmentType()) {
            case "1": {
                excelVO.setTotalGroupId(model.getId());
                excelVO.setTotalGroupName(model.getDepartmentName());
                break;
            }
            case "2": {
                excelVO.setAccountSetId(model.getId());
                excelVO.setAccountCode(model.getDepartmentCode());
                excelVO.setAccountSetName(model.getDepartmentName());
                Department acc = this.queryObjById(model.getParentId());
                this.getDepartment(excelVO, acc);
                break;
            }
            case "3": {
                excelVO.setInstitutionsId(model.getId());
                excelVO.setInstitutionsName(model.getDepartmentName());
                Department ins = this.queryObjById(model.getParentId());
                this.getDepartment(excelVO, ins);
                break;
            }
            case "4": {
                excelVO.setInTheOrganizationId(model.getId());
                excelVO.setInTheOrganizationName(model.getDepartmentName());
                Department inthe = this.queryObjById(model.getParentId());
                this.getDepartment(excelVO, inthe);
                break;
            }
            case "5": {
                if (StringUtils.isBlank((String)excelVO.getDepartId())) {
                    excelVO.setDepartId(model.getId());
                    excelVO.setDepartName(model.getDepartmentName());
                }
                Department department = this.queryObjById(model.getParentId());
                this.getDepartment(excelVO, department);
            }
        }
        return excelVO;
    }

    @Override
    @Transactional
    @CacheEvict(value={"department", "userService"}, allEntries=true)
    public void addsUserIntoDepartment(String userId, List<String> departmentIds) {
        CompanyUserRefExample userRefExample = new CompanyUserRefExample();
        userRefExample.createCriteria().andUserIdEqualTo(userId);
        this.companyUserRefService.deleteByExample((IExample)userRefExample);
        departmentIds.forEach(departmentId -> {
            Department department = this.queryObjById((String)departmentId);
            CompanyUserRef ref = new CompanyUserRef();
            ref.setUserId(userId);
            ref.setCompanyId(department.getCompanyId());
            ref.setDepartmentId(department.getId());
            ref.setProjectId(department.getProjectId());
            this.companyUserRefService.addObj(ref);
        });
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<Department> getDepartmentTree(String userId, String currentCompanyId) {
        ArrayList<Department> result = new ArrayList<Department>();
        DepartmentExample example = new DepartmentExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCompanyIdEqualTo(currentCompanyId);
        List<Department> departments = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(departments)) {
            return result;
        }
        CompanyUserRefExample userRefExample = new CompanyUserRefExample();
        userRefExample.createCriteria().andUserIdEqualTo(userId);
        List<Object> finalIds = new ArrayList();
        List refList = this.companyUserRefService.queryAllObjByExample((IExample)userRefExample);
        if (CollectionUtils.isNotEmpty((Collection)refList)) {
            finalIds = refList.stream().map(CompanyUserRef::getDepartmentId).collect(Collectors.toList());
        }
        for (Department department : departments) {
            if (0 < finalIds.size()) {
                department.setAuthorized(finalIds.contains(department.getId()));
            }
            if (!StringUtils.isBlank((String)department.getParentId())) continue;
            result.add(DepartmentUtil.getChildrens(department, departments));
        }
        return result;
    }

    @Override
    @CacheEvict(value={"department"}, allEntries=true)
    public void addUserIntoDepartment(String userId, String departmentId) {
        Department department = (Department)((DepartmentService)SpringContextHolder.getOneBean(DepartmentService.class)).queryObjById(departmentId);
        if (department == null) {
            throw new CommonException("\u627e\u4e0d\u5230\u90e8\u95e8", "not_found_depart");
        }
        CompanyUserRefExample userRefExample = new CompanyUserRefExample();
        userRefExample.createCriteria().andUserIdEqualTo(userId);
        List refList = this.companyUserRefService.queryAllObjByExample((IExample)userRefExample);
        if (CollectionUtils.isEmpty((Collection)refList)) {
            CompanyUserRef ref = new CompanyUserRef();
            ref.setUserId(userId);
            ref.setCompanyId(department.getCompanyId());
            ref.setDepartmentId(departmentId);
            ref.setProjectId(department.getProjectId());
            this.companyUserRefService.addObj(ref);
        } else {
            if (refList.size() > 1) {
                throw new CommonException("\u6570\u636e\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"\u7528\u6237"});
            }
            CompanyUserRef ref = (CompanyUserRef)refList.get(0);
            if (!department.getCompanyId().equals(ref.getCompanyId())) {
                throw new CommonException("\u7528\u6237\u5df2\u5206\u914d", "user_assigned");
            }
            CompanyUserRef tmp = new CompanyUserRef();
            tmp.setId(ref.getId());
            tmp.setDepartmentId(departmentId);
            this.companyUserRefService.modifyObj(tmp);
        }
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public Department queryDepartmentOfUser(String userId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List refList = this.companyUserRefService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)refList)) {
            return null;
        }
        String departmentId = ((CompanyUserRef)refList.get(0)).getDepartmentId();
        if (StringUtils.isBlank((String)departmentId)) {
            return null;
        }
        return this.queryObjById(departmentId);
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<Department> queryDepartmentsOfUser(String userId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List refList = this.companyUserRefService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)refList)) {
            return null;
        }
        ArrayList<Department> result = new ArrayList<Department>();
        refList.forEach(ref -> {
            if (StringUtils.isNotBlank((String)ref.getDepartmentId())) {
                result.add(this.queryObjById(ref.getDepartmentId()));
            }
        });
        return result;
    }

    @Override
    public List<Department> getDepartIdsByUserId(String userId) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(DepartmentTypeEnum.DEPARTMENT.getCode());
        return this.departmentMapper.getDepartmentByUserIdAndDepartmentType(userId, ids);
    }

    @Override
    public List<Department> getInstitutionIdsByUserId(String userId) {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(DepartmentTypeEnum.INSTITUTIONS.getCode());
        ids.add(DepartmentTypeEnum.IN_THE_ORGANIZATION.getCode());
        return this.departmentMapper.getDepartmentByUserIdAndDepartmentType(userId, ids);
    }

    @Override
    public List<Department> getDepartmentLevel(String departmentId) {
        DepartmentExample departmentExample = new DepartmentExample();
        if (StringUtils.isBlank((String)departmentId)) {
            departmentExample.createCriteria().andParentIdIsNull();
        } else {
            Department department = this.queryObjById(departmentId);
            if (null == department) {
                throw new CommonException("id\u4e0d\u5b58\u5728");
            }
            departmentExample.createCriteria().andParentIdEqualTo(departmentId);
        }
        return this.queryAllObjByExample(departmentExample);
    }

    @Override
    public List<AcountSetAndDepartmentDto> getDepartmentIds(String userId, String accountSetId) {
        ArrayList<AcountSetAndDepartmentDto> result = new ArrayList<AcountSetAndDepartmentDto>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("5");
        List<DepartmentDto> dtoList = this.departmentMapper.getDepartmentDto(userId, ids);
        Map<String, List<DepartmentDto>> map = dtoList.stream().collect(Collectors.groupingBy(DepartmentDto::getAccountSet));
        map.forEach((key, value) -> {
            Department department = this.queryObjById((String)key);
            AcountSetAndDepartmentDto dto = new AcountSetAndDepartmentDto();
            if (StringUtils.isNotBlank((String)accountSetId) && key.equals(accountSetId)) {
                dto.setAccountSetId(department.getId());
                dto.setAccountSetCode(department.getDepartmentCode());
                dto.setAccountSetName(department.getDepartmentName());
                dto.setIds(value.stream().map(Department::getId).collect(Collectors.toList()));
            } else {
                dto.setAccountSetId(department.getId());
                dto.setAccountSetCode(department.getDepartmentCode());
                dto.setAccountSetName(department.getDepartmentName());
                dto.setIds(value.stream().map(Department::getId).collect(Collectors.toList()));
            }
            result.add(dto);
        });
        return result;
    }

    @Override
    public DepartmentExcelVO getDepartmentExcelVO(String departmentId) {
        Department department = this.queryObjById(departmentId);
        if (department == null) {
            throw new CommonException("\u90e8\u95e8\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return this.getDepartment(new DepartmentExcelVO(), department);
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<Department> getListTree(String departmentId) {
        ArrayList<Department> result = new ArrayList<Department>();
        if (StringUtils.isBlank((String)departmentId)) {
            List<Department> list = this.queryAllObjByExample(new DepartmentExample());
            list.forEach(department -> {
                if (StringUtils.isBlank((String)department.getParentId())) {
                    result.add(DepartmentUtil.getChildrens(department, list));
                }
            });
        } else {
            List<Department> list = this.departmentMapper.getDepartmentByIdTree(departmentId);
            list.forEach(department -> {
                if (departmentId.equals(department.getId())) {
                    result.add(DepartmentUtil.getChildrens(department, list));
                }
            });
        }
        return result;
    }

    @CacheEvict(value={"department", "userService"}, allEntries=true)
    public void deleteByExample(DepartmentExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.departmentMapper.deleteByExample(example);
    }

    @CacheEvict(value={"department", "userService"}, allEntries=true)
    @Transactional
    public void addAll(List<Department> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.departmentMapper.insertSelective((Department)record));
    }
}

