/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.BankAccount;
import com.els.base.company.entity.BankAccountExample;
import com.els.base.company.entity.Company;
import com.els.base.company.service.BankAccountService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.RoleCheckUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u94f6\u884c\u8d26\u6237\u4fe1\u606f")
@Controller
@RequestMapping(value={"bankAccount"})
public class BankAccountController {
    @Resource
    protected BankAccountService bankAccountService;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u94f6\u884c\u8d26\u6237\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestParam(required=false) String supCompanySrmCode, @RequestBody List<BankAccount> bankAccounts) {
        String projectId = ProjectUtils.getProjectId();
        String companyId = null;
        if (StringUtils.isEmpty((String)supCompanySrmCode)) {
            companyId = CompanyUtils.currentCompanyId();
        } else {
            RoleCheckUtils.requireRole("CGJBR");
            Company supCompany = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (supCompany == null) {
                throw new CommonException("\u4e0d\u5b58\u5728\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a" + supCompanySrmCode + "\u7684\u4f9b\u5e94\u5546");
            }
            companyId = supCompany.getId();
        }
        if (CollectionUtils.isNotEmpty(bankAccounts)) {
            boolean hasDef = false;
            BankAccount first = null;
            for (BankAccount bankAccount : bankAccounts) {
                if (first == null) {
                    first = bankAccount;
                }
                if (Integer.valueOf(1).equals(bankAccount.getDef()) && !hasDef) {
                    hasDef = true;
                    continue;
                }
                bankAccount.setDef(0);
            }
            if (!hasDef) {
                first.setDef(1);
            }
        }
        this.bankAccountService.saveAll(projectId, companyId, bankAccounts);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u94f6\u884c\u8d26\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BankAccount", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BankAccount>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BankAccountExample example = new BankAccountExample();
        example.setPageView((PageView<BankAccount>)new PageView(pageNo, pageSize));
        BankAccountExample.Criteria criteria = example.createCriteria();
        criteria.andInvalidFlagEqualTo("N");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.bankAccountService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u5f53\u524d\u4f01\u4e1a\u6240\u6709\u7684\u94f6\u884c\u8d26\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BankAccount", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<BankAccount>> fetchBankAccounts(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) {
        String projectId = ProjectUtils.getProjectId();
        String companyId = null;
        if (StringUtils.isEmpty((String)supCompanySrmCode)) {
            companyId = CompanyUtils.currentCompanyId();
        } else {
            Company supCompany = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (supCompany == null) {
                throw new CommonException("\u4e0d\u5b58\u5728\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a" + supCompanySrmCode + "\u7684\u4f9b\u5e94\u5546");
            }
            companyId = supCompany.getId();
        }
        BankAccountExample example = new BankAccountExample();
        BankAccountExample.Criteria criteria = example.createCriteria().andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId).andInvalidFlagEqualTo("N");
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List bankAccountList = this.bankAccountService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)bankAccountList);
    }
}

