/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.datacleaning.service.impl;

import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.Department;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.datacleaning.dao.BranchInfosMapper;
import com.els.base.datacleaning.dto.UserInfoDto;
import com.els.base.datacleaning.service.UserInfoService;
import com.els.base.datacleaning.web.vo.AdUserVO;
import com.els.base.datacleaning.web.vo.UserDepartmentRefVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class UserInfoServiceImpl
implements UserInfoService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private StringBuffer sb = null;
    private String password = "123456789";
    @Resource
    private BranchInfosMapper branchInfosMapper;
    @Resource
    private UserService userService;
    @Resource
    private ProjectService projectService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private CompanyUserRefService companyUserRefService;

    @Override
    public String branchDataCleaningUserInfo(String companyId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FDBXK", "SINO_FDIH_LEDGER");
        map.put("SINOL", "SINO_LEDGER");
        map.put("FDPRO", "SINO_CRI_LEDGER");
        map.put("FDAMC", "SINO_AMC_LEDGER");
        map.put("FSTAR", "SINO_FS_LEDGER");
        map.put("HKAMC", "SINO_HKZC_LEDGER");
        map.put("ZD", "SINO_SLD_LEDGER");
        this.sb = new StringBuffer();
        List<AdUserVO> userVOS = this.branchInfosMapper.getAdUserVO();
        List projects = this.projectService.queryAllObjByExample((IExample)new ProjectExample());
        if (CollectionUtils.isEmpty((Collection)projects)) {
            throw new CommonException("\u5c1a\u672a\u627e\u5230\u9879\u76ee\u4fe1\u606f");
        }
        String projectCode = ((Project)projects.get(0)).getProjectCode();
        String projectId = ((Project)projects.get(0)).getId();
        for (AdUserVO userVO : userVOS) {
            List<UserDepartmentRefVO> userDepartmentRefVOS;
            User user = new User();
            String userLoginName = this.getLoginName(userVO.getEmail());
            User u = this.userService.findByUserLoginName(userLoginName);
            if (null == u) {
                UserInfoDto userInfoDto = this.branchInfosMapper.getUserInfoByUnidAndworkNum(userVO.getWorkNum(), userVO.getBusinessUnit());
                if (null != userInfoDto) {
                    user.setNickName(userInfoDto.getName());
                    user.setGender(userInfoDto.getSexCode());
                } else {
                    user.setNickName(userVO.getEmail());
                }
                user.setLoginName(userLoginName);
                user.setPassword(this.password);
                user.setProjectCode(projectCode);
                user.setEmail(userVO.getEmail());
                user.setWorkNum(userVO.getWorkNum());
                user.setIsEnable(Constant.YES_INT);
                this.log.info("##########" + user.getLoginName() + "," + user.getNickName() + "," + user.getEmail());
                this.userService.addObj((Serializable)user);
                u = new User();
                BeanUtils.copyProperties((Object)u, (Object)user);
            }
            if (CollectionUtils.isEmpty(userDepartmentRefVOS = this.branchInfosMapper.getUserDepartmentRefList(userVO.getWorkNum(), (String)map.get(userVO.getBusinessUnit())))) continue;
            for (UserDepartmentRefVO userDepartmentRefVO : userDepartmentRefVOS) {
                Department department = (Department)this.departmentService.queryObjById(userDepartmentRefVO.getDeptNo());
                if (null == department) {
                    this.sb.append("\u90e8\u95e8id=" + userDepartmentRefVO.getDeptNo() + "\u627e\u4e0d\u5230");
                    continue;
                }
                CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
                companyUserRefExample.createCriteria().andCompanyIdEqualTo(companyId).andDepartmentIdEqualTo(department.getId()).andUserIdEqualTo(u.getId());
                if (0 < this.companyUserRefService.countByExample(companyUserRefExample)) continue;
                CompanyUserRef companyUserRef = new CompanyUserRef();
                companyUserRef.setProjectId(projectId);
                companyUserRef.setCompanyId(companyId);
                companyUserRef.setDepartmentId(department.getId());
                companyUserRef.setUserId(u.getId());
                companyUserRef.setCreateTime(new Date());
                this.companyUserRefService.addObj(companyUserRef);
            }
        }
        return this.sb.toString();
    }

    private String getLoginName(String email) {
        String[] strs;
        StringBuffer result = new StringBuffer();
        String str = email.split("@")[0];
        for (String s : strs = str.split("\\.")) {
            result.append(s);
        }
        return result.toString();
    }
}

