/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.datacleaning.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.datacleaning.entity.DepartmentInfo;
import com.els.base.datacleaning.entity.DepartmentInfoExample;
import com.els.base.datacleaning.service.DepartmentInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="OA\u90e8\u95e8\u4fe1\u606f")
@Controller
@RequestMapping(value={"departmentInfo"})
public class DepartmentInfoController {
    @Resource
    protected DepartmentInfoService departmentInfoService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaOA\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DepartmentInfo departmentInfo) {
        this.departmentInfoService.addObj(departmentInfo);
        return ResponseResult.success((Object)departmentInfo.getDeptNo());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91OA\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DepartmentInfo departmentInfo) {
        Assert.isNotNull((Object)departmentInfo.getDeptNo(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.departmentInfoService.modifyObj(departmentInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664OA\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DepartmentInfoExample example = new DepartmentInfoExample();
        example.createCriteria().andDeptNoIn((List)ids);
        this.departmentInfoService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2OA\u90e8\u95e8\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DepartmentInfo", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DepartmentInfo>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        DepartmentInfoExample example = new DepartmentInfoExample();
        example.setPageView((PageView<DepartmentInfo>)new PageView(pageNo, pageSize));
        DepartmentInfoExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.departmentInfoService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u6e05\u6d17\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/branchDataCleaningDepartment"})
    @ResponseBody
    public ResponseResult<String> branchDataCleaningDepartment() {
        return ResponseResult.success((Object)this.departmentInfoService.branchDataCleaningDepartment());
    }
}

