package com.els.base.company.dao;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface CompanyMapper {
    int countByExample(CompanyExample example);

    int deleteByExample(CompanyExample example);

    int deleteByPrimaryKey(String id);

    int insert(Company record);

    int insertSelective(Company record);

    List<Company> selectByExample(CompanyExample example);

    Company selectByPrimaryKey(String id);

    int updateByExampleSelective(@Param("record") Company record, @Param("example") CompanyExample example);

    int updateByExample(@Param("record") Company record, @Param("example") CompanyExample example);

    int updateByPrimaryKeySelective(Company record);

    int updateByPrimaryKey(Company record);

    List<Company> selectByExampleByPage(CompanyExample example);

    void insertBatch(List<Company> list);

    //人工添加的接口

    /**
     * @param example
     * @param purCompanyId
     * @return
     */
    List<Company> selectSupCompanyByPage(@Param("example") CompanyExample example, @Param("purCompanyId") String purCompanyId);

    /**
     * @param example
     * @param purCompanyId
     * @return
     */
    List<Company> selectSupCompany(@Param("example") CompanyExample example, @Param("purCompanyId") String purCompanyId);

    /**
     * 查询企业下的供应商(合作伙伴),根据关系code
     * @param purCompanyId
     * @param companyExample
     * @param partnerRoleCode
     * @return
     */
	List<Company> selectPartnerByExampleByPage(@Param("purCompanyId")String purCompanyId,@Param("example")  CompanyExample companyExample, @Param("partnerRoleCode")String partnerRoleCode);


	/**
	 * 供应新供应商编码申请使用
     * 查询企业下的供应商(合作伙伴),根据关系code
     * @param purCompanyId
     * @param companyExample
     * @param partnerRoleCode
     * @return
     */
	List<Company> selectPartnerByExampleForApplyByPage(@Param("purCompanyId")String purCompanyId,@Param("example")  CompanyExample companyExample, @Param("partnerRoleCode")String partnerRoleCode);

	/**
	 * 查询企业下的所有含sap编码的供应商
	 * @param purCompanyId
	 * @param example
	 * @param roleEnum
	 * @return
	 */
	List<Company> selectCompanyHaveSapByPage(@Param("purCompanyId")String purCompanyId,@Param("example") CompanyExample example,@Param("partnerRoleCode") String partnerRoleCode);

	
	/**
	 * 查询企业下的所有含sap编码的供应商的总数
	 * @param purCompanyId
	 * @param roleEnum 
	 * @param example
	 * @param roleEnum
	 * @return
	 */
	int selectPartCountByExampleByPage(String purCompanyId, CompanyExample companyExample, String roleEnum);

}