package com.els.base.company.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CompanyExample extends AbstractExample<Company> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<Company> pageView = new PageView<Company>(1, 10);

    private static final long serialVersionUID = 1L;

    public CompanyExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<Company> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<Company> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andParentIdIsNull() {
            addCriterion("PARENT_ID is null");
            return (Criteria) this;
        }

        public Criteria andParentIdIsNotNull() {
            addCriterion("PARENT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andParentIdEqualTo(String value) {
            addCriterion("PARENT_ID =", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotEqualTo(String value) {
            addCriterion("PARENT_ID <>", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdGreaterThan(String value) {
            addCriterion("PARENT_ID >", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdGreaterThanOrEqualTo(String value) {
            addCriterion("PARENT_ID >=", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdLessThan(String value) {
            addCriterion("PARENT_ID <", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdLessThanOrEqualTo(String value) {
            addCriterion("PARENT_ID <=", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdLike(String value) {
            addCriterion("PARENT_ID like", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotLike(String value) {
            addCriterion("PARENT_ID not like", value, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdIn(List<String> values) {
            addCriterion("PARENT_ID in", values, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotIn(List<String> values) {
            addCriterion("PARENT_ID not in", values, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdBetween(String value1, String value2) {
            addCriterion("PARENT_ID between", value1, value2, "parentId");
            return (Criteria) this;
        }

        public Criteria andParentIdNotBetween(String value1, String value2) {
            addCriterion("PARENT_ID not between", value1, value2, "parentId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNull() {
            addCriterion("PROJECT_ID is null");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNotNull() {
            addCriterion("PROJECT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProjectIdEqualTo(String value) {
            addCriterion("PROJECT_ID =", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotEqualTo(String value) {
            addCriterion("PROJECT_ID <>", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThan(String value) {
            addCriterion("PROJECT_ID >", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID >=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThan(String value) {
            addCriterion("PROJECT_ID <", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID <=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLike(String value) {
            addCriterion("PROJECT_ID like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotLike(String value) {
            addCriterion("PROJECT_ID not like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIn(List<String> values) {
            addCriterion("PROJECT_ID in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotIn(List<String> values) {
            addCriterion("PROJECT_ID not in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdBetween(String value1, String value2) {
            addCriterion("PROJECT_ID between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotBetween(String value1, String value2) {
            addCriterion("PROJECT_ID not between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andIndustryIsNull() {
            addCriterion("INDUSTRY is null");
            return (Criteria) this;
        }

        public Criteria andIndustryIsNotNull() {
            addCriterion("INDUSTRY is not null");
            return (Criteria) this;
        }

        public Criteria andIndustryEqualTo(String value) {
            addCriterion("INDUSTRY =", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotEqualTo(String value) {
            addCriterion("INDUSTRY <>", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryGreaterThan(String value) {
            addCriterion("INDUSTRY >", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryGreaterThanOrEqualTo(String value) {
            addCriterion("INDUSTRY >=", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryLessThan(String value) {
            addCriterion("INDUSTRY <", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryLessThanOrEqualTo(String value) {
            addCriterion("INDUSTRY <=", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryLike(String value) {
            addCriterion("INDUSTRY like", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotLike(String value) {
            addCriterion("INDUSTRY not like", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryIn(List<String> values) {
            addCriterion("INDUSTRY in", values, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotIn(List<String> values) {
            addCriterion("INDUSTRY not in", values, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryBetween(String value1, String value2) {
            addCriterion("INDUSTRY between", value1, value2, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotBetween(String value1, String value2) {
            addCriterion("INDUSTRY not between", value1, value2, "industry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryIsNull() {
            addCriterion("SUB_INDUSTRY is null");
            return (Criteria) this;
        }

        public Criteria andSubIndustryIsNotNull() {
            addCriterion("SUB_INDUSTRY is not null");
            return (Criteria) this;
        }

        public Criteria andSubIndustryEqualTo(String value) {
            addCriterion("SUB_INDUSTRY =", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryNotEqualTo(String value) {
            addCriterion("SUB_INDUSTRY <>", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryGreaterThan(String value) {
            addCriterion("SUB_INDUSTRY >", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryGreaterThanOrEqualTo(String value) {
            addCriterion("SUB_INDUSTRY >=", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryLessThan(String value) {
            addCriterion("SUB_INDUSTRY <", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryLessThanOrEqualTo(String value) {
            addCriterion("SUB_INDUSTRY <=", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryLike(String value) {
            addCriterion("SUB_INDUSTRY like", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryNotLike(String value) {
            addCriterion("SUB_INDUSTRY not like", value, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryIn(List<String> values) {
            addCriterion("SUB_INDUSTRY in", values, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryNotIn(List<String> values) {
            addCriterion("SUB_INDUSTRY not in", values, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryBetween(String value1, String value2) {
            addCriterion("SUB_INDUSTRY between", value1, value2, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andSubIndustryNotBetween(String value1, String value2) {
            addCriterion("SUB_INDUSTRY not between", value1, value2, "subIndustry");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIsNull() {
            addCriterion("COMPANY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIsNotNull() {
            addCriterion("COMPANY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeEqualTo(String value) {
            addCriterion("COMPANY_CODE =", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotEqualTo(String value) {
            addCriterion("COMPANY_CODE <>", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeGreaterThan(String value) {
            addCriterion("COMPANY_CODE >", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_CODE >=", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLessThan(String value) {
            addCriterion("COMPANY_CODE <", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_CODE <=", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeLike(String value) {
            addCriterion("COMPANY_CODE like", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotLike(String value) {
            addCriterion("COMPANY_CODE not like", value, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeIn(List<String> values) {
            addCriterion("COMPANY_CODE in", values, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotIn(List<String> values) {
            addCriterion("COMPANY_CODE not in", values, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeBetween(String value1, String value2) {
            addCriterion("COMPANY_CODE between", value1, value2, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanyCodeNotBetween(String value1, String value2) {
            addCriterion("COMPANY_CODE not between", value1, value2, "companyCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeIsNull() {
            addCriterion("COMPANY_SAP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeIsNotNull() {
            addCriterion("COMPANY_SAP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE =", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE <>", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeGreaterThan(String value) {
            addCriterion("COMPANY_SAP_CODE >", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE >=", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeLessThan(String value) {
            addCriterion("COMPANY_SAP_CODE <", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_SAP_CODE <=", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeLike(String value) {
            addCriterion("COMPANY_SAP_CODE like", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotLike(String value) {
            addCriterion("COMPANY_SAP_CODE not like", value, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeIn(List<String> values) {
            addCriterion("COMPANY_SAP_CODE in", values, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotIn(List<String> values) {
            addCriterion("COMPANY_SAP_CODE not in", values, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeBetween(String value1, String value2) {
            addCriterion("COMPANY_SAP_CODE between", value1, value2, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanySapCodeNotBetween(String value1, String value2) {
            addCriterion("COMPANY_SAP_CODE not between", value1, value2, "companySapCode");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIsNull() {
            addCriterion("COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIsNotNull() {
            addCriterion("COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyNameEqualTo(String value) {
            addCriterion("COMPANY_NAME =", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotEqualTo(String value) {
            addCriterion("COMPANY_NAME <>", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameGreaterThan(String value) {
            addCriterion("COMPANY_NAME >", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_NAME >=", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLessThan(String value) {
            addCriterion("COMPANY_NAME <", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_NAME <=", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameLike(String value) {
            addCriterion("COMPANY_NAME like", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotLike(String value) {
            addCriterion("COMPANY_NAME not like", value, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameIn(List<String> values) {
            addCriterion("COMPANY_NAME in", values, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotIn(List<String> values) {
            addCriterion("COMPANY_NAME not in", values, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameBetween(String value1, String value2) {
            addCriterion("COMPANY_NAME between", value1, value2, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyNameNotBetween(String value1, String value2) {
            addCriterion("COMPANY_NAME not between", value1, value2, "companyName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameIsNull() {
            addCriterion("COMPANY_FULL_NAME is null");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameIsNotNull() {
            addCriterion("COMPANY_FULL_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameEqualTo(String value) {
            addCriterion("COMPANY_FULL_NAME =", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameNotEqualTo(String value) {
            addCriterion("COMPANY_FULL_NAME <>", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameGreaterThan(String value) {
            addCriterion("COMPANY_FULL_NAME >", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_FULL_NAME >=", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameLessThan(String value) {
            addCriterion("COMPANY_FULL_NAME <", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_FULL_NAME <=", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameLike(String value) {
            addCriterion("COMPANY_FULL_NAME like", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameNotLike(String value) {
            addCriterion("COMPANY_FULL_NAME not like", value, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameIn(List<String> values) {
            addCriterion("COMPANY_FULL_NAME in", values, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameNotIn(List<String> values) {
            addCriterion("COMPANY_FULL_NAME not in", values, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameBetween(String value1, String value2) {
            addCriterion("COMPANY_FULL_NAME between", value1, value2, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyFullNameNotBetween(String value1, String value2) {
            addCriterion("COMPANY_FULL_NAME not between", value1, value2, "companyFullName");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeIsNull() {
            addCriterion("COMPANY_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeIsNotNull() {
            addCriterion("COMPANY_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeEqualTo(String value) {
            addCriterion("COMPANY_TYPE =", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeNotEqualTo(String value) {
            addCriterion("COMPANY_TYPE <>", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeGreaterThan(String value) {
            addCriterion("COMPANY_TYPE >", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_TYPE >=", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeLessThan(String value) {
            addCriterion("COMPANY_TYPE <", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_TYPE <=", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeLike(String value) {
            addCriterion("COMPANY_TYPE like", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeNotLike(String value) {
            addCriterion("COMPANY_TYPE not like", value, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeIn(List<String> values) {
            addCriterion("COMPANY_TYPE in", values, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeNotIn(List<String> values) {
            addCriterion("COMPANY_TYPE not in", values, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeBetween(String value1, String value2) {
            addCriterion("COMPANY_TYPE between", value1, value2, "companyType");
            return (Criteria) this;
        }

        public Criteria andCompanyTypeNotBetween(String value1, String value2) {
            addCriterion("COMPANY_TYPE not between", value1, value2, "companyType");
            return (Criteria) this;
        }

        public Criteria andBusinessScopIsNull() {
            addCriterion("BUSINESS_SCOP is null");
            return (Criteria) this;
        }

        public Criteria andBusinessScopIsNotNull() {
            addCriterion("BUSINESS_SCOP is not null");
            return (Criteria) this;
        }

        public Criteria andBusinessScopEqualTo(String value) {
            addCriterion("BUSINESS_SCOP =", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopNotEqualTo(String value) {
            addCriterion("BUSINESS_SCOP <>", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopGreaterThan(String value) {
            addCriterion("BUSINESS_SCOP >", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopGreaterThanOrEqualTo(String value) {
            addCriterion("BUSINESS_SCOP >=", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopLessThan(String value) {
            addCriterion("BUSINESS_SCOP <", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopLessThanOrEqualTo(String value) {
            addCriterion("BUSINESS_SCOP <=", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopLike(String value) {
            addCriterion("BUSINESS_SCOP like", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopNotLike(String value) {
            addCriterion("BUSINESS_SCOP not like", value, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopIn(List<String> values) {
            addCriterion("BUSINESS_SCOP in", values, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopNotIn(List<String> values) {
            addCriterion("BUSINESS_SCOP not in", values, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopBetween(String value1, String value2) {
            addCriterion("BUSINESS_SCOP between", value1, value2, "businessScop");
            return (Criteria) this;
        }

        public Criteria andBusinessScopNotBetween(String value1, String value2) {
            addCriterion("BUSINESS_SCOP not between", value1, value2, "businessScop");
            return (Criteria) this;
        }

        public Criteria andTaxCertIsNull() {
            addCriterion("TAX_CERT is null");
            return (Criteria) this;
        }

        public Criteria andTaxCertIsNotNull() {
            addCriterion("TAX_CERT is not null");
            return (Criteria) this;
        }

        public Criteria andTaxCertEqualTo(String value) {
            addCriterion("TAX_CERT =", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertNotEqualTo(String value) {
            addCriterion("TAX_CERT <>", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertGreaterThan(String value) {
            addCriterion("TAX_CERT >", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertGreaterThanOrEqualTo(String value) {
            addCriterion("TAX_CERT >=", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertLessThan(String value) {
            addCriterion("TAX_CERT <", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertLessThanOrEqualTo(String value) {
            addCriterion("TAX_CERT <=", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertLike(String value) {
            addCriterion("TAX_CERT like", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertNotLike(String value) {
            addCriterion("TAX_CERT not like", value, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertIn(List<String> values) {
            addCriterion("TAX_CERT in", values, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertNotIn(List<String> values) {
            addCriterion("TAX_CERT not in", values, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertBetween(String value1, String value2) {
            addCriterion("TAX_CERT between", value1, value2, "taxCert");
            return (Criteria) this;
        }

        public Criteria andTaxCertNotBetween(String value1, String value2) {
            addCriterion("TAX_CERT not between", value1, value2, "taxCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertIsNull() {
            addCriterion("ORGANZATION_CERT is null");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertIsNotNull() {
            addCriterion("ORGANZATION_CERT is not null");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertEqualTo(String value) {
            addCriterion("ORGANZATION_CERT =", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertNotEqualTo(String value) {
            addCriterion("ORGANZATION_CERT <>", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertGreaterThan(String value) {
            addCriterion("ORGANZATION_CERT >", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertGreaterThanOrEqualTo(String value) {
            addCriterion("ORGANZATION_CERT >=", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertLessThan(String value) {
            addCriterion("ORGANZATION_CERT <", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertLessThanOrEqualTo(String value) {
            addCriterion("ORGANZATION_CERT <=", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertLike(String value) {
            addCriterion("ORGANZATION_CERT like", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertNotLike(String value) {
            addCriterion("ORGANZATION_CERT not like", value, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertIn(List<String> values) {
            addCriterion("ORGANZATION_CERT in", values, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertNotIn(List<String> values) {
            addCriterion("ORGANZATION_CERT not in", values, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertBetween(String value1, String value2) {
            addCriterion("ORGANZATION_CERT between", value1, value2, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andOrganzationCertNotBetween(String value1, String value2) {
            addCriterion("ORGANZATION_CERT not between", value1, value2, "organzationCert");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceIsNull() {
            addCriterion("BUSINESS_LICENCE is null");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceIsNotNull() {
            addCriterion("BUSINESS_LICENCE is not null");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceEqualTo(String value) {
            addCriterion("BUSINESS_LICENCE =", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceNotEqualTo(String value) {
            addCriterion("BUSINESS_LICENCE <>", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceGreaterThan(String value) {
            addCriterion("BUSINESS_LICENCE >", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceGreaterThanOrEqualTo(String value) {
            addCriterion("BUSINESS_LICENCE >=", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceLessThan(String value) {
            addCriterion("BUSINESS_LICENCE <", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceLessThanOrEqualTo(String value) {
            addCriterion("BUSINESS_LICENCE <=", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceLike(String value) {
            addCriterion("BUSINESS_LICENCE like", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceNotLike(String value) {
            addCriterion("BUSINESS_LICENCE not like", value, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceIn(List<String> values) {
            addCriterion("BUSINESS_LICENCE in", values, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceNotIn(List<String> values) {
            addCriterion("BUSINESS_LICENCE not in", values, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceBetween(String value1, String value2) {
            addCriterion("BUSINESS_LICENCE between", value1, value2, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenceNotBetween(String value1, String value2) {
            addCriterion("BUSINESS_LICENCE not between", value1, value2, "businessLicence");
            return (Criteria) this;
        }

        public Criteria andCountryIsNull() {
            addCriterion("COUNTRY is null");
            return (Criteria) this;
        }

        public Criteria andCountryIsNotNull() {
            addCriterion("COUNTRY is not null");
            return (Criteria) this;
        }

        public Criteria andCountryEqualTo(String value) {
            addCriterion("COUNTRY =", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotEqualTo(String value) {
            addCriterion("COUNTRY <>", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryGreaterThan(String value) {
            addCriterion("COUNTRY >", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryGreaterThanOrEqualTo(String value) {
            addCriterion("COUNTRY >=", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLessThan(String value) {
            addCriterion("COUNTRY <", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLessThanOrEqualTo(String value) {
            addCriterion("COUNTRY <=", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLike(String value) {
            addCriterion("COUNTRY like", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotLike(String value) {
            addCriterion("COUNTRY not like", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryIn(List<String> values) {
            addCriterion("COUNTRY in", values, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotIn(List<String> values) {
            addCriterion("COUNTRY not in", values, "country");
            return (Criteria) this;
        }

        public Criteria andCountryBetween(String value1, String value2) {
            addCriterion("COUNTRY between", value1, value2, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotBetween(String value1, String value2) {
            addCriterion("COUNTRY not between", value1, value2, "country");
            return (Criteria) this;
        }

        public Criteria andProvinceIsNull() {
            addCriterion("PROVINCE is null");
            return (Criteria) this;
        }

        public Criteria andProvinceIsNotNull() {
            addCriterion("PROVINCE is not null");
            return (Criteria) this;
        }

        public Criteria andProvinceEqualTo(String value) {
            addCriterion("PROVINCE =", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceNotEqualTo(String value) {
            addCriterion("PROVINCE <>", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceGreaterThan(String value) {
            addCriterion("PROVINCE >", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceGreaterThanOrEqualTo(String value) {
            addCriterion("PROVINCE >=", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceLessThan(String value) {
            addCriterion("PROVINCE <", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceLessThanOrEqualTo(String value) {
            addCriterion("PROVINCE <=", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceLike(String value) {
            addCriterion("PROVINCE like", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceNotLike(String value) {
            addCriterion("PROVINCE not like", value, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceIn(List<String> values) {
            addCriterion("PROVINCE in", values, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceNotIn(List<String> values) {
            addCriterion("PROVINCE not in", values, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceBetween(String value1, String value2) {
            addCriterion("PROVINCE between", value1, value2, "province");
            return (Criteria) this;
        }

        public Criteria andProvinceNotBetween(String value1, String value2) {
            addCriterion("PROVINCE not between", value1, value2, "province");
            return (Criteria) this;
        }

        public Criteria andCityIsNull() {
            addCriterion("CITY is null");
            return (Criteria) this;
        }

        public Criteria andCityIsNotNull() {
            addCriterion("CITY is not null");
            return (Criteria) this;
        }

        public Criteria andCityEqualTo(String value) {
            addCriterion("CITY =", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityNotEqualTo(String value) {
            addCriterion("CITY <>", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityGreaterThan(String value) {
            addCriterion("CITY >", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityGreaterThanOrEqualTo(String value) {
            addCriterion("CITY >=", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityLessThan(String value) {
            addCriterion("CITY <", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityLessThanOrEqualTo(String value) {
            addCriterion("CITY <=", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityLike(String value) {
            addCriterion("CITY like", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityNotLike(String value) {
            addCriterion("CITY not like", value, "city");
            return (Criteria) this;
        }

        public Criteria andCityIn(List<String> values) {
            addCriterion("CITY in", values, "city");
            return (Criteria) this;
        }

        public Criteria andCityNotIn(List<String> values) {
            addCriterion("CITY not in", values, "city");
            return (Criteria) this;
        }

        public Criteria andCityBetween(String value1, String value2) {
            addCriterion("CITY between", value1, value2, "city");
            return (Criteria) this;
        }

        public Criteria andCityNotBetween(String value1, String value2) {
            addCriterion("CITY not between", value1, value2, "city");
            return (Criteria) this;
        }

        public Criteria andAddressIsNull() {
            addCriterion("ADDRESS is null");
            return (Criteria) this;
        }

        public Criteria andAddressIsNotNull() {
            addCriterion("ADDRESS is not null");
            return (Criteria) this;
        }

        public Criteria andAddressEqualTo(String value) {
            addCriterion("ADDRESS =", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotEqualTo(String value) {
            addCriterion("ADDRESS <>", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressGreaterThan(String value) {
            addCriterion("ADDRESS >", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressGreaterThanOrEqualTo(String value) {
            addCriterion("ADDRESS >=", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressLessThan(String value) {
            addCriterion("ADDRESS <", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressLessThanOrEqualTo(String value) {
            addCriterion("ADDRESS <=", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressLike(String value) {
            addCriterion("ADDRESS like", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotLike(String value) {
            addCriterion("ADDRESS not like", value, "address");
            return (Criteria) this;
        }

        public Criteria andAddressIn(List<String> values) {
            addCriterion("ADDRESS in", values, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotIn(List<String> values) {
            addCriterion("ADDRESS not in", values, "address");
            return (Criteria) this;
        }

        public Criteria andAddressBetween(String value1, String value2) {
            addCriterion("ADDRESS between", value1, value2, "address");
            return (Criteria) this;
        }

        public Criteria andAddressNotBetween(String value1, String value2) {
            addCriterion("ADDRESS not between", value1, value2, "address");
            return (Criteria) this;
        }

        public Criteria andMobilephoneIsNull() {
            addCriterion("MOBILEPHONE is null");
            return (Criteria) this;
        }

        public Criteria andMobilephoneIsNotNull() {
            addCriterion("MOBILEPHONE is not null");
            return (Criteria) this;
        }

        public Criteria andMobilephoneEqualTo(String value) {
            addCriterion("MOBILEPHONE =", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneNotEqualTo(String value) {
            addCriterion("MOBILEPHONE <>", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneGreaterThan(String value) {
            addCriterion("MOBILEPHONE >", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneGreaterThanOrEqualTo(String value) {
            addCriterion("MOBILEPHONE >=", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneLessThan(String value) {
            addCriterion("MOBILEPHONE <", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneLessThanOrEqualTo(String value) {
            addCriterion("MOBILEPHONE <=", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneLike(String value) {
            addCriterion("MOBILEPHONE like", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneNotLike(String value) {
            addCriterion("MOBILEPHONE not like", value, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneIn(List<String> values) {
            addCriterion("MOBILEPHONE in", values, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneNotIn(List<String> values) {
            addCriterion("MOBILEPHONE not in", values, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneBetween(String value1, String value2) {
            addCriterion("MOBILEPHONE between", value1, value2, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andMobilephoneNotBetween(String value1, String value2) {
            addCriterion("MOBILEPHONE not between", value1, value2, "mobilephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneIsNull() {
            addCriterion("TELEPHONE is null");
            return (Criteria) this;
        }

        public Criteria andTelephoneIsNotNull() {
            addCriterion("TELEPHONE is not null");
            return (Criteria) this;
        }

        public Criteria andTelephoneEqualTo(String value) {
            addCriterion("TELEPHONE =", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneNotEqualTo(String value) {
            addCriterion("TELEPHONE <>", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneGreaterThan(String value) {
            addCriterion("TELEPHONE >", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneGreaterThanOrEqualTo(String value) {
            addCriterion("TELEPHONE >=", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneLessThan(String value) {
            addCriterion("TELEPHONE <", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneLessThanOrEqualTo(String value) {
            addCriterion("TELEPHONE <=", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneLike(String value) {
            addCriterion("TELEPHONE like", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneNotLike(String value) {
            addCriterion("TELEPHONE not like", value, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneIn(List<String> values) {
            addCriterion("TELEPHONE in", values, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneNotIn(List<String> values) {
            addCriterion("TELEPHONE not in", values, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneBetween(String value1, String value2) {
            addCriterion("TELEPHONE between", value1, value2, "telephone");
            return (Criteria) this;
        }

        public Criteria andTelephoneNotBetween(String value1, String value2) {
            addCriterion("TELEPHONE not between", value1, value2, "telephone");
            return (Criteria) this;
        }

        public Criteria andFaxIsNull() {
            addCriterion("FAX is null");
            return (Criteria) this;
        }

        public Criteria andFaxIsNotNull() {
            addCriterion("FAX is not null");
            return (Criteria) this;
        }

        public Criteria andFaxEqualTo(String value) {
            addCriterion("FAX =", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxNotEqualTo(String value) {
            addCriterion("FAX <>", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxGreaterThan(String value) {
            addCriterion("FAX >", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxGreaterThanOrEqualTo(String value) {
            addCriterion("FAX >=", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxLessThan(String value) {
            addCriterion("FAX <", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxLessThanOrEqualTo(String value) {
            addCriterion("FAX <=", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxLike(String value) {
            addCriterion("FAX like", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxNotLike(String value) {
            addCriterion("FAX not like", value, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxIn(List<String> values) {
            addCriterion("FAX in", values, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxNotIn(List<String> values) {
            addCriterion("FAX not in", values, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxBetween(String value1, String value2) {
            addCriterion("FAX between", value1, value2, "fax");
            return (Criteria) this;
        }

        public Criteria andFaxNotBetween(String value1, String value2) {
            addCriterion("FAX not between", value1, value2, "fax");
            return (Criteria) this;
        }

        public Criteria andEmailIsNull() {
            addCriterion("EMAIL is null");
            return (Criteria) this;
        }

        public Criteria andEmailIsNotNull() {
            addCriterion("EMAIL is not null");
            return (Criteria) this;
        }

        public Criteria andEmailEqualTo(String value) {
            addCriterion("EMAIL =", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotEqualTo(String value) {
            addCriterion("EMAIL <>", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailGreaterThan(String value) {
            addCriterion("EMAIL >", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailGreaterThanOrEqualTo(String value) {
            addCriterion("EMAIL >=", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailLessThan(String value) {
            addCriterion("EMAIL <", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailLessThanOrEqualTo(String value) {
            addCriterion("EMAIL <=", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailLike(String value) {
            addCriterion("EMAIL like", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotLike(String value) {
            addCriterion("EMAIL not like", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailIn(List<String> values) {
            addCriterion("EMAIL in", values, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotIn(List<String> values) {
            addCriterion("EMAIL not in", values, "email");
            return (Criteria) this;
        }

        public Criteria andEmailBetween(String value1, String value2) {
            addCriterion("EMAIL between", value1, value2, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotBetween(String value1, String value2) {
            addCriterion("EMAIL not between", value1, value2, "email");
            return (Criteria) this;
        }

        public Criteria andWebsiteIsNull() {
            addCriterion("WEBSITE is null");
            return (Criteria) this;
        }

        public Criteria andWebsiteIsNotNull() {
            addCriterion("WEBSITE is not null");
            return (Criteria) this;
        }

        public Criteria andWebsiteEqualTo(String value) {
            addCriterion("WEBSITE =", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteNotEqualTo(String value) {
            addCriterion("WEBSITE <>", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteGreaterThan(String value) {
            addCriterion("WEBSITE >", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteGreaterThanOrEqualTo(String value) {
            addCriterion("WEBSITE >=", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteLessThan(String value) {
            addCriterion("WEBSITE <", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteLessThanOrEqualTo(String value) {
            addCriterion("WEBSITE <=", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteLike(String value) {
            addCriterion("WEBSITE like", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteNotLike(String value) {
            addCriterion("WEBSITE not like", value, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteIn(List<String> values) {
            addCriterion("WEBSITE in", values, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteNotIn(List<String> values) {
            addCriterion("WEBSITE not in", values, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteBetween(String value1, String value2) {
            addCriterion("WEBSITE between", value1, value2, "website");
            return (Criteria) this;
        }

        public Criteria andWebsiteNotBetween(String value1, String value2) {
            addCriterion("WEBSITE not between", value1, value2, "website");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNull() {
            addCriterion("REMARK is null");
            return (Criteria) this;
        }

        public Criteria andRemarkIsNotNull() {
            addCriterion("REMARK is not null");
            return (Criteria) this;
        }

        public Criteria andRemarkEqualTo(String value) {
            addCriterion("REMARK =", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotEqualTo(String value) {
            addCriterion("REMARK <>", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThan(String value) {
            addCriterion("REMARK >", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkGreaterThanOrEqualTo(String value) {
            addCriterion("REMARK >=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThan(String value) {
            addCriterion("REMARK <", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLessThanOrEqualTo(String value) {
            addCriterion("REMARK <=", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkLike(String value) {
            addCriterion("REMARK like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotLike(String value) {
            addCriterion("REMARK not like", value, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkIn(List<String> values) {
            addCriterion("REMARK in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotIn(List<String> values) {
            addCriterion("REMARK not in", values, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkBetween(String value1, String value2) {
            addCriterion("REMARK between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andRemarkNotBetween(String value1, String value2) {
            addCriterion("REMARK not between", value1, value2, "remark");
            return (Criteria) this;
        }

        public Criteria andContactsIsNull() {
            addCriterion("CONTACTS is null");
            return (Criteria) this;
        }

        public Criteria andContactsIsNotNull() {
            addCriterion("CONTACTS is not null");
            return (Criteria) this;
        }

        public Criteria andContactsEqualTo(String value) {
            addCriterion("CONTACTS =", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsNotEqualTo(String value) {
            addCriterion("CONTACTS <>", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsGreaterThan(String value) {
            addCriterion("CONTACTS >", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsGreaterThanOrEqualTo(String value) {
            addCriterion("CONTACTS >=", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsLessThan(String value) {
            addCriterion("CONTACTS <", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsLessThanOrEqualTo(String value) {
            addCriterion("CONTACTS <=", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsLike(String value) {
            addCriterion("CONTACTS like", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsNotLike(String value) {
            addCriterion("CONTACTS not like", value, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsIn(List<String> values) {
            addCriterion("CONTACTS in", values, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsNotIn(List<String> values) {
            addCriterion("CONTACTS not in", values, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsBetween(String value1, String value2) {
            addCriterion("CONTACTS between", value1, value2, "contacts");
            return (Criteria) this;
        }

        public Criteria andContactsNotBetween(String value1, String value2) {
            addCriterion("CONTACTS not between", value1, value2, "contacts");
            return (Criteria) this;
        }

        public Criteria andStatusIsNull() {
            addCriterion("STATUS is null");
            return (Criteria) this;
        }

        public Criteria andStatusIsNotNull() {
            addCriterion("STATUS is not null");
            return (Criteria) this;
        }

        public Criteria andStatusEqualTo(Integer value) {
            addCriterion("STATUS =", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotEqualTo(Integer value) {
            addCriterion("STATUS <>", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThan(Integer value) {
            addCriterion("STATUS >", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThanOrEqualTo(Integer value) {
            addCriterion("STATUS >=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThan(Integer value) {
            addCriterion("STATUS <", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThanOrEqualTo(Integer value) {
            addCriterion("STATUS <=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusIn(List<Integer> values) {
            addCriterion("STATUS in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotIn(List<Integer> values) {
            addCriterion("STATUS not in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusBetween(Integer value1, Integer value2) {
            addCriterion("STATUS between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotBetween(Integer value1, Integer value2) {
            addCriterion("STATUS not between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerIsNull() {
            addCriterion("EXTERNAL_MANUFACTURER is null");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerIsNotNull() {
            addCriterion("EXTERNAL_MANUFACTURER is not null");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerEqualTo(String value) {
            addCriterion("EXTERNAL_MANUFACTURER =", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerNotEqualTo(String value) {
            addCriterion("EXTERNAL_MANUFACTURER <>", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerGreaterThan(String value) {
            addCriterion("EXTERNAL_MANUFACTURER >", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerGreaterThanOrEqualTo(String value) {
            addCriterion("EXTERNAL_MANUFACTURER >=", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerLessThan(String value) {
            addCriterion("EXTERNAL_MANUFACTURER <", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerLessThanOrEqualTo(String value) {
            addCriterion("EXTERNAL_MANUFACTURER <=", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerLike(String value) {
            addCriterion("EXTERNAL_MANUFACTURER like", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerNotLike(String value) {
            addCriterion("EXTERNAL_MANUFACTURER not like", value, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerIn(List<String> values) {
            addCriterion("EXTERNAL_MANUFACTURER in", values, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerNotIn(List<String> values) {
            addCriterion("EXTERNAL_MANUFACTURER not in", values, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerBetween(String value1, String value2) {
            addCriterion("EXTERNAL_MANUFACTURER between", value1, value2, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andExternalManufacturerNotBetween(String value1, String value2) {
            addCriterion("EXTERNAL_MANUFACTURER not between", value1, value2, "externalManufacturer");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffIsNull() {
            addCriterion("PURCHASING_STAFF is null");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffIsNotNull() {
            addCriterion("PURCHASING_STAFF is not null");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffEqualTo(String value) {
            addCriterion("PURCHASING_STAFF =", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffNotEqualTo(String value) {
            addCriterion("PURCHASING_STAFF <>", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffGreaterThan(String value) {
            addCriterion("PURCHASING_STAFF >", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASING_STAFF >=", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffLessThan(String value) {
            addCriterion("PURCHASING_STAFF <", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffLessThanOrEqualTo(String value) {
            addCriterion("PURCHASING_STAFF <=", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffLike(String value) {
            addCriterion("PURCHASING_STAFF like", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffNotLike(String value) {
            addCriterion("PURCHASING_STAFF not like", value, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffIn(List<String> values) {
            addCriterion("PURCHASING_STAFF in", values, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffNotIn(List<String> values) {
            addCriterion("PURCHASING_STAFF not in", values, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffBetween(String value1, String value2) {
            addCriterion("PURCHASING_STAFF between", value1, value2, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andPurchasingStaffNotBetween(String value1, String value2) {
            addCriterion("PURCHASING_STAFF not between", value1, value2, "purchasingStaff");
            return (Criteria) this;
        }

        public Criteria andGroupCodeIsNull() {
            addCriterion("GROUP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andGroupCodeIsNotNull() {
            addCriterion("GROUP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andGroupCodeEqualTo(String value) {
            addCriterion("GROUP_CODE =", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeNotEqualTo(String value) {
            addCriterion("GROUP_CODE <>", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeGreaterThan(String value) {
            addCriterion("GROUP_CODE >", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeGreaterThanOrEqualTo(String value) {
            addCriterion("GROUP_CODE >=", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeLessThan(String value) {
            addCriterion("GROUP_CODE <", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeLessThanOrEqualTo(String value) {
            addCriterion("GROUP_CODE <=", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeLike(String value) {
            addCriterion("GROUP_CODE like", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeNotLike(String value) {
            addCriterion("GROUP_CODE not like", value, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeIn(List<String> values) {
            addCriterion("GROUP_CODE in", values, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeNotIn(List<String> values) {
            addCriterion("GROUP_CODE not in", values, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeBetween(String value1, String value2) {
            addCriterion("GROUP_CODE between", value1, value2, "groupCode");
            return (Criteria) this;
        }

        public Criteria andGroupCodeNotBetween(String value1, String value2) {
            addCriterion("GROUP_CODE not between", value1, value2, "groupCode");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeIsNull() {
            addCriterion("DELEGATE_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeIsNotNull() {
            addCriterion("DELEGATE_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeEqualTo(String value) {
            addCriterion("DELEGATE_TYPE =", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeNotEqualTo(String value) {
            addCriterion("DELEGATE_TYPE <>", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeGreaterThan(String value) {
            addCriterion("DELEGATE_TYPE >", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeGreaterThanOrEqualTo(String value) {
            addCriterion("DELEGATE_TYPE >=", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeLessThan(String value) {
            addCriterion("DELEGATE_TYPE <", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeLessThanOrEqualTo(String value) {
            addCriterion("DELEGATE_TYPE <=", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeLike(String value) {
            addCriterion("DELEGATE_TYPE like", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeNotLike(String value) {
            addCriterion("DELEGATE_TYPE not like", value, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeIn(List<String> values) {
            addCriterion("DELEGATE_TYPE in", values, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeNotIn(List<String> values) {
            addCriterion("DELEGATE_TYPE not in", values, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeBetween(String value1, String value2) {
            addCriterion("DELEGATE_TYPE between", value1, value2, "delegateType");
            return (Criteria) this;
        }

        public Criteria andDelegateTypeNotBetween(String value1, String value2) {
            addCriterion("DELEGATE_TYPE not between", value1, value2, "delegateType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeIsNull() {
            addCriterion("BUSINESS_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeIsNotNull() {
            addCriterion("BUSINESS_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeEqualTo(String value) {
            addCriterion("BUSINESS_TYPE =", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeNotEqualTo(String value) {
            addCriterion("BUSINESS_TYPE <>", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeGreaterThan(String value) {
            addCriterion("BUSINESS_TYPE >", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeGreaterThanOrEqualTo(String value) {
            addCriterion("BUSINESS_TYPE >=", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeLessThan(String value) {
            addCriterion("BUSINESS_TYPE <", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeLessThanOrEqualTo(String value) {
            addCriterion("BUSINESS_TYPE <=", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeLike(String value) {
            addCriterion("BUSINESS_TYPE like", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeNotLike(String value) {
            addCriterion("BUSINESS_TYPE not like", value, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeIn(List<String> values) {
            addCriterion("BUSINESS_TYPE in", values, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeNotIn(List<String> values) {
            addCriterion("BUSINESS_TYPE not in", values, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeBetween(String value1, String value2) {
            addCriterion("BUSINESS_TYPE between", value1, value2, "businessType");
            return (Criteria) this;
        }

        public Criteria andBusinessTypeNotBetween(String value1, String value2) {
            addCriterion("BUSINESS_TYPE not between", value1, value2, "businessType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeIsNull() {
            addCriterion("INDUSTRIAL_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeIsNotNull() {
            addCriterion("INDUSTRIAL_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeEqualTo(String value) {
            addCriterion("INDUSTRIAL_TYPE =", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeNotEqualTo(String value) {
            addCriterion("INDUSTRIAL_TYPE <>", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeGreaterThan(String value) {
            addCriterion("INDUSTRIAL_TYPE >", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeGreaterThanOrEqualTo(String value) {
            addCriterion("INDUSTRIAL_TYPE >=", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeLessThan(String value) {
            addCriterion("INDUSTRIAL_TYPE <", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeLessThanOrEqualTo(String value) {
            addCriterion("INDUSTRIAL_TYPE <=", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeLike(String value) {
            addCriterion("INDUSTRIAL_TYPE like", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeNotLike(String value) {
            addCriterion("INDUSTRIAL_TYPE not like", value, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeIn(List<String> values) {
            addCriterion("INDUSTRIAL_TYPE in", values, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeNotIn(List<String> values) {
            addCriterion("INDUSTRIAL_TYPE not in", values, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeBetween(String value1, String value2) {
            addCriterion("INDUSTRIAL_TYPE between", value1, value2, "industrialType");
            return (Criteria) this;
        }

        public Criteria andIndustrialTypeNotBetween(String value1, String value2) {
            addCriterion("INDUSTRIAL_TYPE not between", value1, value2, "industrialType");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeIsNull() {
            addCriterion("RECONCILIATION_ACCOUNT_CODE is null");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeIsNotNull() {
            addCriterion("RECONCILIATION_ACCOUNT_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE =", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeNotEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE <>", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeGreaterThan(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE >", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeGreaterThanOrEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE >=", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeLessThan(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE <", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeLessThanOrEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE <=", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeLike(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE like", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeNotLike(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE not like", value, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeIn(List<String> values) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE in", values, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeNotIn(List<String> values) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE not in", values, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeBetween(String value1, String value2) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE between", value1, value2, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountCodeNotBetween(String value1, String value2) {
            addCriterion("RECONCILIATION_ACCOUNT_CODE not between", value1, value2, "reconciliationAccountCode");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameIsNull() {
            addCriterion("RECONCILIATION_ACCOUNT_NAME is null");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameIsNotNull() {
            addCriterion("RECONCILIATION_ACCOUNT_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME =", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameNotEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME <>", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameGreaterThan(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME >", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameGreaterThanOrEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME >=", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameLessThan(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME <", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameLessThanOrEqualTo(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME <=", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameLike(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME like", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameNotLike(String value) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME not like", value, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameIn(List<String> values) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME in", values, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameNotIn(List<String> values) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME not in", values, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameBetween(String value1, String value2) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME between", value1, value2, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andReconciliationAccountNameNotBetween(String value1, String value2) {
            addCriterion("RECONCILIATION_ACCOUNT_NAME not between", value1, value2, "reconciliationAccountName");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeIsNull() {
            addCriterion("PAY_CONDITIONS_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeIsNotNull() {
            addCriterion("PAY_CONDITIONS_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_CODE =", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeNotEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_CODE <>", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeGreaterThan(String value) {
            addCriterion("PAY_CONDITIONS_CODE >", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_CODE >=", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeLessThan(String value) {
            addCriterion("PAY_CONDITIONS_CODE <", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeLessThanOrEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_CODE <=", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeLike(String value) {
            addCriterion("PAY_CONDITIONS_CODE like", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeNotLike(String value) {
            addCriterion("PAY_CONDITIONS_CODE not like", value, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeIn(List<String> values) {
            addCriterion("PAY_CONDITIONS_CODE in", values, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeNotIn(List<String> values) {
            addCriterion("PAY_CONDITIONS_CODE not in", values, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeBetween(String value1, String value2) {
            addCriterion("PAY_CONDITIONS_CODE between", value1, value2, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsCodeNotBetween(String value1, String value2) {
            addCriterion("PAY_CONDITIONS_CODE not between", value1, value2, "payConditionsCode");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescIsNull() {
            addCriterion("PAY_CONDITIONS_DESC is null");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescIsNotNull() {
            addCriterion("PAY_CONDITIONS_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_DESC =", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescNotEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_DESC <>", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescGreaterThan(String value) {
            addCriterion("PAY_CONDITIONS_DESC >", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescGreaterThanOrEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_DESC >=", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescLessThan(String value) {
            addCriterion("PAY_CONDITIONS_DESC <", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescLessThanOrEqualTo(String value) {
            addCriterion("PAY_CONDITIONS_DESC <=", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescLike(String value) {
            addCriterion("PAY_CONDITIONS_DESC like", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescNotLike(String value) {
            addCriterion("PAY_CONDITIONS_DESC not like", value, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescIn(List<String> values) {
            addCriterion("PAY_CONDITIONS_DESC in", values, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescNotIn(List<String> values) {
            addCriterion("PAY_CONDITIONS_DESC not in", values, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescBetween(String value1, String value2) {
            addCriterion("PAY_CONDITIONS_DESC between", value1, value2, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andPayConditionsDescNotBetween(String value1, String value2) {
            addCriterion("PAY_CONDITIONS_DESC not between", value1, value2, "payConditionsDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenIsNull() {
            addCriterion("ORDER_CURREN is null");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenIsNotNull() {
            addCriterion("ORDER_CURREN is not null");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenEqualTo(String value) {
            addCriterion("ORDER_CURREN =", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenNotEqualTo(String value) {
            addCriterion("ORDER_CURREN <>", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenGreaterThan(String value) {
            addCriterion("ORDER_CURREN >", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenGreaterThanOrEqualTo(String value) {
            addCriterion("ORDER_CURREN >=", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenLessThan(String value) {
            addCriterion("ORDER_CURREN <", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenLessThanOrEqualTo(String value) {
            addCriterion("ORDER_CURREN <=", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenLike(String value) {
            addCriterion("ORDER_CURREN like", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenNotLike(String value) {
            addCriterion("ORDER_CURREN not like", value, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenIn(List<String> values) {
            addCriterion("ORDER_CURREN in", values, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenNotIn(List<String> values) {
            addCriterion("ORDER_CURREN not in", values, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenBetween(String value1, String value2) {
            addCriterion("ORDER_CURREN between", value1, value2, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenNotBetween(String value1, String value2) {
            addCriterion("ORDER_CURREN not between", value1, value2, "orderCurren");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionIsNull() {
            addCriterion("INTERNATIONAL_TRADE_CONDITION is null");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionIsNotNull() {
            addCriterion("INTERNATIONAL_TRADE_CONDITION is not null");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionEqualTo(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION =", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionNotEqualTo(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION <>", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionGreaterThan(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION >", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionGreaterThanOrEqualTo(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION >=", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionLessThan(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION <", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionLessThanOrEqualTo(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION <=", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionLike(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION like", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionNotLike(String value) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION not like", value, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionIn(List<String> values) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION in", values, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionNotIn(List<String> values) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION not in", values, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionBetween(String value1, String value2) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION between", value1, value2, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andInternationalTradeConditionNotBetween(String value1, String value2) {
            addCriterion("INTERNATIONAL_TRADE_CONDITION not between", value1, value2, "internationalTradeCondition");
            return (Criteria) this;
        }

        public Criteria andSalesmanIsNull() {
            addCriterion("SALESMAN is null");
            return (Criteria) this;
        }

        public Criteria andSalesmanIsNotNull() {
            addCriterion("SALESMAN is not null");
            return (Criteria) this;
        }

        public Criteria andSalesmanEqualTo(String value) {
            addCriterion("SALESMAN =", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanNotEqualTo(String value) {
            addCriterion("SALESMAN <>", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanGreaterThan(String value) {
            addCriterion("SALESMAN >", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanGreaterThanOrEqualTo(String value) {
            addCriterion("SALESMAN >=", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanLessThan(String value) {
            addCriterion("SALESMAN <", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanLessThanOrEqualTo(String value) {
            addCriterion("SALESMAN <=", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanLike(String value) {
            addCriterion("SALESMAN like", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanNotLike(String value) {
            addCriterion("SALESMAN not like", value, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanIn(List<String> values) {
            addCriterion("SALESMAN in", values, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanNotIn(List<String> values) {
            addCriterion("SALESMAN not in", values, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanBetween(String value1, String value2) {
            addCriterion("SALESMAN between", value1, value2, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanNotBetween(String value1, String value2) {
            addCriterion("SALESMAN not between", value1, value2, "salesman");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneIsNull() {
            addCriterion("SALESMAN_PHONE is null");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneIsNotNull() {
            addCriterion("SALESMAN_PHONE is not null");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneEqualTo(String value) {
            addCriterion("SALESMAN_PHONE =", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneNotEqualTo(String value) {
            addCriterion("SALESMAN_PHONE <>", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneGreaterThan(String value) {
            addCriterion("SALESMAN_PHONE >", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneGreaterThanOrEqualTo(String value) {
            addCriterion("SALESMAN_PHONE >=", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneLessThan(String value) {
            addCriterion("SALESMAN_PHONE <", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneLessThanOrEqualTo(String value) {
            addCriterion("SALESMAN_PHONE <=", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneLike(String value) {
            addCriterion("SALESMAN_PHONE like", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneNotLike(String value) {
            addCriterion("SALESMAN_PHONE not like", value, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneIn(List<String> values) {
            addCriterion("SALESMAN_PHONE in", values, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneNotIn(List<String> values) {
            addCriterion("SALESMAN_PHONE not in", values, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneBetween(String value1, String value2) {
            addCriterion("SALESMAN_PHONE between", value1, value2, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andSalesmanPhoneNotBetween(String value1, String value2) {
            addCriterion("SALESMAN_PHONE not between", value1, value2, "salesmanPhone");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyIsNull() {
            addCriterion("INVOICE_VERIFY is null");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyIsNotNull() {
            addCriterion("INVOICE_VERIFY is not null");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyEqualTo(String value) {
            addCriterion("INVOICE_VERIFY =", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyNotEqualTo(String value) {
            addCriterion("INVOICE_VERIFY <>", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyGreaterThan(String value) {
            addCriterion("INVOICE_VERIFY >", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyGreaterThanOrEqualTo(String value) {
            addCriterion("INVOICE_VERIFY >=", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyLessThan(String value) {
            addCriterion("INVOICE_VERIFY <", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyLessThanOrEqualTo(String value) {
            addCriterion("INVOICE_VERIFY <=", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyLike(String value) {
            addCriterion("INVOICE_VERIFY like", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyNotLike(String value) {
            addCriterion("INVOICE_VERIFY not like", value, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyIn(List<String> values) {
            addCriterion("INVOICE_VERIFY in", values, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyNotIn(List<String> values) {
            addCriterion("INVOICE_VERIFY not in", values, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyBetween(String value1, String value2) {
            addCriterion("INVOICE_VERIFY between", value1, value2, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andInvoiceVerifyNotBetween(String value1, String value2) {
            addCriterion("INVOICE_VERIFY not between", value1, value2, "invoiceVerify");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderIsNull() {
            addCriterion("AUTOMATIC_PURCHASE_ORDER is null");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderIsNotNull() {
            addCriterion("AUTOMATIC_PURCHASE_ORDER is not null");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderEqualTo(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER =", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderNotEqualTo(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER <>", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderGreaterThan(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER >", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderGreaterThanOrEqualTo(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER >=", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderLessThan(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER <", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderLessThanOrEqualTo(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER <=", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderLike(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER like", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderNotLike(String value) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER not like", value, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderIn(List<String> values) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER in", values, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderNotIn(List<String> values) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER not in", values, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderBetween(String value1, String value2) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER between", value1, value2, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andAutomaticPurchaseOrderNotBetween(String value1, String value2) {
            addCriterion("AUTOMATIC_PURCHASE_ORDER not between", value1, value2, "automaticPurchaseOrder");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupIsNull() {
            addCriterion("PURCHASING_GROUP is null");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupIsNotNull() {
            addCriterion("PURCHASING_GROUP is not null");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupEqualTo(String value) {
            addCriterion("PURCHASING_GROUP =", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotEqualTo(String value) {
            addCriterion("PURCHASING_GROUP <>", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupGreaterThan(String value) {
            addCriterion("PURCHASING_GROUP >", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASING_GROUP >=", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupLessThan(String value) {
            addCriterion("PURCHASING_GROUP <", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupLessThanOrEqualTo(String value) {
            addCriterion("PURCHASING_GROUP <=", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupLike(String value) {
            addCriterion("PURCHASING_GROUP like", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotLike(String value) {
            addCriterion("PURCHASING_GROUP not like", value, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupIn(List<String> values) {
            addCriterion("PURCHASING_GROUP in", values, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotIn(List<String> values) {
            addCriterion("PURCHASING_GROUP not in", values, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupBetween(String value1, String value2) {
            addCriterion("PURCHASING_GROUP between", value1, value2, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPurchasingGroupNotBetween(String value1, String value2) {
            addCriterion("PURCHASING_GROUP not between", value1, value2, "purchasingGroup");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeIsNull() {
            addCriterion("PLANNED_DELIVERY_TIME is null");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeIsNotNull() {
            addCriterion("PLANNED_DELIVERY_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeEqualTo(String value) {
            addCriterion("PLANNED_DELIVERY_TIME =", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeNotEqualTo(String value) {
            addCriterion("PLANNED_DELIVERY_TIME <>", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeGreaterThan(String value) {
            addCriterion("PLANNED_DELIVERY_TIME >", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeGreaterThanOrEqualTo(String value) {
            addCriterion("PLANNED_DELIVERY_TIME >=", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeLessThan(String value) {
            addCriterion("PLANNED_DELIVERY_TIME <", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeLessThanOrEqualTo(String value) {
            addCriterion("PLANNED_DELIVERY_TIME <=", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeLike(String value) {
            addCriterion("PLANNED_DELIVERY_TIME like", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeNotLike(String value) {
            addCriterion("PLANNED_DELIVERY_TIME not like", value, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeIn(List<String> values) {
            addCriterion("PLANNED_DELIVERY_TIME in", values, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeNotIn(List<String> values) {
            addCriterion("PLANNED_DELIVERY_TIME not in", values, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeBetween(String value1, String value2) {
            addCriterion("PLANNED_DELIVERY_TIME between", value1, value2, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andPlannedDeliveryTimeNotBetween(String value1, String value2) {
            addCriterion("PLANNED_DELIVERY_TIME not between", value1, value2, "plannedDeliveryTime");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesIsNull() {
            addCriterion("SUPPLY_PROPERTIES is null");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesIsNotNull() {
            addCriterion("SUPPLY_PROPERTIES is not null");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesEqualTo(String value) {
            addCriterion("SUPPLY_PROPERTIES =", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesNotEqualTo(String value) {
            addCriterion("SUPPLY_PROPERTIES <>", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesGreaterThan(String value) {
            addCriterion("SUPPLY_PROPERTIES >", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesGreaterThanOrEqualTo(String value) {
            addCriterion("SUPPLY_PROPERTIES >=", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesLessThan(String value) {
            addCriterion("SUPPLY_PROPERTIES <", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesLessThanOrEqualTo(String value) {
            addCriterion("SUPPLY_PROPERTIES <=", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesLike(String value) {
            addCriterion("SUPPLY_PROPERTIES like", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesNotLike(String value) {
            addCriterion("SUPPLY_PROPERTIES not like", value, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesIn(List<String> values) {
            addCriterion("SUPPLY_PROPERTIES in", values, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesNotIn(List<String> values) {
            addCriterion("SUPPLY_PROPERTIES not in", values, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesBetween(String value1, String value2) {
            addCriterion("SUPPLY_PROPERTIES between", value1, value2, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andSupplyPropertiesNotBetween(String value1, String value2) {
            addCriterion("SUPPLY_PROPERTIES not between", value1, value2, "supplyProperties");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeIsNull() {
            addCriterion("INDUSTRY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeIsNotNull() {
            addCriterion("INDUSTRY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeEqualTo(String value) {
            addCriterion("INDUSTRY_CODE =", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeNotEqualTo(String value) {
            addCriterion("INDUSTRY_CODE <>", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeGreaterThan(String value) {
            addCriterion("INDUSTRY_CODE >", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeGreaterThanOrEqualTo(String value) {
            addCriterion("INDUSTRY_CODE >=", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeLessThan(String value) {
            addCriterion("INDUSTRY_CODE <", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeLessThanOrEqualTo(String value) {
            addCriterion("INDUSTRY_CODE <=", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeLike(String value) {
            addCriterion("INDUSTRY_CODE like", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeNotLike(String value) {
            addCriterion("INDUSTRY_CODE not like", value, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeIn(List<String> values) {
            addCriterion("INDUSTRY_CODE in", values, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeNotIn(List<String> values) {
            addCriterion("INDUSTRY_CODE not in", values, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeBetween(String value1, String value2) {
            addCriterion("INDUSTRY_CODE between", value1, value2, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryCodeNotBetween(String value1, String value2) {
            addCriterion("INDUSTRY_CODE not between", value1, value2, "industryCode");
            return (Criteria) this;
        }

        public Criteria andIndustryDescIsNull() {
            addCriterion("INDUSTRY_DESC is null");
            return (Criteria) this;
        }

        public Criteria andIndustryDescIsNotNull() {
            addCriterion("INDUSTRY_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andIndustryDescEqualTo(String value) {
            addCriterion("INDUSTRY_DESC =", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescNotEqualTo(String value) {
            addCriterion("INDUSTRY_DESC <>", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescGreaterThan(String value) {
            addCriterion("INDUSTRY_DESC >", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescGreaterThanOrEqualTo(String value) {
            addCriterion("INDUSTRY_DESC >=", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescLessThan(String value) {
            addCriterion("INDUSTRY_DESC <", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescLessThanOrEqualTo(String value) {
            addCriterion("INDUSTRY_DESC <=", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescLike(String value) {
            addCriterion("INDUSTRY_DESC like", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescNotLike(String value) {
            addCriterion("INDUSTRY_DESC not like", value, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescIn(List<String> values) {
            addCriterion("INDUSTRY_DESC in", values, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescNotIn(List<String> values) {
            addCriterion("INDUSTRY_DESC not in", values, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescBetween(String value1, String value2) {
            addCriterion("INDUSTRY_DESC between", value1, value2, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andIndustryDescNotBetween(String value1, String value2) {
            addCriterion("INDUSTRY_DESC not between", value1, value2, "industryDesc");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andBankNameIsNull() {
            addCriterion("BANK_NAME is null");
            return (Criteria) this;
        }

        public Criteria andBankNameIsNotNull() {
            addCriterion("BANK_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andBankNameEqualTo(String value) {
            addCriterion("BANK_NAME =", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotEqualTo(String value) {
            addCriterion("BANK_NAME <>", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameGreaterThan(String value) {
            addCriterion("BANK_NAME >", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameGreaterThanOrEqualTo(String value) {
            addCriterion("BANK_NAME >=", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameLessThan(String value) {
            addCriterion("BANK_NAME <", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameLessThanOrEqualTo(String value) {
            addCriterion("BANK_NAME <=", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameLike(String value) {
            addCriterion("BANK_NAME like", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotLike(String value) {
            addCriterion("BANK_NAME not like", value, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameIn(List<String> values) {
            addCriterion("BANK_NAME in", values, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotIn(List<String> values) {
            addCriterion("BANK_NAME not in", values, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameBetween(String value1, String value2) {
            addCriterion("BANK_NAME between", value1, value2, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankNameNotBetween(String value1, String value2) {
            addCriterion("BANK_NAME not between", value1, value2, "bankName");
            return (Criteria) this;
        }

        public Criteria andBankAddressIsNull() {
            addCriterion("BANK_ADDRESS is null");
            return (Criteria) this;
        }

        public Criteria andBankAddressIsNotNull() {
            addCriterion("BANK_ADDRESS is not null");
            return (Criteria) this;
        }

        public Criteria andBankAddressEqualTo(String value) {
            addCriterion("BANK_ADDRESS =", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotEqualTo(String value) {
            addCriterion("BANK_ADDRESS <>", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressGreaterThan(String value) {
            addCriterion("BANK_ADDRESS >", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressGreaterThanOrEqualTo(String value) {
            addCriterion("BANK_ADDRESS >=", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressLessThan(String value) {
            addCriterion("BANK_ADDRESS <", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressLessThanOrEqualTo(String value) {
            addCriterion("BANK_ADDRESS <=", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressLike(String value) {
            addCriterion("BANK_ADDRESS like", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotLike(String value) {
            addCriterion("BANK_ADDRESS not like", value, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressIn(List<String> values) {
            addCriterion("BANK_ADDRESS in", values, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotIn(List<String> values) {
            addCriterion("BANK_ADDRESS not in", values, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressBetween(String value1, String value2) {
            addCriterion("BANK_ADDRESS between", value1, value2, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAddressNotBetween(String value1, String value2) {
            addCriterion("BANK_ADDRESS not between", value1, value2, "bankAddress");
            return (Criteria) this;
        }

        public Criteria andBankAccountIsNull() {
            addCriterion("BANK_ACCOUNT is null");
            return (Criteria) this;
        }

        public Criteria andBankAccountIsNotNull() {
            addCriterion("BANK_ACCOUNT is not null");
            return (Criteria) this;
        }

        public Criteria andBankAccountEqualTo(String value) {
            addCriterion("BANK_ACCOUNT =", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotEqualTo(String value) {
            addCriterion("BANK_ACCOUNT <>", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountGreaterThan(String value) {
            addCriterion("BANK_ACCOUNT >", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountGreaterThanOrEqualTo(String value) {
            addCriterion("BANK_ACCOUNT >=", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountLessThan(String value) {
            addCriterion("BANK_ACCOUNT <", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountLessThanOrEqualTo(String value) {
            addCriterion("BANK_ACCOUNT <=", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountLike(String value) {
            addCriterion("BANK_ACCOUNT like", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotLike(String value) {
            addCriterion("BANK_ACCOUNT not like", value, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountIn(List<String> values) {
            addCriterion("BANK_ACCOUNT in", values, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotIn(List<String> values) {
            addCriterion("BANK_ACCOUNT not in", values, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountBetween(String value1, String value2) {
            addCriterion("BANK_ACCOUNT between", value1, value2, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andBankAccountNotBetween(String value1, String value2) {
            addCriterion("BANK_ACCOUNT not between", value1, value2, "bankAccount");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonIsNull() {
            addCriterion("CORPORATION_LEGAL_PERSON is null");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonIsNotNull() {
            addCriterion("CORPORATION_LEGAL_PERSON is not null");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonEqualTo(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON =", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonNotEqualTo(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON <>", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonGreaterThan(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON >", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonGreaterThanOrEqualTo(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON >=", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonLessThan(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON <", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonLessThanOrEqualTo(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON <=", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonLike(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON like", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonNotLike(String value) {
            addCriterion("CORPORATION_LEGAL_PERSON not like", value, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonIn(List<String> values) {
            addCriterion("CORPORATION_LEGAL_PERSON in", values, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonNotIn(List<String> values) {
            addCriterion("CORPORATION_LEGAL_PERSON not in", values, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonBetween(String value1, String value2) {
            addCriterion("CORPORATION_LEGAL_PERSON between", value1, value2, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andCorporationLegalPersonNotBetween(String value1, String value2) {
            addCriterion("CORPORATION_LEGAL_PERSON not between", value1, value2, "corporationLegalPerson");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeIsNull() {
            addCriterion("FIRST_COMPANY_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeIsNotNull() {
            addCriterion("FIRST_COMPANY_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE =", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeNotEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE <>", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeGreaterThan(String value) {
            addCriterion("FIRST_COMPANY_TYPE >", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeGreaterThanOrEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE >=", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeLessThan(String value) {
            addCriterion("FIRST_COMPANY_TYPE <", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeLessThanOrEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE <=", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeLike(String value) {
            addCriterion("FIRST_COMPANY_TYPE like", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeNotLike(String value) {
            addCriterion("FIRST_COMPANY_TYPE not like", value, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeIn(List<String> values) {
            addCriterion("FIRST_COMPANY_TYPE in", values, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeNotIn(List<String> values) {
            addCriterion("FIRST_COMPANY_TYPE not in", values, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeBetween(String value1, String value2) {
            addCriterion("FIRST_COMPANY_TYPE between", value1, value2, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeNotBetween(String value1, String value2) {
            addCriterion("FIRST_COMPANY_TYPE not between", value1, value2, "firstCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeIsNull() {
            addCriterion("SECOND_COMPANY_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeIsNotNull() {
            addCriterion("SECOND_COMPANY_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE =", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeNotEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE <>", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeGreaterThan(String value) {
            addCriterion("SECOND_COMPANY_TYPE >", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeGreaterThanOrEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE >=", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeLessThan(String value) {
            addCriterion("SECOND_COMPANY_TYPE <", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeLessThanOrEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE <=", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeLike(String value) {
            addCriterion("SECOND_COMPANY_TYPE like", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeNotLike(String value) {
            addCriterion("SECOND_COMPANY_TYPE not like", value, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeIn(List<String> values) {
            addCriterion("SECOND_COMPANY_TYPE in", values, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeNotIn(List<String> values) {
            addCriterion("SECOND_COMPANY_TYPE not in", values, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeBetween(String value1, String value2) {
            addCriterion("SECOND_COMPANY_TYPE between", value1, value2, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeNotBetween(String value1, String value2) {
            addCriterion("SECOND_COMPANY_TYPE not between", value1, value2, "secondCompanyType");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameIsNull() {
            addCriterion("ENGLISH_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameIsNotNull() {
            addCriterion("ENGLISH_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameEqualTo(String value) {
            addCriterion("ENGLISH_COMPANY_NAME =", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameNotEqualTo(String value) {
            addCriterion("ENGLISH_COMPANY_NAME <>", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameGreaterThan(String value) {
            addCriterion("ENGLISH_COMPANY_NAME >", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("ENGLISH_COMPANY_NAME >=", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameLessThan(String value) {
            addCriterion("ENGLISH_COMPANY_NAME <", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("ENGLISH_COMPANY_NAME <=", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameLike(String value) {
            addCriterion("ENGLISH_COMPANY_NAME like", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameNotLike(String value) {
            addCriterion("ENGLISH_COMPANY_NAME not like", value, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameIn(List<String> values) {
            addCriterion("ENGLISH_COMPANY_NAME in", values, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameNotIn(List<String> values) {
            addCriterion("ENGLISH_COMPANY_NAME not in", values, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameBetween(String value1, String value2) {
            addCriterion("ENGLISH_COMPANY_NAME between", value1, value2, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishCompanyNameNotBetween(String value1, String value2) {
            addCriterion("ENGLISH_COMPANY_NAME not between", value1, value2, "englishCompanyName");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressIsNull() {
            addCriterion("ENGLISH_ADDRESS is null");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressIsNotNull() {
            addCriterion("ENGLISH_ADDRESS is not null");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressEqualTo(String value) {
            addCriterion("ENGLISH_ADDRESS =", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressNotEqualTo(String value) {
            addCriterion("ENGLISH_ADDRESS <>", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressGreaterThan(String value) {
            addCriterion("ENGLISH_ADDRESS >", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressGreaterThanOrEqualTo(String value) {
            addCriterion("ENGLISH_ADDRESS >=", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressLessThan(String value) {
            addCriterion("ENGLISH_ADDRESS <", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressLessThanOrEqualTo(String value) {
            addCriterion("ENGLISH_ADDRESS <=", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressLike(String value) {
            addCriterion("ENGLISH_ADDRESS like", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressNotLike(String value) {
            addCriterion("ENGLISH_ADDRESS not like", value, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressIn(List<String> values) {
            addCriterion("ENGLISH_ADDRESS in", values, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressNotIn(List<String> values) {
            addCriterion("ENGLISH_ADDRESS not in", values, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressBetween(String value1, String value2) {
            addCriterion("ENGLISH_ADDRESS between", value1, value2, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andEnglishAddressNotBetween(String value1, String value2) {
            addCriterion("ENGLISH_ADDRESS not between", value1, value2, "englishAddress");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalIsNull() {
            addCriterion("REGISTERED_CAPITAL is null");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalIsNotNull() {
            addCriterion("REGISTERED_CAPITAL is not null");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalEqualTo(String value) {
            addCriterion("REGISTERED_CAPITAL =", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalNotEqualTo(String value) {
            addCriterion("REGISTERED_CAPITAL <>", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalGreaterThan(String value) {
            addCriterion("REGISTERED_CAPITAL >", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalGreaterThanOrEqualTo(String value) {
            addCriterion("REGISTERED_CAPITAL >=", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalLessThan(String value) {
            addCriterion("REGISTERED_CAPITAL <", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalLessThanOrEqualTo(String value) {
            addCriterion("REGISTERED_CAPITAL <=", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalLike(String value) {
            addCriterion("REGISTERED_CAPITAL like", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalNotLike(String value) {
            addCriterion("REGISTERED_CAPITAL not like", value, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalIn(List<String> values) {
            addCriterion("REGISTERED_CAPITAL in", values, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalNotIn(List<String> values) {
            addCriterion("REGISTERED_CAPITAL not in", values, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalBetween(String value1, String value2) {
            addCriterion("REGISTERED_CAPITAL between", value1, value2, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andRegisteredCapitalNotBetween(String value1, String value2) {
            addCriterion("REGISTERED_CAPITAL not between", value1, value2, "registeredCapital");
            return (Criteria) this;
        }

        public Criteria andActingBrandIsNull() {
            addCriterion("ACTING_BRAND is null");
            return (Criteria) this;
        }

        public Criteria andActingBrandIsNotNull() {
            addCriterion("ACTING_BRAND is not null");
            return (Criteria) this;
        }

        public Criteria andActingBrandEqualTo(String value) {
            addCriterion("ACTING_BRAND =", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandNotEqualTo(String value) {
            addCriterion("ACTING_BRAND <>", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandGreaterThan(String value) {
            addCriterion("ACTING_BRAND >", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandGreaterThanOrEqualTo(String value) {
            addCriterion("ACTING_BRAND >=", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandLessThan(String value) {
            addCriterion("ACTING_BRAND <", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandLessThanOrEqualTo(String value) {
            addCriterion("ACTING_BRAND <=", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandLike(String value) {
            addCriterion("ACTING_BRAND like", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandNotLike(String value) {
            addCriterion("ACTING_BRAND not like", value, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandIn(List<String> values) {
            addCriterion("ACTING_BRAND in", values, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandNotIn(List<String> values) {
            addCriterion("ACTING_BRAND not in", values, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandBetween(String value1, String value2) {
            addCriterion("ACTING_BRAND between", value1, value2, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andActingBrandNotBetween(String value1, String value2) {
            addCriterion("ACTING_BRAND not between", value1, value2, "actingBrand");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeIsNull() {
            addCriterion("COMPANY_ESTABLISHMENT_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeIsNotNull() {
            addCriterion("COMPANY_ESTABLISHMENT_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeEqualTo(Date value) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME =", value, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeNotEqualTo(Date value) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME <>", value, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeGreaterThan(Date value) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME >", value, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME >=", value, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeLessThan(Date value) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME <", value, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeLessThanOrEqualTo(Date value) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME <=", value, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeIn(List<Date> values) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME in", values, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeNotIn(List<Date> values) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME not in", values, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeBetween(Date value1, Date value2) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME between", value1, value2, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andCompanyEstablishmentTimeNotBetween(Date value1, Date value2) {
            addCriterion("COMPANY_ESTABLISHMENT_TIME not between", value1, value2, "companyEstablishmentTime");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipIsNull() {
            addCriterion("WORKPLACE_OWNERSHIP is null");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipIsNotNull() {
            addCriterion("WORKPLACE_OWNERSHIP is not null");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipEqualTo(String value) {
            addCriterion("WORKPLACE_OWNERSHIP =", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipNotEqualTo(String value) {
            addCriterion("WORKPLACE_OWNERSHIP <>", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipGreaterThan(String value) {
            addCriterion("WORKPLACE_OWNERSHIP >", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipGreaterThanOrEqualTo(String value) {
            addCriterion("WORKPLACE_OWNERSHIP >=", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipLessThan(String value) {
            addCriterion("WORKPLACE_OWNERSHIP <", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipLessThanOrEqualTo(String value) {
            addCriterion("WORKPLACE_OWNERSHIP <=", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipLike(String value) {
            addCriterion("WORKPLACE_OWNERSHIP like", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipNotLike(String value) {
            addCriterion("WORKPLACE_OWNERSHIP not like", value, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipIn(List<String> values) {
            addCriterion("WORKPLACE_OWNERSHIP in", values, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipNotIn(List<String> values) {
            addCriterion("WORKPLACE_OWNERSHIP not in", values, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipBetween(String value1, String value2) {
            addCriterion("WORKPLACE_OWNERSHIP between", value1, value2, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andWorkplaceOwnershipNotBetween(String value1, String value2) {
            addCriterion("WORKPLACE_OWNERSHIP not between", value1, value2, "workplaceOwnership");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateIsNull() {
            addCriterion("PLANT_USE_RATE is null");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateIsNotNull() {
            addCriterion("PLANT_USE_RATE is not null");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateEqualTo(String value) {
            addCriterion("PLANT_USE_RATE =", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateNotEqualTo(String value) {
            addCriterion("PLANT_USE_RATE <>", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateGreaterThan(String value) {
            addCriterion("PLANT_USE_RATE >", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateGreaterThanOrEqualTo(String value) {
            addCriterion("PLANT_USE_RATE >=", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateLessThan(String value) {
            addCriterion("PLANT_USE_RATE <", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateLessThanOrEqualTo(String value) {
            addCriterion("PLANT_USE_RATE <=", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateLike(String value) {
            addCriterion("PLANT_USE_RATE like", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateNotLike(String value) {
            addCriterion("PLANT_USE_RATE not like", value, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateIn(List<String> values) {
            addCriterion("PLANT_USE_RATE in", values, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateNotIn(List<String> values) {
            addCriterion("PLANT_USE_RATE not in", values, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateBetween(String value1, String value2) {
            addCriterion("PLANT_USE_RATE between", value1, value2, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andPlantUseRateNotBetween(String value1, String value2) {
            addCriterion("PLANT_USE_RATE not between", value1, value2, "plantUseRate");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleIsNull() {
            addCriterion("PRODUCT_SUPPLY_CYCLE is null");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleIsNotNull() {
            addCriterion("PRODUCT_SUPPLY_CYCLE is not null");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleEqualTo(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE =", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleNotEqualTo(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE <>", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleGreaterThan(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE >", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleGreaterThanOrEqualTo(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE >=", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleLessThan(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE <", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleLessThanOrEqualTo(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE <=", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleLike(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE like", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleNotLike(String value) {
            addCriterion("PRODUCT_SUPPLY_CYCLE not like", value, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleIn(List<String> values) {
            addCriterion("PRODUCT_SUPPLY_CYCLE in", values, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleNotIn(List<String> values) {
            addCriterion("PRODUCT_SUPPLY_CYCLE not in", values, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleBetween(String value1, String value2) {
            addCriterion("PRODUCT_SUPPLY_CYCLE between", value1, value2, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andProductSupplyCycleNotBetween(String value1, String value2) {
            addCriterion("PRODUCT_SUPPLY_CYCLE not between", value1, value2, "productSupplyCycle");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeIsNull() {
            addCriterion("FEEDBACK_TIME is null");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeIsNotNull() {
            addCriterion("FEEDBACK_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeEqualTo(String value) {
            addCriterion("FEEDBACK_TIME =", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeNotEqualTo(String value) {
            addCriterion("FEEDBACK_TIME <>", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeGreaterThan(String value) {
            addCriterion("FEEDBACK_TIME >", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeGreaterThanOrEqualTo(String value) {
            addCriterion("FEEDBACK_TIME >=", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeLessThan(String value) {
            addCriterion("FEEDBACK_TIME <", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeLessThanOrEqualTo(String value) {
            addCriterion("FEEDBACK_TIME <=", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeLike(String value) {
            addCriterion("FEEDBACK_TIME like", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeNotLike(String value) {
            addCriterion("FEEDBACK_TIME not like", value, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeIn(List<String> values) {
            addCriterion("FEEDBACK_TIME in", values, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeNotIn(List<String> values) {
            addCriterion("FEEDBACK_TIME not in", values, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeBetween(String value1, String value2) {
            addCriterion("FEEDBACK_TIME between", value1, value2, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andFeedbackTimeNotBetween(String value1, String value2) {
            addCriterion("FEEDBACK_TIME not between", value1, value2, "feedbackTime");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceIsNull() {
            addCriterion("PPM_PERFORMANCE is null");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceIsNotNull() {
            addCriterion("PPM_PERFORMANCE is not null");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceEqualTo(String value) {
            addCriterion("PPM_PERFORMANCE =", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceNotEqualTo(String value) {
            addCriterion("PPM_PERFORMANCE <>", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceGreaterThan(String value) {
            addCriterion("PPM_PERFORMANCE >", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceGreaterThanOrEqualTo(String value) {
            addCriterion("PPM_PERFORMANCE >=", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceLessThan(String value) {
            addCriterion("PPM_PERFORMANCE <", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceLessThanOrEqualTo(String value) {
            addCriterion("PPM_PERFORMANCE <=", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceLike(String value) {
            addCriterion("PPM_PERFORMANCE like", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceNotLike(String value) {
            addCriterion("PPM_PERFORMANCE not like", value, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceIn(List<String> values) {
            addCriterion("PPM_PERFORMANCE in", values, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceNotIn(List<String> values) {
            addCriterion("PPM_PERFORMANCE not in", values, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceBetween(String value1, String value2) {
            addCriterion("PPM_PERFORMANCE between", value1, value2, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andPpmPerformanceNotBetween(String value1, String value2) {
            addCriterion("PPM_PERFORMANCE not between", value1, value2, "ppmPerformance");
            return (Criteria) this;
        }

        public Criteria andAgentTimeIsNull() {
            addCriterion("AGENT_TIME is null");
            return (Criteria) this;
        }

        public Criteria andAgentTimeIsNotNull() {
            addCriterion("AGENT_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andAgentTimeEqualTo(Date value) {
            addCriterion("AGENT_TIME =", value, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeNotEqualTo(Date value) {
            addCriterion("AGENT_TIME <>", value, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeGreaterThan(Date value) {
            addCriterion("AGENT_TIME >", value, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("AGENT_TIME >=", value, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeLessThan(Date value) {
            addCriterion("AGENT_TIME <", value, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeLessThanOrEqualTo(Date value) {
            addCriterion("AGENT_TIME <=", value, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeIn(List<Date> values) {
            addCriterion("AGENT_TIME in", values, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeNotIn(List<Date> values) {
            addCriterion("AGENT_TIME not in", values, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeBetween(Date value1, Date value2) {
            addCriterion("AGENT_TIME between", value1, value2, "agentTime");
            return (Criteria) this;
        }

        public Criteria andAgentTimeNotBetween(Date value1, Date value2) {
            addCriterion("AGENT_TIME not between", value1, value2, "agentTime");
            return (Criteria) this;
        }

        public Criteria andActingProductsIsNull() {
            addCriterion("ACTING_PRODUCTS is null");
            return (Criteria) this;
        }

        public Criteria andActingProductsIsNotNull() {
            addCriterion("ACTING_PRODUCTS is not null");
            return (Criteria) this;
        }

        public Criteria andActingProductsEqualTo(String value) {
            addCriterion("ACTING_PRODUCTS =", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsNotEqualTo(String value) {
            addCriterion("ACTING_PRODUCTS <>", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsGreaterThan(String value) {
            addCriterion("ACTING_PRODUCTS >", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsGreaterThanOrEqualTo(String value) {
            addCriterion("ACTING_PRODUCTS >=", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsLessThan(String value) {
            addCriterion("ACTING_PRODUCTS <", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsLessThanOrEqualTo(String value) {
            addCriterion("ACTING_PRODUCTS <=", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsLike(String value) {
            addCriterion("ACTING_PRODUCTS like", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsNotLike(String value) {
            addCriterion("ACTING_PRODUCTS not like", value, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsIn(List<String> values) {
            addCriterion("ACTING_PRODUCTS in", values, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsNotIn(List<String> values) {
            addCriterion("ACTING_PRODUCTS not in", values, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsBetween(String value1, String value2) {
            addCriterion("ACTING_PRODUCTS between", value1, value2, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andActingProductsNotBetween(String value1, String value2) {
            addCriterion("ACTING_PRODUCTS not between", value1, value2, "actingProducts");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeIsNull() {
            addCriterion("DELIVERY_MODE is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeIsNotNull() {
            addCriterion("DELIVERY_MODE is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeEqualTo(String value) {
            addCriterion("DELIVERY_MODE =", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeNotEqualTo(String value) {
            addCriterion("DELIVERY_MODE <>", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeGreaterThan(String value) {
            addCriterion("DELIVERY_MODE >", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_MODE >=", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeLessThan(String value) {
            addCriterion("DELIVERY_MODE <", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_MODE <=", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeLike(String value) {
            addCriterion("DELIVERY_MODE like", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeNotLike(String value) {
            addCriterion("DELIVERY_MODE not like", value, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeIn(List<String> values) {
            addCriterion("DELIVERY_MODE in", values, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeNotIn(List<String> values) {
            addCriterion("DELIVERY_MODE not in", values, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeBetween(String value1, String value2) {
            addCriterion("DELIVERY_MODE between", value1, value2, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_MODE not between", value1, value2, "deliveryMode");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceIsNull() {
            addCriterion("IS_FIELD_SERVICE is null");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceIsNotNull() {
            addCriterion("IS_FIELD_SERVICE is not null");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceEqualTo(Integer value) {
            addCriterion("IS_FIELD_SERVICE =", value, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceNotEqualTo(Integer value) {
            addCriterion("IS_FIELD_SERVICE <>", value, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceGreaterThan(Integer value) {
            addCriterion("IS_FIELD_SERVICE >", value, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_FIELD_SERVICE >=", value, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceLessThan(Integer value) {
            addCriterion("IS_FIELD_SERVICE <", value, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceLessThanOrEqualTo(Integer value) {
            addCriterion("IS_FIELD_SERVICE <=", value, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceIn(List<Integer> values) {
            addCriterion("IS_FIELD_SERVICE in", values, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceNotIn(List<Integer> values) {
            addCriterion("IS_FIELD_SERVICE not in", values, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceBetween(Integer value1, Integer value2) {
            addCriterion("IS_FIELD_SERVICE between", value1, value2, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andIsFieldServiceNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_FIELD_SERVICE not between", value1, value2, "isFieldService");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberIsNull() {
            addCriterion("BUSINESS_LICENSE_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberIsNotNull() {
            addCriterion("BUSINESS_LICENSE_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberEqualTo(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER =", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberNotEqualTo(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER <>", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberGreaterThan(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER >", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberGreaterThanOrEqualTo(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER >=", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberLessThan(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER <", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberLessThanOrEqualTo(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER <=", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberLike(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER like", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberNotLike(String value) {
            addCriterion("BUSINESS_LICENSE_NUMBER not like", value, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberIn(List<String> values) {
            addCriterion("BUSINESS_LICENSE_NUMBER in", values, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberNotIn(List<String> values) {
            addCriterion("BUSINESS_LICENSE_NUMBER not in", values, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberBetween(String value1, String value2) {
            addCriterion("BUSINESS_LICENSE_NUMBER between", value1, value2, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andBusinessLicenseNumberNotBetween(String value1, String value2) {
            addCriterion("BUSINESS_LICENSE_NUMBER not between", value1, value2, "businessLicenseNumber");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeIsNull() {
            addCriterion("CAPITAL_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeIsNotNull() {
            addCriterion("CAPITAL_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeEqualTo(String value) {
            addCriterion("CAPITAL_TYPE =", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeNotEqualTo(String value) {
            addCriterion("CAPITAL_TYPE <>", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeGreaterThan(String value) {
            addCriterion("CAPITAL_TYPE >", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeGreaterThanOrEqualTo(String value) {
            addCriterion("CAPITAL_TYPE >=", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeLessThan(String value) {
            addCriterion("CAPITAL_TYPE <", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeLessThanOrEqualTo(String value) {
            addCriterion("CAPITAL_TYPE <=", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeLike(String value) {
            addCriterion("CAPITAL_TYPE like", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeNotLike(String value) {
            addCriterion("CAPITAL_TYPE not like", value, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeIn(List<String> values) {
            addCriterion("CAPITAL_TYPE in", values, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeNotIn(List<String> values) {
            addCriterion("CAPITAL_TYPE not in", values, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeBetween(String value1, String value2) {
            addCriterion("CAPITAL_TYPE between", value1, value2, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCapitalTypeNotBetween(String value1, String value2) {
            addCriterion("CAPITAL_TYPE not between", value1, value2, "capitalType");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationIsNull() {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION is null");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationIsNotNull() {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationEqualTo(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION =", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationNotEqualTo(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION <>", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationGreaterThan(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION >", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION >=", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationLessThan(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION <", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION <=", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationLike(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION like", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationNotLike(String value) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION not like", value, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationIn(List<String> values) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION in", values, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationNotIn(List<String> values) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION not in", values, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationBetween(String value1, String value2) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION between", value1, value2, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andCompanyEnglishAbbreviationNotBetween(String value1, String value2) {
            addCriterion("COMPANY_ENGLISH_ABBREVIATION not between", value1, value2, "companyEnglishAbbreviation");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNull() {
            addCriterion("FINISH_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNotNull() {
            addCriterion("FINISH_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagEqualTo(Integer value) {
            addCriterion("FINISH_FLAG =", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <>", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThan(Integer value) {
            addCriterion("FINISH_FLAG >", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG >=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThan(Integer value) {
            addCriterion("FINISH_FLAG <", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIn(List<Integer> values) {
            addCriterion("FINISH_FLAG in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotIn(List<Integer> values) {
            addCriterion("FINISH_FLAG not in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG not between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainIsNull() {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN is null");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainIsNotNull() {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN is not null");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN =", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainNotEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN <>", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainGreaterThan(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN >", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainGreaterThanOrEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN >=", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainLessThan(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN <", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainLessThanOrEqualTo(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN <=", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainLike(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN like", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainNotLike(String value) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN not like", value, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainIn(List<String> values) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN in", values, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainNotIn(List<String> values) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN not in", values, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainBetween(String value1, String value2) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN between", value1, value2, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andFirstCompanyTypeExplainNotBetween(String value1, String value2) {
            addCriterion("FIRST_COMPANY_TYPE_EXPLAIN not between", value1, value2, "firstCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainIsNull() {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN is null");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainIsNotNull() {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN is not null");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN =", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainNotEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN <>", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainGreaterThan(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN >", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainGreaterThanOrEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN >=", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainLessThan(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN <", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainLessThanOrEqualTo(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN <=", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainLike(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN like", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainNotLike(String value) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN not like", value, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainIn(List<String> values) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN in", values, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainNotIn(List<String> values) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN not in", values, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainBetween(String value1, String value2) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN between", value1, value2, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andSecondCompanyTypeExplainNotBetween(String value1, String value2) {
            addCriterion("SECOND_COMPANY_TYPE_EXPLAIN not between", value1, value2, "secondCompanyTypeExplain");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsIsNull() {
            addCriterion("COMPETITION_PRODUCTS is null");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsIsNotNull() {
            addCriterion("COMPETITION_PRODUCTS is not null");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsEqualTo(String value) {
            addCriterion("COMPETITION_PRODUCTS =", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsNotEqualTo(String value) {
            addCriterion("COMPETITION_PRODUCTS <>", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsGreaterThan(String value) {
            addCriterion("COMPETITION_PRODUCTS >", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsGreaterThanOrEqualTo(String value) {
            addCriterion("COMPETITION_PRODUCTS >=", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsLessThan(String value) {
            addCriterion("COMPETITION_PRODUCTS <", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsLessThanOrEqualTo(String value) {
            addCriterion("COMPETITION_PRODUCTS <=", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsLike(String value) {
            addCriterion("COMPETITION_PRODUCTS like", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsNotLike(String value) {
            addCriterion("COMPETITION_PRODUCTS not like", value, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsIn(List<String> values) {
            addCriterion("COMPETITION_PRODUCTS in", values, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsNotIn(List<String> values) {
            addCriterion("COMPETITION_PRODUCTS not in", values, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsBetween(String value1, String value2) {
            addCriterion("COMPETITION_PRODUCTS between", value1, value2, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andCompetitionProductsNotBetween(String value1, String value2) {
            addCriterion("COMPETITION_PRODUCTS not between", value1, value2, "competitionProducts");
            return (Criteria) this;
        }

        public Criteria andApproveStatusIsNull() {
            addCriterion("APPROVE_STATUS is null");
            return (Criteria) this;
        }

        public Criteria andApproveStatusIsNotNull() {
            addCriterion("APPROVE_STATUS is not null");
            return (Criteria) this;
        }

        public Criteria andApproveStatusEqualTo(Integer value) {
            addCriterion("APPROVE_STATUS =", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusNotEqualTo(Integer value) {
            addCriterion("APPROVE_STATUS <>", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusGreaterThan(Integer value) {
            addCriterion("APPROVE_STATUS >", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusGreaterThanOrEqualTo(Integer value) {
            addCriterion("APPROVE_STATUS >=", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusLessThan(Integer value) {
            addCriterion("APPROVE_STATUS <", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusLessThanOrEqualTo(Integer value) {
            addCriterion("APPROVE_STATUS <=", value, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusIn(List<Integer> values) {
            addCriterion("APPROVE_STATUS in", values, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusNotIn(List<Integer> values) {
            addCriterion("APPROVE_STATUS not in", values, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusBetween(Integer value1, Integer value2) {
            addCriterion("APPROVE_STATUS between", value1, value2, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveStatusNotBetween(Integer value1, Integer value2) {
            addCriterion("APPROVE_STATUS not between", value1, value2, "approveStatus");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameIsNull() {
            addCriterion("APPROVE_USER_NAME is null");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameIsNotNull() {
            addCriterion("APPROVE_USER_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameEqualTo(String value) {
            addCriterion("APPROVE_USER_NAME =", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameNotEqualTo(String value) {
            addCriterion("APPROVE_USER_NAME <>", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameGreaterThan(String value) {
            addCriterion("APPROVE_USER_NAME >", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameGreaterThanOrEqualTo(String value) {
            addCriterion("APPROVE_USER_NAME >=", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameLessThan(String value) {
            addCriterion("APPROVE_USER_NAME <", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameLessThanOrEqualTo(String value) {
            addCriterion("APPROVE_USER_NAME <=", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameLike(String value) {
            addCriterion("APPROVE_USER_NAME like", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameNotLike(String value) {
            addCriterion("APPROVE_USER_NAME not like", value, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameIn(List<String> values) {
            addCriterion("APPROVE_USER_NAME in", values, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameNotIn(List<String> values) {
            addCriterion("APPROVE_USER_NAME not in", values, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameBetween(String value1, String value2) {
            addCriterion("APPROVE_USER_NAME between", value1, value2, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveUserNameNotBetween(String value1, String value2) {
            addCriterion("APPROVE_USER_NAME not between", value1, value2, "approveUserName");
            return (Criteria) this;
        }

        public Criteria andApproveTimeIsNull() {
            addCriterion("APPROVE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andApproveTimeIsNotNull() {
            addCriterion("APPROVE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andApproveTimeEqualTo(Date value) {
            addCriterion("APPROVE_TIME =", value, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeNotEqualTo(Date value) {
            addCriterion("APPROVE_TIME <>", value, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeGreaterThan(Date value) {
            addCriterion("APPROVE_TIME >", value, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("APPROVE_TIME >=", value, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeLessThan(Date value) {
            addCriterion("APPROVE_TIME <", value, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeLessThanOrEqualTo(Date value) {
            addCriterion("APPROVE_TIME <=", value, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeIn(List<Date> values) {
            addCriterion("APPROVE_TIME in", values, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeNotIn(List<Date> values) {
            addCriterion("APPROVE_TIME not in", values, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeBetween(Date value1, Date value2) {
            addCriterion("APPROVE_TIME between", value1, value2, "approveTime");
            return (Criteria) this;
        }

        public Criteria andApproveTimeNotBetween(Date value1, Date value2) {
            addCriterion("APPROVE_TIME not between", value1, value2, "approveTime");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeIsNull() {
            addCriterion("BUSINESS_SCOPE is null");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeIsNotNull() {
            addCriterion("BUSINESS_SCOPE is not null");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeEqualTo(String value) {
            addCriterion("BUSINESS_SCOPE =", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeNotEqualTo(String value) {
            addCriterion("BUSINESS_SCOPE <>", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeGreaterThan(String value) {
            addCriterion("BUSINESS_SCOPE >", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeGreaterThanOrEqualTo(String value) {
            addCriterion("BUSINESS_SCOPE >=", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeLessThan(String value) {
            addCriterion("BUSINESS_SCOPE <", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeLessThanOrEqualTo(String value) {
            addCriterion("BUSINESS_SCOPE <=", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeLike(String value) {
            addCriterion("BUSINESS_SCOPE like", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeNotLike(String value) {
            addCriterion("BUSINESS_SCOPE not like", value, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeIn(List<String> values) {
            addCriterion("BUSINESS_SCOPE in", values, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeNotIn(List<String> values) {
            addCriterion("BUSINESS_SCOPE not in", values, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeBetween(String value1, String value2) {
            addCriterion("BUSINESS_SCOPE between", value1, value2, "businessScope");
            return (Criteria) this;
        }

        public Criteria andBusinessScopeNotBetween(String value1, String value2) {
            addCriterion("BUSINESS_SCOPE not between", value1, value2, "businessScope");
            return (Criteria) this;
        }

        public Criteria andProductionAddressIsNull() {
            addCriterion("PRODUCTION_ADDRESS is null");
            return (Criteria) this;
        }

        public Criteria andProductionAddressIsNotNull() {
            addCriterion("PRODUCTION_ADDRESS is not null");
            return (Criteria) this;
        }

        public Criteria andProductionAddressEqualTo(String value) {
            addCriterion("PRODUCTION_ADDRESS =", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressNotEqualTo(String value) {
            addCriterion("PRODUCTION_ADDRESS <>", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressGreaterThan(String value) {
            addCriterion("PRODUCTION_ADDRESS >", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressGreaterThanOrEqualTo(String value) {
            addCriterion("PRODUCTION_ADDRESS >=", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressLessThan(String value) {
            addCriterion("PRODUCTION_ADDRESS <", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressLessThanOrEqualTo(String value) {
            addCriterion("PRODUCTION_ADDRESS <=", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressLike(String value) {
            addCriterion("PRODUCTION_ADDRESS like", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressNotLike(String value) {
            addCriterion("PRODUCTION_ADDRESS not like", value, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressIn(List<String> values) {
            addCriterion("PRODUCTION_ADDRESS in", values, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressNotIn(List<String> values) {
            addCriterion("PRODUCTION_ADDRESS not in", values, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressBetween(String value1, String value2) {
            addCriterion("PRODUCTION_ADDRESS between", value1, value2, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andProductionAddressNotBetween(String value1, String value2) {
            addCriterion("PRODUCTION_ADDRESS not between", value1, value2, "productionAddress");
            return (Criteria) this;
        }

        public Criteria andLandAreaIsNull() {
            addCriterion("LAND_AREA is null");
            return (Criteria) this;
        }

        public Criteria andLandAreaIsNotNull() {
            addCriterion("LAND_AREA is not null");
            return (Criteria) this;
        }

        public Criteria andLandAreaEqualTo(BigDecimal value) {
            addCriterion("LAND_AREA =", value, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaNotEqualTo(BigDecimal value) {
            addCriterion("LAND_AREA <>", value, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaGreaterThan(BigDecimal value) {
            addCriterion("LAND_AREA >", value, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("LAND_AREA >=", value, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaLessThan(BigDecimal value) {
            addCriterion("LAND_AREA <", value, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaLessThanOrEqualTo(BigDecimal value) {
            addCriterion("LAND_AREA <=", value, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaIn(List<BigDecimal> values) {
            addCriterion("LAND_AREA in", values, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaNotIn(List<BigDecimal> values) {
            addCriterion("LAND_AREA not in", values, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("LAND_AREA between", value1, value2, "landArea");
            return (Criteria) this;
        }

        public Criteria andLandAreaNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("LAND_AREA not between", value1, value2, "landArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaIsNull() {
            addCriterion("TOTAL_BUILDING_AREA is null");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaIsNotNull() {
            addCriterion("TOTAL_BUILDING_AREA is not null");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaEqualTo(BigDecimal value) {
            addCriterion("TOTAL_BUILDING_AREA =", value, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaNotEqualTo(BigDecimal value) {
            addCriterion("TOTAL_BUILDING_AREA <>", value, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaGreaterThan(BigDecimal value) {
            addCriterion("TOTAL_BUILDING_AREA >", value, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_BUILDING_AREA >=", value, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaLessThan(BigDecimal value) {
            addCriterion("TOTAL_BUILDING_AREA <", value, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_BUILDING_AREA <=", value, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaIn(List<BigDecimal> values) {
            addCriterion("TOTAL_BUILDING_AREA in", values, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaNotIn(List<BigDecimal> values) {
            addCriterion("TOTAL_BUILDING_AREA not in", values, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_BUILDING_AREA between", value1, value2, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andTotalBuildingAreaNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_BUILDING_AREA not between", value1, value2, "totalBuildingArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaIsNull() {
            addCriterion("PLANT_AREA is null");
            return (Criteria) this;
        }

        public Criteria andPlantAreaIsNotNull() {
            addCriterion("PLANT_AREA is not null");
            return (Criteria) this;
        }

        public Criteria andPlantAreaEqualTo(BigDecimal value) {
            addCriterion("PLANT_AREA =", value, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaNotEqualTo(BigDecimal value) {
            addCriterion("PLANT_AREA <>", value, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaGreaterThan(BigDecimal value) {
            addCriterion("PLANT_AREA >", value, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("PLANT_AREA >=", value, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaLessThan(BigDecimal value) {
            addCriterion("PLANT_AREA <", value, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaLessThanOrEqualTo(BigDecimal value) {
            addCriterion("PLANT_AREA <=", value, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaIn(List<BigDecimal> values) {
            addCriterion("PLANT_AREA in", values, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaNotIn(List<BigDecimal> values) {
            addCriterion("PLANT_AREA not in", values, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PLANT_AREA between", value1, value2, "plantArea");
            return (Criteria) this;
        }

        public Criteria andPlantAreaNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PLANT_AREA not between", value1, value2, "plantArea");
            return (Criteria) this;
        }

        public Criteria andManagerNumberIsNull() {
            addCriterion("MANAGER_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andManagerNumberIsNotNull() {
            addCriterion("MANAGER_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andManagerNumberEqualTo(Integer value) {
            addCriterion("MANAGER_NUMBER =", value, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberNotEqualTo(Integer value) {
            addCriterion("MANAGER_NUMBER <>", value, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberGreaterThan(Integer value) {
            addCriterion("MANAGER_NUMBER >", value, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberGreaterThanOrEqualTo(Integer value) {
            addCriterion("MANAGER_NUMBER >=", value, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberLessThan(Integer value) {
            addCriterion("MANAGER_NUMBER <", value, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberLessThanOrEqualTo(Integer value) {
            addCriterion("MANAGER_NUMBER <=", value, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberIn(List<Integer> values) {
            addCriterion("MANAGER_NUMBER in", values, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberNotIn(List<Integer> values) {
            addCriterion("MANAGER_NUMBER not in", values, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberBetween(Integer value1, Integer value2) {
            addCriterion("MANAGER_NUMBER between", value1, value2, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andManagerNumberNotBetween(Integer value1, Integer value2) {
            addCriterion("MANAGER_NUMBER not between", value1, value2, "managerNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberIsNull() {
            addCriterion("SALESMAN_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberIsNotNull() {
            addCriterion("SALESMAN_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberEqualTo(Integer value) {
            addCriterion("SALESMAN_NUMBER =", value, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberNotEqualTo(Integer value) {
            addCriterion("SALESMAN_NUMBER <>", value, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberGreaterThan(Integer value) {
            addCriterion("SALESMAN_NUMBER >", value, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberGreaterThanOrEqualTo(Integer value) {
            addCriterion("SALESMAN_NUMBER >=", value, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberLessThan(Integer value) {
            addCriterion("SALESMAN_NUMBER <", value, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberLessThanOrEqualTo(Integer value) {
            addCriterion("SALESMAN_NUMBER <=", value, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberIn(List<Integer> values) {
            addCriterion("SALESMAN_NUMBER in", values, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberNotIn(List<Integer> values) {
            addCriterion("SALESMAN_NUMBER not in", values, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberBetween(Integer value1, Integer value2) {
            addCriterion("SALESMAN_NUMBER between", value1, value2, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andSalesmanNumberNotBetween(Integer value1, Integer value2) {
            addCriterion("SALESMAN_NUMBER not between", value1, value2, "salesmanNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberIsNull() {
            addCriterion("TECHNICIAN_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberIsNotNull() {
            addCriterion("TECHNICIAN_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberEqualTo(Integer value) {
            addCriterion("TECHNICIAN_NUMBER =", value, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberNotEqualTo(Integer value) {
            addCriterion("TECHNICIAN_NUMBER <>", value, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberGreaterThan(Integer value) {
            addCriterion("TECHNICIAN_NUMBER >", value, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberGreaterThanOrEqualTo(Integer value) {
            addCriterion("TECHNICIAN_NUMBER >=", value, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberLessThan(Integer value) {
            addCriterion("TECHNICIAN_NUMBER <", value, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberLessThanOrEqualTo(Integer value) {
            addCriterion("TECHNICIAN_NUMBER <=", value, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberIn(List<Integer> values) {
            addCriterion("TECHNICIAN_NUMBER in", values, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberNotIn(List<Integer> values) {
            addCriterion("TECHNICIAN_NUMBER not in", values, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberBetween(Integer value1, Integer value2) {
            addCriterion("TECHNICIAN_NUMBER between", value1, value2, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andTechnicianNumberNotBetween(Integer value1, Integer value2) {
            addCriterion("TECHNICIAN_NUMBER not between", value1, value2, "technicianNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberIsNull() {
            addCriterion("QUALITY_INSPECTOR_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberIsNotNull() {
            addCriterion("QUALITY_INSPECTOR_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberEqualTo(Integer value) {
            addCriterion("QUALITY_INSPECTOR_NUMBER =", value, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberNotEqualTo(Integer value) {
            addCriterion("QUALITY_INSPECTOR_NUMBER <>", value, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberGreaterThan(Integer value) {
            addCriterion("QUALITY_INSPECTOR_NUMBER >", value, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberGreaterThanOrEqualTo(Integer value) {
            addCriterion("QUALITY_INSPECTOR_NUMBER >=", value, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberLessThan(Integer value) {
            addCriterion("QUALITY_INSPECTOR_NUMBER <", value, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberLessThanOrEqualTo(Integer value) {
            addCriterion("QUALITY_INSPECTOR_NUMBER <=", value, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberIn(List<Integer> values) {
            addCriterion("QUALITY_INSPECTOR_NUMBER in", values, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberNotIn(List<Integer> values) {
            addCriterion("QUALITY_INSPECTOR_NUMBER not in", values, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberBetween(Integer value1, Integer value2) {
            addCriterion("QUALITY_INSPECTOR_NUMBER between", value1, value2, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andQualityInspectorNumberNotBetween(Integer value1, Integer value2) {
            addCriterion("QUALITY_INSPECTOR_NUMBER not between", value1, value2, "qualityInspectorNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberIsNull() {
            addCriterion("WORKER_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberIsNotNull() {
            addCriterion("WORKER_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberEqualTo(Integer value) {
            addCriterion("WORKER_NUMBER =", value, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberNotEqualTo(Integer value) {
            addCriterion("WORKER_NUMBER <>", value, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberGreaterThan(Integer value) {
            addCriterion("WORKER_NUMBER >", value, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberGreaterThanOrEqualTo(Integer value) {
            addCriterion("WORKER_NUMBER >=", value, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberLessThan(Integer value) {
            addCriterion("WORKER_NUMBER <", value, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberLessThanOrEqualTo(Integer value) {
            addCriterion("WORKER_NUMBER <=", value, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberIn(List<Integer> values) {
            addCriterion("WORKER_NUMBER in", values, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberNotIn(List<Integer> values) {
            addCriterion("WORKER_NUMBER not in", values, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberBetween(Integer value1, Integer value2) {
            addCriterion("WORKER_NUMBER between", value1, value2, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andWorkerNumberNotBetween(Integer value1, Integer value2) {
            addCriterion("WORKER_NUMBER not between", value1, value2, "workerNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberIsNull() {
            addCriterion("TOTAL_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andTotalNumberIsNotNull() {
            addCriterion("TOTAL_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andTotalNumberEqualTo(Integer value) {
            addCriterion("TOTAL_NUMBER =", value, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberNotEqualTo(Integer value) {
            addCriterion("TOTAL_NUMBER <>", value, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberGreaterThan(Integer value) {
            addCriterion("TOTAL_NUMBER >", value, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberGreaterThanOrEqualTo(Integer value) {
            addCriterion("TOTAL_NUMBER >=", value, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberLessThan(Integer value) {
            addCriterion("TOTAL_NUMBER <", value, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberLessThanOrEqualTo(Integer value) {
            addCriterion("TOTAL_NUMBER <=", value, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberIn(List<Integer> values) {
            addCriterion("TOTAL_NUMBER in", values, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberNotIn(List<Integer> values) {
            addCriterion("TOTAL_NUMBER not in", values, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberBetween(Integer value1, Integer value2) {
            addCriterion("TOTAL_NUMBER between", value1, value2, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andTotalNumberNotBetween(Integer value1, Integer value2) {
            addCriterion("TOTAL_NUMBER not between", value1, value2, "totalNumber");
            return (Criteria) this;
        }

        public Criteria andProductCapacityIsNull() {
            addCriterion("PRODUCT_CAPACITY is null");
            return (Criteria) this;
        }

        public Criteria andProductCapacityIsNotNull() {
            addCriterion("PRODUCT_CAPACITY is not null");
            return (Criteria) this;
        }

        public Criteria andProductCapacityEqualTo(BigDecimal value) {
            addCriterion("PRODUCT_CAPACITY =", value, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityNotEqualTo(BigDecimal value) {
            addCriterion("PRODUCT_CAPACITY <>", value, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityGreaterThan(BigDecimal value) {
            addCriterion("PRODUCT_CAPACITY >", value, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("PRODUCT_CAPACITY >=", value, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityLessThan(BigDecimal value) {
            addCriterion("PRODUCT_CAPACITY <", value, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("PRODUCT_CAPACITY <=", value, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityIn(List<BigDecimal> values) {
            addCriterion("PRODUCT_CAPACITY in", values, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityNotIn(List<BigDecimal> values) {
            addCriterion("PRODUCT_CAPACITY not in", values, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PRODUCT_CAPACITY between", value1, value2, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andProductCapacityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("PRODUCT_CAPACITY not between", value1, value2, "productCapacity");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeIsNull() {
            addCriterion("CLASSIFICATION_THREE is null");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeIsNotNull() {
            addCriterion("CLASSIFICATION_THREE is not null");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeEqualTo(String value) {
            addCriterion("CLASSIFICATION_THREE =", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeNotEqualTo(String value) {
            addCriterion("CLASSIFICATION_THREE <>", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeGreaterThan(String value) {
            addCriterion("CLASSIFICATION_THREE >", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeGreaterThanOrEqualTo(String value) {
            addCriterion("CLASSIFICATION_THREE >=", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeLessThan(String value) {
            addCriterion("CLASSIFICATION_THREE <", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeLessThanOrEqualTo(String value) {
            addCriterion("CLASSIFICATION_THREE <=", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeLike(String value) {
            addCriterion("CLASSIFICATION_THREE like", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeNotLike(String value) {
            addCriterion("CLASSIFICATION_THREE not like", value, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeIn(List<String> values) {
            addCriterion("CLASSIFICATION_THREE in", values, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeNotIn(List<String> values) {
            addCriterion("CLASSIFICATION_THREE not in", values, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeBetween(String value1, String value2) {
            addCriterion("CLASSIFICATION_THREE between", value1, value2, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andClassificationThreeNotBetween(String value1, String value2) {
            addCriterion("CLASSIFICATION_THREE not between", value1, value2, "classificationThree");
            return (Criteria) this;
        }

        public Criteria andGradeIsNull() {
            addCriterion("GRADE is null");
            return (Criteria) this;
        }

        public Criteria andGradeIsNotNull() {
            addCriterion("GRADE is not null");
            return (Criteria) this;
        }

        public Criteria andGradeEqualTo(String value) {
            addCriterion("GRADE =", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeNotEqualTo(String value) {
            addCriterion("GRADE <>", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeGreaterThan(String value) {
            addCriterion("GRADE >", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeGreaterThanOrEqualTo(String value) {
            addCriterion("GRADE >=", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeLessThan(String value) {
            addCriterion("GRADE <", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeLessThanOrEqualTo(String value) {
            addCriterion("GRADE <=", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeLike(String value) {
            addCriterion("GRADE like", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeNotLike(String value) {
            addCriterion("GRADE not like", value, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeIn(List<String> values) {
            addCriterion("GRADE in", values, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeNotIn(List<String> values) {
            addCriterion("GRADE not in", values, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeBetween(String value1, String value2) {
            addCriterion("GRADE between", value1, value2, "grade");
            return (Criteria) this;
        }

        public Criteria andGradeNotBetween(String value1, String value2) {
            addCriterion("GRADE not between", value1, value2, "grade");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityIsNull() {
            addCriterion("MONTHLY_CAPACITY is null");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityIsNotNull() {
            addCriterion("MONTHLY_CAPACITY is not null");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityEqualTo(BigDecimal value) {
            addCriterion("MONTHLY_CAPACITY =", value, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityNotEqualTo(BigDecimal value) {
            addCriterion("MONTHLY_CAPACITY <>", value, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityGreaterThan(BigDecimal value) {
            addCriterion("MONTHLY_CAPACITY >", value, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("MONTHLY_CAPACITY >=", value, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityLessThan(BigDecimal value) {
            addCriterion("MONTHLY_CAPACITY <", value, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityLessThanOrEqualTo(BigDecimal value) {
            addCriterion("MONTHLY_CAPACITY <=", value, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityIn(List<BigDecimal> values) {
            addCriterion("MONTHLY_CAPACITY in", values, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityNotIn(List<BigDecimal> values) {
            addCriterion("MONTHLY_CAPACITY not in", values, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("MONTHLY_CAPACITY between", value1, value2, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andMonthlyCapacityNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("MONTHLY_CAPACITY not between", value1, value2, "monthlyCapacity");
            return (Criteria) this;
        }

        public Criteria andTaxRateIsNull() {
            addCriterion("TAX_RATE is null");
            return (Criteria) this;
        }

        public Criteria andTaxRateIsNotNull() {
            addCriterion("TAX_RATE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxRateEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE =", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE <>", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateGreaterThan(BigDecimal value) {
            addCriterion("TAX_RATE >", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE >=", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateLessThan(BigDecimal value) {
            addCriterion("TAX_RATE <", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TAX_RATE <=", value, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateIn(List<BigDecimal> values) {
            addCriterion("TAX_RATE in", values, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotIn(List<BigDecimal> values) {
            addCriterion("TAX_RATE not in", values, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_RATE between", value1, value2, "taxRate");
            return (Criteria) this;
        }

        public Criteria andTaxRateNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TAX_RATE not between", value1, value2, "taxRate");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveIsNull() {
            addCriterion("COMPANY_RETRIEVE is null");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveIsNotNull() {
            addCriterion("COMPANY_RETRIEVE is not null");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveEqualTo(String value) {
            addCriterion("COMPANY_RETRIEVE =", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveNotEqualTo(String value) {
            addCriterion("COMPANY_RETRIEVE <>", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveGreaterThan(String value) {
            addCriterion("COMPANY_RETRIEVE >", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveGreaterThanOrEqualTo(String value) {
            addCriterion("COMPANY_RETRIEVE >=", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveLessThan(String value) {
            addCriterion("COMPANY_RETRIEVE <", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveLessThanOrEqualTo(String value) {
            addCriterion("COMPANY_RETRIEVE <=", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveLike(String value) {
            addCriterion("COMPANY_RETRIEVE like", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveNotLike(String value) {
            addCriterion("COMPANY_RETRIEVE not like", value, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveIn(List<String> values) {
            addCriterion("COMPANY_RETRIEVE in", values, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveNotIn(List<String> values) {
            addCriterion("COMPANY_RETRIEVE not in", values, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveBetween(String value1, String value2) {
            addCriterion("COMPANY_RETRIEVE between", value1, value2, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andCompanyRetrieveNotBetween(String value1, String value2) {
            addCriterion("COMPANY_RETRIEVE not between", value1, value2, "companyRetrieve");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNull() {
            addCriterion("TAX_CODE is null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNotNull() {
            addCriterion("TAX_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeEqualTo(String value) {
            addCriterion("TAX_CODE =", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotEqualTo(String value) {
            addCriterion("TAX_CODE <>", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThan(String value) {
            addCriterion("TAX_CODE >", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThanOrEqualTo(String value) {
            addCriterion("TAX_CODE >=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThan(String value) {
            addCriterion("TAX_CODE <", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThanOrEqualTo(String value) {
            addCriterion("TAX_CODE <=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLike(String value) {
            addCriterion("TAX_CODE like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotLike(String value) {
            addCriterion("TAX_CODE not like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIn(List<String> values) {
            addCriterion("TAX_CODE in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotIn(List<String> values) {
            addCriterion("TAX_CODE not in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeBetween(String value1, String value2) {
            addCriterion("TAX_CODE between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotBetween(String value1, String value2) {
            addCriterion("TAX_CODE not between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessIsNull() {
            addCriterion("OUTSOURCING_PROCESS is null");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessIsNotNull() {
            addCriterion("OUTSOURCING_PROCESS is not null");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessEqualTo(String value) {
            addCriterion("OUTSOURCING_PROCESS =", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessNotEqualTo(String value) {
            addCriterion("OUTSOURCING_PROCESS <>", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessGreaterThan(String value) {
            addCriterion("OUTSOURCING_PROCESS >", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessGreaterThanOrEqualTo(String value) {
            addCriterion("OUTSOURCING_PROCESS >=", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessLessThan(String value) {
            addCriterion("OUTSOURCING_PROCESS <", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessLessThanOrEqualTo(String value) {
            addCriterion("OUTSOURCING_PROCESS <=", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessLike(String value) {
            addCriterion("OUTSOURCING_PROCESS like", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessNotLike(String value) {
            addCriterion("OUTSOURCING_PROCESS not like", value, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessIn(List<String> values) {
            addCriterion("OUTSOURCING_PROCESS in", values, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessNotIn(List<String> values) {
            addCriterion("OUTSOURCING_PROCESS not in", values, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessBetween(String value1, String value2) {
            addCriterion("OUTSOURCING_PROCESS between", value1, value2, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andOutsourcingProcessNotBetween(String value1, String value2) {
            addCriterion("OUTSOURCING_PROCESS not between", value1, value2, "outsourcingProcess");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberIsNull() {
            addCriterion("COUPLET_NUMBER is null");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberIsNotNull() {
            addCriterion("COUPLET_NUMBER is not null");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberEqualTo(String value) {
            addCriterion("COUPLET_NUMBER =", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberNotEqualTo(String value) {
            addCriterion("COUPLET_NUMBER <>", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberGreaterThan(String value) {
            addCriterion("COUPLET_NUMBER >", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberGreaterThanOrEqualTo(String value) {
            addCriterion("COUPLET_NUMBER >=", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberLessThan(String value) {
            addCriterion("COUPLET_NUMBER <", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberLessThanOrEqualTo(String value) {
            addCriterion("COUPLET_NUMBER <=", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberLike(String value) {
            addCriterion("COUPLET_NUMBER like", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberNotLike(String value) {
            addCriterion("COUPLET_NUMBER not like", value, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberIn(List<String> values) {
            addCriterion("COUPLET_NUMBER in", values, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberNotIn(List<String> values) {
            addCriterion("COUPLET_NUMBER not in", values, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberBetween(String value1, String value2) {
            addCriterion("COUPLET_NUMBER between", value1, value2, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andCoupletNumberNotBetween(String value1, String value2) {
            addCriterion("COUPLET_NUMBER not between", value1, value2, "coupletNumber");
            return (Criteria) this;
        }

        public Criteria andAwardSituationIsNull() {
            addCriterion("AWARD_SITUATION is null");
            return (Criteria) this;
        }

        public Criteria andAwardSituationIsNotNull() {
            addCriterion("AWARD_SITUATION is not null");
            return (Criteria) this;
        }

        public Criteria andAwardSituationEqualTo(String value) {
            addCriterion("AWARD_SITUATION =", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationNotEqualTo(String value) {
            addCriterion("AWARD_SITUATION <>", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationGreaterThan(String value) {
            addCriterion("AWARD_SITUATION >", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationGreaterThanOrEqualTo(String value) {
            addCriterion("AWARD_SITUATION >=", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationLessThan(String value) {
            addCriterion("AWARD_SITUATION <", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationLessThanOrEqualTo(String value) {
            addCriterion("AWARD_SITUATION <=", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationLike(String value) {
            addCriterion("AWARD_SITUATION like", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationNotLike(String value) {
            addCriterion("AWARD_SITUATION not like", value, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationIn(List<String> values) {
            addCriterion("AWARD_SITUATION in", values, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationNotIn(List<String> values) {
            addCriterion("AWARD_SITUATION not in", values, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationBetween(String value1, String value2) {
            addCriterion("AWARD_SITUATION between", value1, value2, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andAwardSituationNotBetween(String value1, String value2) {
            addCriterion("AWARD_SITUATION not between", value1, value2, "awardSituation");
            return (Criteria) this;
        }

        public Criteria andProductTypeIsNull() {
            addCriterion("PRODUCT_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andProductTypeIsNotNull() {
            addCriterion("PRODUCT_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andProductTypeEqualTo(String value) {
            addCriterion("PRODUCT_TYPE =", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeNotEqualTo(String value) {
            addCriterion("PRODUCT_TYPE <>", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeGreaterThan(String value) {
            addCriterion("PRODUCT_TYPE >", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeGreaterThanOrEqualTo(String value) {
            addCriterion("PRODUCT_TYPE >=", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeLessThan(String value) {
            addCriterion("PRODUCT_TYPE <", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeLessThanOrEqualTo(String value) {
            addCriterion("PRODUCT_TYPE <=", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeLike(String value) {
            addCriterion("PRODUCT_TYPE like", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeNotLike(String value) {
            addCriterion("PRODUCT_TYPE not like", value, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeIn(List<String> values) {
            addCriterion("PRODUCT_TYPE in", values, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeNotIn(List<String> values) {
            addCriterion("PRODUCT_TYPE not in", values, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeBetween(String value1, String value2) {
            addCriterion("PRODUCT_TYPE between", value1, value2, "productType");
            return (Criteria) this;
        }

        public Criteria andProductTypeNotBetween(String value1, String value2) {
            addCriterion("PRODUCT_TYPE not between", value1, value2, "productType");
            return (Criteria) this;
        }

        public Criteria andCategoryIdIsNull() {
            addCriterion("CATEGORY_ID is null");
            return (Criteria) this;
        }

        public Criteria andCategoryIdIsNotNull() {
            addCriterion("CATEGORY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andCategoryIdEqualTo(String value) {
            addCriterion("CATEGORY_ID =", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdNotEqualTo(String value) {
            addCriterion("CATEGORY_ID <>", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdGreaterThan(String value) {
            addCriterion("CATEGORY_ID >", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdGreaterThanOrEqualTo(String value) {
            addCriterion("CATEGORY_ID >=", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdLessThan(String value) {
            addCriterion("CATEGORY_ID <", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdLessThanOrEqualTo(String value) {
            addCriterion("CATEGORY_ID <=", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdLike(String value) {
            addCriterion("CATEGORY_ID like", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdNotLike(String value) {
            addCriterion("CATEGORY_ID not like", value, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdIn(List<String> values) {
            addCriterion("CATEGORY_ID in", values, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdNotIn(List<String> values) {
            addCriterion("CATEGORY_ID not in", values, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdBetween(String value1, String value2) {
            addCriterion("CATEGORY_ID between", value1, value2, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryIdNotBetween(String value1, String value2) {
            addCriterion("CATEGORY_ID not between", value1, value2, "categoryId");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeIsNull() {
            addCriterion("CATEGORY_CODE is null");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeIsNotNull() {
            addCriterion("CATEGORY_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeEqualTo(String value) {
            addCriterion("CATEGORY_CODE =", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeNotEqualTo(String value) {
            addCriterion("CATEGORY_CODE <>", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeGreaterThan(String value) {
            addCriterion("CATEGORY_CODE >", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeGreaterThanOrEqualTo(String value) {
            addCriterion("CATEGORY_CODE >=", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeLessThan(String value) {
            addCriterion("CATEGORY_CODE <", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeLessThanOrEqualTo(String value) {
            addCriterion("CATEGORY_CODE <=", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeLike(String value) {
            addCriterion("CATEGORY_CODE like", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeNotLike(String value) {
            addCriterion("CATEGORY_CODE not like", value, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeIn(List<String> values) {
            addCriterion("CATEGORY_CODE in", values, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeNotIn(List<String> values) {
            addCriterion("CATEGORY_CODE not in", values, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeBetween(String value1, String value2) {
            addCriterion("CATEGORY_CODE between", value1, value2, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryCodeNotBetween(String value1, String value2) {
            addCriterion("CATEGORY_CODE not between", value1, value2, "categoryCode");
            return (Criteria) this;
        }

        public Criteria andCategoryNameIsNull() {
            addCriterion("CATEGORY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andCategoryNameIsNotNull() {
            addCriterion("CATEGORY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andCategoryNameEqualTo(String value) {
            addCriterion("CATEGORY_NAME =", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameNotEqualTo(String value) {
            addCriterion("CATEGORY_NAME <>", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameGreaterThan(String value) {
            addCriterion("CATEGORY_NAME >", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameGreaterThanOrEqualTo(String value) {
            addCriterion("CATEGORY_NAME >=", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameLessThan(String value) {
            addCriterion("CATEGORY_NAME <", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameLessThanOrEqualTo(String value) {
            addCriterion("CATEGORY_NAME <=", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameLike(String value) {
            addCriterion("CATEGORY_NAME like", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameNotLike(String value) {
            addCriterion("CATEGORY_NAME not like", value, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameIn(List<String> values) {
            addCriterion("CATEGORY_NAME in", values, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameNotIn(List<String> values) {
            addCriterion("CATEGORY_NAME not in", values, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameBetween(String value1, String value2) {
            addCriterion("CATEGORY_NAME between", value1, value2, "categoryName");
            return (Criteria) this;
        }

        public Criteria andCategoryNameNotBetween(String value1, String value2) {
            addCriterion("CATEGORY_NAME not between", value1, value2, "categoryName");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleIsNull() {
            addCriterion("PURCHASE_CYCLE is null");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleIsNotNull() {
            addCriterion("PURCHASE_CYCLE is not null");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleEqualTo(String value) {
            addCriterion("PURCHASE_CYCLE =", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleNotEqualTo(String value) {
            addCriterion("PURCHASE_CYCLE <>", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleGreaterThan(String value) {
            addCriterion("PURCHASE_CYCLE >", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleGreaterThanOrEqualTo(String value) {
            addCriterion("PURCHASE_CYCLE >=", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleLessThan(String value) {
            addCriterion("PURCHASE_CYCLE <", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleLessThanOrEqualTo(String value) {
            addCriterion("PURCHASE_CYCLE <=", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleLike(String value) {
            addCriterion("PURCHASE_CYCLE like", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleNotLike(String value) {
            addCriterion("PURCHASE_CYCLE not like", value, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleIn(List<String> values) {
            addCriterion("PURCHASE_CYCLE in", values, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleNotIn(List<String> values) {
            addCriterion("PURCHASE_CYCLE not in", values, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleBetween(String value1, String value2) {
            addCriterion("PURCHASE_CYCLE between", value1, value2, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andPurchaseCycleNotBetween(String value1, String value2) {
            addCriterion("PURCHASE_CYCLE not between", value1, value2, "purchaseCycle");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionIsNull() {
            addCriterion("CAR_BUSINESS_PROPORTION is null");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionIsNotNull() {
            addCriterion("CAR_BUSINESS_PROPORTION is not null");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionEqualTo(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION =", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionNotEqualTo(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION <>", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionGreaterThan(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION >", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionGreaterThanOrEqualTo(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION >=", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionLessThan(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION <", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionLessThanOrEqualTo(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION <=", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionLike(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION like", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionNotLike(String value) {
            addCriterion("CAR_BUSINESS_PROPORTION not like", value, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionIn(List<String> values) {
            addCriterion("CAR_BUSINESS_PROPORTION in", values, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionNotIn(List<String> values) {
            addCriterion("CAR_BUSINESS_PROPORTION not in", values, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionBetween(String value1, String value2) {
            addCriterion("CAR_BUSINESS_PROPORTION between", value1, value2, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andCarBusinessProportionNotBetween(String value1, String value2) {
            addCriterion("CAR_BUSINESS_PROPORTION not between", value1, value2, "carBusinessProportion");
            return (Criteria) this;
        }

        public Criteria andTransportTypeIsNull() {
            addCriterion("TRANSPORT_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andTransportTypeIsNotNull() {
            addCriterion("TRANSPORT_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andTransportTypeEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE =", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeNotEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE <>", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeGreaterThan(String value) {
            addCriterion("TRANSPORT_TYPE >", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeGreaterThanOrEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE >=", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeLessThan(String value) {
            addCriterion("TRANSPORT_TYPE <", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeLessThanOrEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE <=", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeLike(String value) {
            addCriterion("TRANSPORT_TYPE like", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeNotLike(String value) {
            addCriterion("TRANSPORT_TYPE not like", value, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeIn(List<String> values) {
            addCriterion("TRANSPORT_TYPE in", values, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeNotIn(List<String> values) {
            addCriterion("TRANSPORT_TYPE not in", values, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeBetween(String value1, String value2) {
            addCriterion("TRANSPORT_TYPE between", value1, value2, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportTypeNotBetween(String value1, String value2) {
            addCriterion("TRANSPORT_TYPE not between", value1, value2, "transportType");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionIsNull() {
            addCriterion("TRANSPORT_PRO_PROPORTION is null");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionIsNotNull() {
            addCriterion("TRANSPORT_PRO_PROPORTION is not null");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionEqualTo(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION =", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionNotEqualTo(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION <>", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionGreaterThan(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION >", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionGreaterThanOrEqualTo(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION >=", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionLessThan(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION <", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionLessThanOrEqualTo(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION <=", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionLike(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION like", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionNotLike(String value) {
            addCriterion("TRANSPORT_PRO_PROPORTION not like", value, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionIn(List<String> values) {
            addCriterion("TRANSPORT_PRO_PROPORTION in", values, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionNotIn(List<String> values) {
            addCriterion("TRANSPORT_PRO_PROPORTION not in", values, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionBetween(String value1, String value2) {
            addCriterion("TRANSPORT_PRO_PROPORTION between", value1, value2, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andTransportProProportionNotBetween(String value1, String value2) {
            addCriterion("TRANSPORT_PRO_PROPORTION not between", value1, value2, "transportProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionIsNull() {
            addCriterion("PACKING_PRO_PROPORTION is null");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionIsNotNull() {
            addCriterion("PACKING_PRO_PROPORTION is not null");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionEqualTo(String value) {
            addCriterion("PACKING_PRO_PROPORTION =", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionNotEqualTo(String value) {
            addCriterion("PACKING_PRO_PROPORTION <>", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionGreaterThan(String value) {
            addCriterion("PACKING_PRO_PROPORTION >", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionGreaterThanOrEqualTo(String value) {
            addCriterion("PACKING_PRO_PROPORTION >=", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionLessThan(String value) {
            addCriterion("PACKING_PRO_PROPORTION <", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionLessThanOrEqualTo(String value) {
            addCriterion("PACKING_PRO_PROPORTION <=", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionLike(String value) {
            addCriterion("PACKING_PRO_PROPORTION like", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionNotLike(String value) {
            addCriterion("PACKING_PRO_PROPORTION not like", value, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionIn(List<String> values) {
            addCriterion("PACKING_PRO_PROPORTION in", values, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionNotIn(List<String> values) {
            addCriterion("PACKING_PRO_PROPORTION not in", values, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionBetween(String value1, String value2) {
            addCriterion("PACKING_PRO_PROPORTION between", value1, value2, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPackingProProportionNotBetween(String value1, String value2) {
            addCriterion("PACKING_PRO_PROPORTION not between", value1, value2, "packingProProportion");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodIsNull() {
            addCriterion("PAYMENT_PERIOD is null");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodIsNotNull() {
            addCriterion("PAYMENT_PERIOD is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD =", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodNotEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD <>", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodGreaterThan(String value) {
            addCriterion("PAYMENT_PERIOD >", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodGreaterThanOrEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD >=", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodLessThan(String value) {
            addCriterion("PAYMENT_PERIOD <", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodLessThanOrEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD <=", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodLike(String value) {
            addCriterion("PAYMENT_PERIOD like", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodNotLike(String value) {
            addCriterion("PAYMENT_PERIOD not like", value, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodIn(List<String> values) {
            addCriterion("PAYMENT_PERIOD in", values, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodNotIn(List<String> values) {
            addCriterion("PAYMENT_PERIOD not in", values, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodBetween(String value1, String value2) {
            addCriterion("PAYMENT_PERIOD between", value1, value2, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodNotBetween(String value1, String value2) {
            addCriterion("PAYMENT_PERIOD not between", value1, value2, "paymentPeriod");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescIsNull() {
            addCriterion("DELIVERY_MODE_DESC is null");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescIsNotNull() {
            addCriterion("DELIVERY_MODE_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescEqualTo(String value) {
            addCriterion("DELIVERY_MODE_DESC =", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescNotEqualTo(String value) {
            addCriterion("DELIVERY_MODE_DESC <>", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescGreaterThan(String value) {
            addCriterion("DELIVERY_MODE_DESC >", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescGreaterThanOrEqualTo(String value) {
            addCriterion("DELIVERY_MODE_DESC >=", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescLessThan(String value) {
            addCriterion("DELIVERY_MODE_DESC <", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescLessThanOrEqualTo(String value) {
            addCriterion("DELIVERY_MODE_DESC <=", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescLike(String value) {
            addCriterion("DELIVERY_MODE_DESC like", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescNotLike(String value) {
            addCriterion("DELIVERY_MODE_DESC not like", value, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescIn(List<String> values) {
            addCriterion("DELIVERY_MODE_DESC in", values, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescNotIn(List<String> values) {
            addCriterion("DELIVERY_MODE_DESC not in", values, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescBetween(String value1, String value2) {
            addCriterion("DELIVERY_MODE_DESC between", value1, value2, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andDeliveryModeDescNotBetween(String value1, String value2) {
            addCriterion("DELIVERY_MODE_DESC not between", value1, value2, "deliveryModeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescIsNull() {
            addCriterion("TRANSPORT_TYPE_DESC is null");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescIsNotNull() {
            addCriterion("TRANSPORT_TYPE_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE_DESC =", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescNotEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE_DESC <>", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescGreaterThan(String value) {
            addCriterion("TRANSPORT_TYPE_DESC >", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescGreaterThanOrEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE_DESC >=", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescLessThan(String value) {
            addCriterion("TRANSPORT_TYPE_DESC <", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescLessThanOrEqualTo(String value) {
            addCriterion("TRANSPORT_TYPE_DESC <=", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescLike(String value) {
            addCriterion("TRANSPORT_TYPE_DESC like", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescNotLike(String value) {
            addCriterion("TRANSPORT_TYPE_DESC not like", value, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescIn(List<String> values) {
            addCriterion("TRANSPORT_TYPE_DESC in", values, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescNotIn(List<String> values) {
            addCriterion("TRANSPORT_TYPE_DESC not in", values, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescBetween(String value1, String value2) {
            addCriterion("TRANSPORT_TYPE_DESC between", value1, value2, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andTransportTypeDescNotBetween(String value1, String value2) {
            addCriterion("TRANSPORT_TYPE_DESC not between", value1, value2, "transportTypeDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescIsNull() {
            addCriterion("ORDER_CURREN_DESC is null");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescIsNotNull() {
            addCriterion("ORDER_CURREN_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescEqualTo(String value) {
            addCriterion("ORDER_CURREN_DESC =", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescNotEqualTo(String value) {
            addCriterion("ORDER_CURREN_DESC <>", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescGreaterThan(String value) {
            addCriterion("ORDER_CURREN_DESC >", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescGreaterThanOrEqualTo(String value) {
            addCriterion("ORDER_CURREN_DESC >=", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescLessThan(String value) {
            addCriterion("ORDER_CURREN_DESC <", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescLessThanOrEqualTo(String value) {
            addCriterion("ORDER_CURREN_DESC <=", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescLike(String value) {
            addCriterion("ORDER_CURREN_DESC like", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescNotLike(String value) {
            addCriterion("ORDER_CURREN_DESC not like", value, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescIn(List<String> values) {
            addCriterion("ORDER_CURREN_DESC in", values, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescNotIn(List<String> values) {
            addCriterion("ORDER_CURREN_DESC not in", values, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescBetween(String value1, String value2) {
            addCriterion("ORDER_CURREN_DESC between", value1, value2, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andOrderCurrenDescNotBetween(String value1, String value2) {
            addCriterion("ORDER_CURREN_DESC not between", value1, value2, "orderCurrenDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescIsNull() {
            addCriterion("PAYMENT_PERIOD_DESC is null");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescIsNotNull() {
            addCriterion("PAYMENT_PERIOD_DESC is not null");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD_DESC =", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescNotEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD_DESC <>", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescGreaterThan(String value) {
            addCriterion("PAYMENT_PERIOD_DESC >", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescGreaterThanOrEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD_DESC >=", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescLessThan(String value) {
            addCriterion("PAYMENT_PERIOD_DESC <", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescLessThanOrEqualTo(String value) {
            addCriterion("PAYMENT_PERIOD_DESC <=", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescLike(String value) {
            addCriterion("PAYMENT_PERIOD_DESC like", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescNotLike(String value) {
            addCriterion("PAYMENT_PERIOD_DESC not like", value, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescIn(List<String> values) {
            addCriterion("PAYMENT_PERIOD_DESC in", values, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescNotIn(List<String> values) {
            addCriterion("PAYMENT_PERIOD_DESC not in", values, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescBetween(String value1, String value2) {
            addCriterion("PAYMENT_PERIOD_DESC between", value1, value2, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andPaymentPeriodDescNotBetween(String value1, String value2) {
            addCriterion("PAYMENT_PERIOD_DESC not between", value1, value2, "paymentPeriodDesc");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryIsNull() {
            addCriterion("SERVICE_CATEGORY is null");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryIsNotNull() {
            addCriterion("SERVICE_CATEGORY is not null");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryEqualTo(String value) {
            addCriterion("SERVICE_CATEGORY =", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryNotEqualTo(String value) {
            addCriterion("SERVICE_CATEGORY <>", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryGreaterThan(String value) {
            addCriterion("SERVICE_CATEGORY >", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryGreaterThanOrEqualTo(String value) {
            addCriterion("SERVICE_CATEGORY >=", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryLessThan(String value) {
            addCriterion("SERVICE_CATEGORY <", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryLessThanOrEqualTo(String value) {
            addCriterion("SERVICE_CATEGORY <=", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryLike(String value) {
            addCriterion("SERVICE_CATEGORY like", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryNotLike(String value) {
            addCriterion("SERVICE_CATEGORY not like", value, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryIn(List<String> values) {
            addCriterion("SERVICE_CATEGORY in", values, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryNotIn(List<String> values) {
            addCriterion("SERVICE_CATEGORY not in", values, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryBetween(String value1, String value2) {
            addCriterion("SERVICE_CATEGORY between", value1, value2, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andServiceCategoryNotBetween(String value1, String value2) {
            addCriterion("SERVICE_CATEGORY not between", value1, value2, "serviceCategory");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdIsNull() {
            addCriterion("PRODUCT_IMPORTANCE_ID is null");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdIsNotNull() {
            addCriterion("PRODUCT_IMPORTANCE_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID =", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdNotEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID <>", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdGreaterThan(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID >", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdGreaterThanOrEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID >=", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdLessThan(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID <", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdLessThanOrEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID <=", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdLike(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID like", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdNotLike(String value) {
            addCriterion("PRODUCT_IMPORTANCE_ID not like", value, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdIn(List<String> values) {
            addCriterion("PRODUCT_IMPORTANCE_ID in", values, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdNotIn(List<String> values) {
            addCriterion("PRODUCT_IMPORTANCE_ID not in", values, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdBetween(String value1, String value2) {
            addCriterion("PRODUCT_IMPORTANCE_ID between", value1, value2, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceIdNotBetween(String value1, String value2) {
            addCriterion("PRODUCT_IMPORTANCE_ID not between", value1, value2, "productImportanceId");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameIsNull() {
            addCriterion("PRODUCT_IMPORTANCE_NAME is null");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameIsNotNull() {
            addCriterion("PRODUCT_IMPORTANCE_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME =", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameNotEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME <>", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameGreaterThan(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME >", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameGreaterThanOrEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME >=", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameLessThan(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME <", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameLessThanOrEqualTo(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME <=", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameLike(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME like", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameNotLike(String value) {
            addCriterion("PRODUCT_IMPORTANCE_NAME not like", value, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameIn(List<String> values) {
            addCriterion("PRODUCT_IMPORTANCE_NAME in", values, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameNotIn(List<String> values) {
            addCriterion("PRODUCT_IMPORTANCE_NAME not in", values, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameBetween(String value1, String value2) {
            addCriterion("PRODUCT_IMPORTANCE_NAME between", value1, value2, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andProductImportanceNameNotBetween(String value1, String value2) {
            addCriterion("PRODUCT_IMPORTANCE_NAME not between", value1, value2, "productImportanceName");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdIsNull() {
            addCriterion("SYMBIOSIS_ID is null");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdIsNotNull() {
            addCriterion("SYMBIOSIS_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdEqualTo(String value) {
            addCriterion("SYMBIOSIS_ID =", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdNotEqualTo(String value) {
            addCriterion("SYMBIOSIS_ID <>", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdGreaterThan(String value) {
            addCriterion("SYMBIOSIS_ID >", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdGreaterThanOrEqualTo(String value) {
            addCriterion("SYMBIOSIS_ID >=", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdLessThan(String value) {
            addCriterion("SYMBIOSIS_ID <", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdLessThanOrEqualTo(String value) {
            addCriterion("SYMBIOSIS_ID <=", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdLike(String value) {
            addCriterion("SYMBIOSIS_ID like", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdNotLike(String value) {
            addCriterion("SYMBIOSIS_ID not like", value, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdIn(List<String> values) {
            addCriterion("SYMBIOSIS_ID in", values, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdNotIn(List<String> values) {
            addCriterion("SYMBIOSIS_ID not in", values, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdBetween(String value1, String value2) {
            addCriterion("SYMBIOSIS_ID between", value1, value2, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIdNotBetween(String value1, String value2) {
            addCriterion("SYMBIOSIS_ID not between", value1, value2, "symbiosisId");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIsNull() {
            addCriterion("SYMBIOSIS is null");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIsNotNull() {
            addCriterion("SYMBIOSIS is not null");
            return (Criteria) this;
        }

        public Criteria andSymbiosisEqualTo(String value) {
            addCriterion("SYMBIOSIS =", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisNotEqualTo(String value) {
            addCriterion("SYMBIOSIS <>", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisGreaterThan(String value) {
            addCriterion("SYMBIOSIS >", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisGreaterThanOrEqualTo(String value) {
            addCriterion("SYMBIOSIS >=", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisLessThan(String value) {
            addCriterion("SYMBIOSIS <", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisLessThanOrEqualTo(String value) {
            addCriterion("SYMBIOSIS <=", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisLike(String value) {
            addCriterion("SYMBIOSIS like", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisNotLike(String value) {
            addCriterion("SYMBIOSIS not like", value, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisIn(List<String> values) {
            addCriterion("SYMBIOSIS in", values, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisNotIn(List<String> values) {
            addCriterion("SYMBIOSIS not in", values, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisBetween(String value1, String value2) {
            addCriterion("SYMBIOSIS between", value1, value2, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andSymbiosisNotBetween(String value1, String value2) {
            addCriterion("SYMBIOSIS not between", value1, value2, "symbiosis");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdIsNull() {
            addCriterion("CRITICALITY_ID is null");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdIsNotNull() {
            addCriterion("CRITICALITY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdEqualTo(String value) {
            addCriterion("CRITICALITY_ID =", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdNotEqualTo(String value) {
            addCriterion("CRITICALITY_ID <>", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdGreaterThan(String value) {
            addCriterion("CRITICALITY_ID >", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdGreaterThanOrEqualTo(String value) {
            addCriterion("CRITICALITY_ID >=", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdLessThan(String value) {
            addCriterion("CRITICALITY_ID <", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdLessThanOrEqualTo(String value) {
            addCriterion("CRITICALITY_ID <=", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdLike(String value) {
            addCriterion("CRITICALITY_ID like", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdNotLike(String value) {
            addCriterion("CRITICALITY_ID not like", value, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdIn(List<String> values) {
            addCriterion("CRITICALITY_ID in", values, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdNotIn(List<String> values) {
            addCriterion("CRITICALITY_ID not in", values, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdBetween(String value1, String value2) {
            addCriterion("CRITICALITY_ID between", value1, value2, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityIdNotBetween(String value1, String value2) {
            addCriterion("CRITICALITY_ID not between", value1, value2, "criticalityId");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameIsNull() {
            addCriterion("CRITICALITY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameIsNotNull() {
            addCriterion("CRITICALITY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameEqualTo(String value) {
            addCriterion("CRITICALITY_NAME =", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameNotEqualTo(String value) {
            addCriterion("CRITICALITY_NAME <>", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameGreaterThan(String value) {
            addCriterion("CRITICALITY_NAME >", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameGreaterThanOrEqualTo(String value) {
            addCriterion("CRITICALITY_NAME >=", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameLessThan(String value) {
            addCriterion("CRITICALITY_NAME <", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameLessThanOrEqualTo(String value) {
            addCriterion("CRITICALITY_NAME <=", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameLike(String value) {
            addCriterion("CRITICALITY_NAME like", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameNotLike(String value) {
            addCriterion("CRITICALITY_NAME not like", value, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameIn(List<String> values) {
            addCriterion("CRITICALITY_NAME in", values, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameNotIn(List<String> values) {
            addCriterion("CRITICALITY_NAME not in", values, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameBetween(String value1, String value2) {
            addCriterion("CRITICALITY_NAME between", value1, value2, "criticalityName");
            return (Criteria) this;
        }

        public Criteria andCriticalityNameNotBetween(String value1, String value2) {
            addCriterion("CRITICALITY_NAME not between", value1, value2, "criticalityName");
            return (Criteria) this;
        }
        
        public Criteria andIsOnlineIsNull() {
            addCriterion("IS_ONLINE is null");
            return (Criteria) this;
        }

        public Criteria andIsOnlineIsNotNull() {
            addCriterion("IS_ONLINE is not null");
            return (Criteria) this;
        }

        public Criteria andIsOnlineEqualTo(Integer value) {
            addCriterion("IS_ONLINE =", value, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineNotEqualTo(Integer value) {
            addCriterion("IS_ONLINE <>", value, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineGreaterThan(Integer value) {
            addCriterion("IS_ONLINE >", value, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ONLINE >=", value, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineLessThan(Integer value) {
            addCriterion("IS_ONLINE <", value, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ONLINE <=", value, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineIn(List<Integer> values) {
            addCriterion("IS_ONLINE in", values, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineNotIn(List<Integer> values) {
            addCriterion("IS_ONLINE not in", values, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineBetween(Integer value1, Integer value2) {
            addCriterion("IS_ONLINE between", value1, value2, "isOnline");
            return (Criteria) this;
        }

        public Criteria andIsOnlineNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ONLINE not between", value1, value2, "isOnline");
            return (Criteria) this;
        }

        public Criteria andAttribute1IsNull() {
            addCriterion("ATTRIBUTE1 is null");
            return (Criteria) this;
        }

        public Criteria andAttribute1IsNotNull() {
            addCriterion("ATTRIBUTE1 is not null");
            return (Criteria) this;
        }

        public Criteria andAttribute1EqualTo(String value) {
            addCriterion("ATTRIBUTE1 =", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1NotEqualTo(String value) {
            addCriterion("ATTRIBUTE1 <>", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1GreaterThan(String value) {
            addCriterion("ATTRIBUTE1 >", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1GreaterThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE1 >=", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1LessThan(String value) {
            addCriterion("ATTRIBUTE1 <", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1LessThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE1 <=", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1Like(String value) {
            addCriterion("ATTRIBUTE1 like", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1NotLike(String value) {
            addCriterion("ATTRIBUTE1 not like", value, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1In(List<String> values) {
            addCriterion("ATTRIBUTE1 in", values, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1NotIn(List<String> values) {
            addCriterion("ATTRIBUTE1 not in", values, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1Between(String value1, String value2) {
            addCriterion("ATTRIBUTE1 between", value1, value2, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute1NotBetween(String value1, String value2) {
            addCriterion("ATTRIBUTE1 not between", value1, value2, "attribute1");
            return (Criteria) this;
        }

        public Criteria andAttribute2IsNull() {
            addCriterion("ATTRIBUTE2 is null");
            return (Criteria) this;
        }

        public Criteria andAttribute2IsNotNull() {
            addCriterion("ATTRIBUTE2 is not null");
            return (Criteria) this;
        }

        public Criteria andAttribute2EqualTo(String value) {
            addCriterion("ATTRIBUTE2 =", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2NotEqualTo(String value) {
            addCriterion("ATTRIBUTE2 <>", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2GreaterThan(String value) {
            addCriterion("ATTRIBUTE2 >", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2GreaterThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE2 >=", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2LessThan(String value) {
            addCriterion("ATTRIBUTE2 <", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2LessThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE2 <=", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2Like(String value) {
            addCriterion("ATTRIBUTE2 like", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2NotLike(String value) {
            addCriterion("ATTRIBUTE2 not like", value, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2In(List<String> values) {
            addCriterion("ATTRIBUTE2 in", values, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2NotIn(List<String> values) {
            addCriterion("ATTRIBUTE2 not in", values, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2Between(String value1, String value2) {
            addCriterion("ATTRIBUTE2 between", value1, value2, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute2NotBetween(String value1, String value2) {
            addCriterion("ATTRIBUTE2 not between", value1, value2, "attribute2");
            return (Criteria) this;
        }

        public Criteria andAttribute3IsNull() {
            addCriterion("ATTRIBUTE3 is null");
            return (Criteria) this;
        }

        public Criteria andAttribute3IsNotNull() {
            addCriterion("ATTRIBUTE3 is not null");
            return (Criteria) this;
        }

        public Criteria andAttribute3EqualTo(String value) {
            addCriterion("ATTRIBUTE3 =", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3NotEqualTo(String value) {
            addCriterion("ATTRIBUTE3 <>", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3GreaterThan(String value) {
            addCriterion("ATTRIBUTE3 >", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3GreaterThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE3 >=", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3LessThan(String value) {
            addCriterion("ATTRIBUTE3 <", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3LessThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE3 <=", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3Like(String value) {
            addCriterion("ATTRIBUTE3 like", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3NotLike(String value) {
            addCriterion("ATTRIBUTE3 not like", value, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3In(List<String> values) {
            addCriterion("ATTRIBUTE3 in", values, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3NotIn(List<String> values) {
            addCriterion("ATTRIBUTE3 not in", values, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3Between(String value1, String value2) {
            addCriterion("ATTRIBUTE3 between", value1, value2, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute3NotBetween(String value1, String value2) {
            addCriterion("ATTRIBUTE3 not between", value1, value2, "attribute3");
            return (Criteria) this;
        }

        public Criteria andAttribute4IsNull() {
            addCriterion("ATTRIBUTE4 is null");
            return (Criteria) this;
        }

        public Criteria andAttribute4IsNotNull() {
            addCriterion("ATTRIBUTE4 is not null");
            return (Criteria) this;
        }

        public Criteria andAttribute4EqualTo(String value) {
            addCriterion("ATTRIBUTE4 =", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4NotEqualTo(String value) {
            addCriterion("ATTRIBUTE4 <>", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4GreaterThan(String value) {
            addCriterion("ATTRIBUTE4 >", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4GreaterThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE4 >=", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4LessThan(String value) {
            addCriterion("ATTRIBUTE4 <", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4LessThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE4 <=", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4Like(String value) {
            addCriterion("ATTRIBUTE4 like", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4NotLike(String value) {
            addCriterion("ATTRIBUTE4 not like", value, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4In(List<String> values) {
            addCriterion("ATTRIBUTE4 in", values, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4NotIn(List<String> values) {
            addCriterion("ATTRIBUTE4 not in", values, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4Between(String value1, String value2) {
            addCriterion("ATTRIBUTE4 between", value1, value2, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute4NotBetween(String value1, String value2) {
            addCriterion("ATTRIBUTE4 not between", value1, value2, "attribute4");
            return (Criteria) this;
        }

        public Criteria andAttribute5IsNull() {
            addCriterion("ATTRIBUTE5 is null");
            return (Criteria) this;
        }

        public Criteria andAttribute5IsNotNull() {
            addCriterion("ATTRIBUTE5 is not null");
            return (Criteria) this;
        }

        public Criteria andAttribute5EqualTo(String value) {
            addCriterion("ATTRIBUTE5 =", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5NotEqualTo(String value) {
            addCriterion("ATTRIBUTE5 <>", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5GreaterThan(String value) {
            addCriterion("ATTRIBUTE5 >", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5GreaterThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE5 >=", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5LessThan(String value) {
            addCriterion("ATTRIBUTE5 <", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5LessThanOrEqualTo(String value) {
            addCriterion("ATTRIBUTE5 <=", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5Like(String value) {
            addCriterion("ATTRIBUTE5 like", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5NotLike(String value) {
            addCriterion("ATTRIBUTE5 not like", value, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5In(List<String> values) {
            addCriterion("ATTRIBUTE5 in", values, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5NotIn(List<String> values) {
            addCriterion("ATTRIBUTE5 not in", values, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5Between(String value1, String value2) {
            addCriterion("ATTRIBUTE5 between", value1, value2, "attribute5");
            return (Criteria) this;
        }

        public Criteria andAttribute5NotBetween(String value1, String value2) {
            addCriterion("ATTRIBUTE5 not between", value1, value2, "attribute5");
            return (Criteria) this;
        }

        public Criteria andUseDeptIsNull() {
            addCriterion("USE_DEPT is null");
            return (Criteria) this;
        }

        public Criteria andUseDeptIsNotNull() {
            addCriterion("USE_DEPT is not null");
            return (Criteria) this;
        }

        public Criteria andUseDeptEqualTo(String value) {
            addCriterion("USE_DEPT =", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptNotEqualTo(String value) {
            addCriterion("USE_DEPT <>", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptGreaterThan(String value) {
            addCriterion("USE_DEPT >", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptGreaterThanOrEqualTo(String value) {
            addCriterion("USE_DEPT >=", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptLessThan(String value) {
            addCriterion("USE_DEPT <", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptLessThanOrEqualTo(String value) {
            addCriterion("USE_DEPT <=", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptLike(String value) {
            addCriterion("USE_DEPT like", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptNotLike(String value) {
            addCriterion("USE_DEPT not like", value, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptIn(List<String> values) {
            addCriterion("USE_DEPT in", values, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptNotIn(List<String> values) {
            addCriterion("USE_DEPT not in", values, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptBetween(String value1, String value2) {
            addCriterion("USE_DEPT between", value1, value2, "useDept");
            return (Criteria) this;
        }

        public Criteria andUseDeptNotBetween(String value1, String value2) {
            addCriterion("USE_DEPT not between", value1, value2, "useDept");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeIsNull() {
            addCriterion("SUPPLIER_TYPE is null");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeIsNotNull() {
            addCriterion("SUPPLIER_TYPE is not null");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeEqualTo(String value) {
            addCriterion("SUPPLIER_TYPE =", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeNotEqualTo(String value) {
            addCriterion("SUPPLIER_TYPE <>", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeGreaterThan(String value) {
            addCriterion("SUPPLIER_TYPE >", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeGreaterThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_TYPE >=", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeLessThan(String value) {
            addCriterion("SUPPLIER_TYPE <", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeLessThanOrEqualTo(String value) {
            addCriterion("SUPPLIER_TYPE <=", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeLike(String value) {
            addCriterion("SUPPLIER_TYPE like", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeNotLike(String value) {
            addCriterion("SUPPLIER_TYPE not like", value, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeIn(List<String> values) {
            addCriterion("SUPPLIER_TYPE in", values, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeNotIn(List<String> values) {
            addCriterion("SUPPLIER_TYPE not in", values, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeBetween(String value1, String value2) {
            addCriterion("SUPPLIER_TYPE between", value1, value2, "supplierType");
            return (Criteria) this;
        }

        public Criteria andSupplierTypeNotBetween(String value1, String value2) {
            addCriterion("SUPPLIER_TYPE not between", value1, value2, "supplierType");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumIsNull() {
            addCriterion("FRAMEWORK_AGREE_NUM is null");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumIsNotNull() {
            addCriterion("FRAMEWORK_AGREE_NUM is not null");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumEqualTo(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM =", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumNotEqualTo(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM <>", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumGreaterThan(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM >", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumGreaterThanOrEqualTo(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM >=", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumLessThan(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM <", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumLessThanOrEqualTo(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM <=", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumLike(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM like", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumNotLike(String value) {
            addCriterion("FRAMEWORK_AGREE_NUM not like", value, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumIn(List<String> values) {
            addCriterion("FRAMEWORK_AGREE_NUM in", values, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumNotIn(List<String> values) {
            addCriterion("FRAMEWORK_AGREE_NUM not in", values, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumBetween(String value1, String value2) {
            addCriterion("FRAMEWORK_AGREE_NUM between", value1, value2, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkAgreeNumNotBetween(String value1, String value2) {
            addCriterion("FRAMEWORK_AGREE_NUM not between", value1, value2, "frameworkAgreeNum");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedIsNull() {
            addCriterion("FRAMEWORK_IS_SIGNED is null");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedIsNotNull() {
            addCriterion("FRAMEWORK_IS_SIGNED is not null");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedEqualTo(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED =", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedNotEqualTo(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED <>", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedGreaterThan(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED >", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedGreaterThanOrEqualTo(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED >=", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedLessThan(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED <", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedLessThanOrEqualTo(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED <=", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedLike(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED like", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedNotLike(String value) {
            addCriterion("FRAMEWORK_IS_SIGNED not like", value, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedIn(List<String> values) {
            addCriterion("FRAMEWORK_IS_SIGNED in", values, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedNotIn(List<String> values) {
            addCriterion("FRAMEWORK_IS_SIGNED not in", values, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedBetween(String value1, String value2) {
            addCriterion("FRAMEWORK_IS_SIGNED between", value1, value2, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andFrameworkIsSignedNotBetween(String value1, String value2) {
            addCriterion("FRAMEWORK_IS_SIGNED not between", value1, value2, "frameworkIsSigned");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyIsNull() {
            addCriterion("RETENTION_MONEY is null");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyIsNotNull() {
            addCriterion("RETENTION_MONEY is not null");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyEqualTo(String value) {
            addCriterion("RETENTION_MONEY =", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyNotEqualTo(String value) {
            addCriterion("RETENTION_MONEY <>", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyGreaterThan(String value) {
            addCriterion("RETENTION_MONEY >", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyGreaterThanOrEqualTo(String value) {
            addCriterion("RETENTION_MONEY >=", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyLessThan(String value) {
            addCriterion("RETENTION_MONEY <", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyLessThanOrEqualTo(String value) {
            addCriterion("RETENTION_MONEY <=", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyLike(String value) {
            addCriterion("RETENTION_MONEY like", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyNotLike(String value) {
            addCriterion("RETENTION_MONEY not like", value, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyIn(List<String> values) {
            addCriterion("RETENTION_MONEY in", values, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyNotIn(List<String> values) {
            addCriterion("RETENTION_MONEY not in", values, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyBetween(String value1, String value2) {
            addCriterion("RETENTION_MONEY between", value1, value2, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andRetentionMoneyNotBetween(String value1, String value2) {
            addCriterion("RETENTION_MONEY not between", value1, value2, "retentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyIsNull() {
            addCriterion("EXIST_RETENTION_MONEY is null");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyIsNotNull() {
            addCriterion("EXIST_RETENTION_MONEY is not null");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyEqualTo(String value) {
            addCriterion("EXIST_RETENTION_MONEY =", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyNotEqualTo(String value) {
            addCriterion("EXIST_RETENTION_MONEY <>", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyGreaterThan(String value) {
            addCriterion("EXIST_RETENTION_MONEY >", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyGreaterThanOrEqualTo(String value) {
            addCriterion("EXIST_RETENTION_MONEY >=", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyLessThan(String value) {
            addCriterion("EXIST_RETENTION_MONEY <", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyLessThanOrEqualTo(String value) {
            addCriterion("EXIST_RETENTION_MONEY <=", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyLike(String value) {
            addCriterion("EXIST_RETENTION_MONEY like", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyNotLike(String value) {
            addCriterion("EXIST_RETENTION_MONEY not like", value, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyIn(List<String> values) {
            addCriterion("EXIST_RETENTION_MONEY in", values, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyNotIn(List<String> values) {
            addCriterion("EXIST_RETENTION_MONEY not in", values, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyBetween(String value1, String value2) {
            addCriterion("EXIST_RETENTION_MONEY between", value1, value2, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andExistRetentionMoneyNotBetween(String value1, String value2) {
            addCriterion("EXIST_RETENTION_MONEY not between", value1, value2, "existRetentionMoney");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesIsNull() {
            addCriterion("KN_MNG_FILES is null");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesIsNotNull() {
            addCriterion("KN_MNG_FILES is not null");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesEqualTo(String value) {
            addCriterion("KN_MNG_FILES =", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesNotEqualTo(String value) {
            addCriterion("KN_MNG_FILES <>", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesGreaterThan(String value) {
            addCriterion("KN_MNG_FILES >", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesGreaterThanOrEqualTo(String value) {
            addCriterion("KN_MNG_FILES >=", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesLessThan(String value) {
            addCriterion("KN_MNG_FILES <", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesLessThanOrEqualTo(String value) {
            addCriterion("KN_MNG_FILES <=", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesLike(String value) {
            addCriterion("KN_MNG_FILES like", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesNotLike(String value) {
            addCriterion("KN_MNG_FILES not like", value, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesIn(List<String> values) {
            addCriterion("KN_MNG_FILES in", values, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesNotIn(List<String> values) {
            addCriterion("KN_MNG_FILES not in", values, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesBetween(String value1, String value2) {
            addCriterion("KN_MNG_FILES between", value1, value2, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngFilesNotBetween(String value1, String value2) {
            addCriterion("KN_MNG_FILES not between", value1, value2, "knMngFiles");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkIsNull() {
            addCriterion("KN_MNG_REMARK is null");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkIsNotNull() {
            addCriterion("KN_MNG_REMARK is not null");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkEqualTo(String value) {
            addCriterion("KN_MNG_REMARK =", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkNotEqualTo(String value) {
            addCriterion("KN_MNG_REMARK <>", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkGreaterThan(String value) {
            addCriterion("KN_MNG_REMARK >", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkGreaterThanOrEqualTo(String value) {
            addCriterion("KN_MNG_REMARK >=", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkLessThan(String value) {
            addCriterion("KN_MNG_REMARK <", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkLessThanOrEqualTo(String value) {
            addCriterion("KN_MNG_REMARK <=", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkLike(String value) {
            addCriterion("KN_MNG_REMARK like", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkNotLike(String value) {
            addCriterion("KN_MNG_REMARK not like", value, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkIn(List<String> values) {
            addCriterion("KN_MNG_REMARK in", values, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkNotIn(List<String> values) {
            addCriterion("KN_MNG_REMARK not in", values, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkBetween(String value1, String value2) {
            addCriterion("KN_MNG_REMARK between", value1, value2, "knMngRemark");
            return (Criteria) this;
        }

        public Criteria andKnMngRemarkNotBetween(String value1, String value2) {
            addCriterion("KN_MNG_REMARK not between", value1, value2, "knMngRemark");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}