package com.els.base.company.entity;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="KN管理资料表")
public class KnManageFile implements Serializable {
    private String id;

    private String projectId;

    private String supCompanyId;

    private String supCompanyCode;

    private String supCompanySapCode;

    private String fileName;

    private Date createTime;

    private Date updateTime;

    private String remark;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    private String attachment;

    private String purCompanyId;

    private String purCompanyCode;

    private String purUserId;

    private String purUserName;

    @ApiModelProperty("证书有效期至")
    private Date certificateValidityUntil;

    @ApiModelProperty("证书签发日期")
    private Date certificateIssueDate;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyCode() {
        return supCompanyCode;
    }

    public void setSupCompanyCode(String supCompanyCode) {
        this.supCompanyCode = supCompanyCode == null ? null : supCompanyCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName == null ? null : fileName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public Date getCertificateValidityUntil() {
        return certificateValidityUntil;
    }

    public void setCertificateValidityUntil(Date certificateValidityUntil) {
        this.certificateValidityUntil = certificateValidityUntil;
    }

    public Date getCertificateIssueDate() {
        return certificateIssueDate;
    }

    public void setCertificateIssueDate(Date certificateIssueDate) {
        this.certificateIssueDate = certificateIssueDate;
    }
}