package com.els.base.company.service;

import java.util.List;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;

public interface CompanyPurRefService extends BaseService<CompanyPurRef, CompanyPurRefExample, String> {
	
	/**
	 * 根据采购员查询其与管理的供应商关系
	 * @param userId
	 * @return
	 */
	List<CompanyPurRef> queryAllCompanyPurRefByUserId(String userId);
	
	/**
	 * 根据采购员查询其管理的供应商及其详细信息
	 * @param userId
	 * @return
	 */
	List<Company> queryAllCompanyByUserId(String purUserId, CompanyExample example);
	
	/**
	 * 通过采购用户查询其负责的供应商详细信息,供交货计划和采购预测使用
	 */
	PageView<Company> queryAllCompanyForPageView(String purUserId, CompanyExample example);
	
	/**
	 * 根据采购员查询其管理的供应商及其详细信息
	 * @param userId
	 * @return
	 */
	List<FriendGroup> querySupplyFriendGroup(String purUserId);
	
	/**
	 * 根据供应商ID查询其负责的采购员信息，以及该公司的基本信息
	 * @return
	 */
	List<FriendGroup> queryPurchaseFriendGroup(String supCompanyId);
	
	/**
	 * 根据供应商ID查询其负责的采购员信息，以及该公司的基本信息
	 * @return
	 */
	FriendGroup queryPurchaseFriendGroup(String supCompanyId, String purCompanyId);
	
	/**
	 * 查询采购商用户
	 * @return
	 */
	public List<FriendGroup> queryPurchaseUser(CompanyPurRefExample companyPurRefExample);
	
	/**
	 * 给采购员分配管理的供应商
	 * @param email
	 * @param password
	 */
	public void addSupplierIntoPurchaser(String userId, Company purCompany, List<Company> supCompanyList);
	
}