package com.els.base.company.service;

import java.util.List;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.BaseService;

public interface CompanyUserRefService extends BaseService<CompanyUserRef, CompanyUserRefExample, String> {
	
	/**
	 * 把用户加到公司里面
	 * @param userId
	 * @param companyId
	 */
	public void addUserIntoCompany(String userId, String companyId);
	
	/**
	 * 查询用户所在的企业
	 * @param user
	 * @return
	 */
	public String queryCompanyIdOfUser(String userId);
	
	/**
	 * 查询企业下的用户
	 * @param companyId
	 * @return
	 */
	public List<String> queryUserOfCompany(String companyId);
	/**
	 * 通过供应商公司id查询用户
	 * @param supCompanyId
	 * @param projectId
	 * @return
	 */
	public List<User> queryUserListOfCompany(String companyId);
	/**
	 * 通过供应商公司id查询该公司的主帐号
	 * @param supCompanyId
	 * @param projectId
	 * @return
	 */
	public User queryMainUserOfCompany(String companyId);
	/**
	 * 给供应商添加账号
	 * @param email
	 * @param password
	 */
	public void addSupplierIntoUser(Company company,User user);
	
	/**
	 * 查询供应商用户
	 * @return
	 */
	public List<FriendGroup> findSupplierUser(CompanyUserRefExample companyUserRefExample);
	
}