package com.els.base.company.service;

import java.util.List;

import com.els.base.company.entity.Department;
import com.els.base.company.entity.DepartmentExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.service.BaseService;

public interface DepartmentService extends BaseService<Department, DepartmentExample, String> {
	
	/**
	 * 根据部门id，查询部门中的人员
	 * @param departmentId
	 * @return
	 */
	public PageView<User> queryUsersInDepartmentByPage(int pageNo, int pageSize, String departmentId);
	
	/**
	 * 把用户添加到部门里
	 * @param userId
	 * @param departmentId
	 */
	public void addUserIntoDepartment(String userId, String departmentId);
	
	/**
	 * 根据用户id，查询用户所在的部门
	 * @param userId
	 * @return
	 */
	public Department queryDepartmentOfUser(String userId);
	
	/**
     * 根据上级部门查询下级，这是一个递归的计算，容易有bug，请注意
     * @param parent 必须包含id
     * @return
     */
	public List<Department> queryByParentId(String parentId);
	
	/**
	 * 从MDM系统推送部门信息保存方法
	 * @param t
	 */
	public void insertObj(Department t);
}