package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanyAddressMapper;
import com.els.base.company.entity.CompanyAddress;
import com.els.base.company.entity.CompanyAddressExample;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultCompanyAddressService")
public class CompanyAddressServiceImpl implements CompanyAddressService {
	@Resource
	protected CompanyAddressMapper companyAddressMapper;

	@Transactional
	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public void addObj(CompanyAddress t) {
		/*
		 * if(StringUtils.isBlank(t.getAddressName())){ throw new
		 * CommonException("地址名称为空，操作失败","id_is_blank"); }
		 */
		if (StringUtils.isBlank(t.getAddress())) {
			throw new CommonException("地址为空，操作失败", "base_canot_be_null", "地址");
		}
		if (StringUtils.isBlank(t.getAddressCode())) {
			throw new CommonException("公司地址编码为空，操作失败", "base_canot_be_null", "公司地址编码");
		}
		CompanyAddressExample companyAddressExample = new CompanyAddressExample();
		companyAddressExample.createCriteria().andCompanyIdEqualTo(t.getCompanyId())
				.andAddressCodeEqualTo(t.getAddressCode()).andLanguageCodeEqualTo(t.getLanguageCode());
		if (this.companyAddressMapper.countByExample(companyAddressExample) > 0) {
			throw new CommonException("语言编码已经存在，请不要重复创建", "base_is_exists", "该公司下语言编码");
		}
		t.setCreateTime(new Date());
		t.setUpdateTime(new Date());

		// 如果设置了默认地址，那么需要把该公司下子公司的全部地址设置为非默认
		if (t.getDefaultAddress() != null) {
			if (t.getDefaultAddress() == Constant.YES_INT) {
				CompanyAddressExample example = new CompanyAddressExample();
				example.createCriteria().andCompanyIdEqualTo(t.getCompanyId())
						.andAddressCodeEqualTo(t.getAddressCode());
				List<CompanyAddress> companyAddressList = this.companyAddressMapper.selectByExample(example);

				if (CollectionUtils.isNotEmpty(companyAddressList)) {
					for (CompanyAddress companyAddress : companyAddressList) {
						companyAddress.setDefaultAddress(Constant.NO_INT);
						this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
					}
				}
			}
		}

		this.companyAddressMapper.insertSelective(t);
	}

	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public void deleteObjById(String id) {
		this.companyAddressMapper.deleteByPrimaryKey(id);
	}

	@Transactional
	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public void modifyObj(CompanyAddress t) {
		if (StringUtils.isBlank(t.getId())) {
			throw new NullPointerException("id 为空，无法更新");
		}
		/*
		 * if(StringUtils.isBlank(t.getAddressName())){ throw new
		 * CommonException("地址名称为空，操作失败","id_is_blank"); }
		 */

		if (StringUtils.isBlank(t.getAddress())) {
			throw new CommonException("地址为空，操作失败", "base_canot_be_null", "地址");
		}

		CompanyAddressExample companyAddressExample = new CompanyAddressExample();
		companyAddressExample.createCriteria().andCompanyIdEqualTo(t.getCompanyId())
				.andAddressCodeEqualTo(t.getAddressCode()).andLanguageCodeEqualTo(t.getLanguageCode())
				.andIdNotEqualTo(t.getId());
		if (this.companyAddressMapper.countByExample(companyAddressExample) > 0) {
			throw new CommonException("语言编码已经存在，请不要重复创建", "base_is_exists", "该公司下语言编码");
		}
		t.setUpdateTime(new Date());

		// 如果设置了默认地址，那么需要把该公司下子公司的全部地址设置为非默认
		if (t.getDefaultAddress() != null) {
			if (t.getDefaultAddress() == Constant.YES_INT) {
				CompanyAddressExample example = new CompanyAddressExample();
				example.createCriteria().andCompanyIdEqualTo(t.getCompanyId())
						.andAddressCodeEqualTo(t.getAddressCode());
				List<CompanyAddress> companyAddressList = this.companyAddressMapper.selectByExample(example);

				if (CollectionUtils.isNotEmpty(companyAddressList)) {
					for (CompanyAddress companyAddress : companyAddressList) {
						companyAddress.setDefaultAddress(Constant.NO_INT);
						this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
					}
				}
			}
		}

		this.companyAddressMapper.updateByPrimaryKeySelective(t);
	}

	@Cacheable(value = "companyAddress", keyGenerator="redisKeyGenerator")
	@Override
	public CompanyAddress queryObjById(String id) {
		return this.companyAddressMapper.selectByPrimaryKey(id);
	}

	@Cacheable(value = "companyAddress", keyGenerator="redisKeyGenerator")
	@Override
	public List<CompanyAddress> queryAllObjByExample(CompanyAddressExample example) {
		return this.companyAddressMapper.selectByExample(example);
	}

	@Cacheable(value = "companyAddress", keyGenerator="redisKeyGenerator")
	@Override
	public PageView<CompanyAddress> queryObjByPage(CompanyAddressExample example) {
		PageView<CompanyAddress> pageView = example.getPageView();
		pageView.setQueryResult(this.companyAddressMapper.selectByExampleByPage(example));
		return pageView;
	}

	@Cacheable(value = "companyAddress", keyGenerator="redisKeyGenerator")
	@Override
	public List<CompanyAddress> queryByCompanyId(String companyId) {
		if (StringUtils.isEmpty(companyId)) {
			throw new CommonException("公司ID不能为空", "base_canot_be_null", "公司ID");
		}
		CompanyAddressExample companyAddressExample = new CompanyAddressExample();
		companyAddressExample.or().andCompanyIdEqualTo(companyId).andIsEnableEqualTo(Constant.YES_INT);
		return this.queryAllObjByExample(companyAddressExample);
	}

	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public void deleteByExample(CompanyAddressExample example) {
		this.companyAddressMapper.deleteByExample(example);
	}

	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public void insertBatch(List<CompanyAddress> list) {
		if (CollectionUtils.isEmpty(list)) {
			throw new CommonException("公司地址列表不能为空", "base_canot_be_null", "公司地址列表");
		}
		for (CompanyAddress address : list) {
			this.companyAddressMapper.insertSelective(address);
		}
	}

	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public int isEnable(String id, Integer isEnable) {
		CompanyAddress companyAddress = this.companyAddressMapper.selectByPrimaryKey(id);
		companyAddress.setIsEnable(isEnable);
		return this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
	}

	@Override
	public List<CompanyAddress> queryByCompanyIdAndAddressCodeAndLanguageCode(String companyId, String addressCode,
			String languageCode) {
		if (StringUtils.isEmpty(companyId)) {
			throw new CommonException("公司ID不能为空", "base_canot_be_null", "公司ID");
		}
		CompanyAddressExample companyAddressExample = new CompanyAddressExample();
		CompanyAddressExample.Criteria criteria = companyAddressExample.createCriteria();
		criteria.andCompanyIdEqualTo(companyId).andIsEnableEqualTo(Constant.YES_INT);

		if (StringUtils.isNotBlank(addressCode)) {
			criteria.andAddressCodeEqualTo(addressCode);
		}
		if (StringUtils.isNotBlank(languageCode)) {
			criteria.andLanguageCodeEqualTo(languageCode);
		}
		return this.companyAddressMapper.selectByExample(companyAddressExample);
	}

	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public void updateDefaultAddress(String companyId, String addressCode, String languageCode,
			Integer isDefaultAddress) {
		if (StringUtils.isEmpty(companyId)) {
			throw new CommonException("公司ID不能为空", "base_canot_be_null", "公司ID");
		}
		if (StringUtils.isEmpty(addressCode)) {
			throw new CommonException("子公司编码不能为空", "base_canot_be_null", "子公司编码");
		}
		if (StringUtils.isEmpty(languageCode)) {
			throw new CommonException("公司语言编码不能为空", "base_canot_be_null", "公司语言编码");
		}
		if (isDefaultAddress==null) {
			throw new CommonException("默认地址编码为空", "base_canot_be_null", "默认地址编码");
		}
		CompanyAddressExample companyAddressExample = new CompanyAddressExample();
		CompanyAddressExample.Criteria criteria = companyAddressExample.createCriteria();
		criteria.andCompanyIdEqualTo(companyId);
		criteria.andAddressCodeEqualTo(addressCode);
		List<CompanyAddress> list = this.companyAddressMapper.selectByExample(companyAddressExample);
		if (CollectionUtils.isNotEmpty(list)) {
			for (CompanyAddress companyAddress : list) {
				if(companyAddress.getLanguageCode().equals(languageCode)){
					companyAddress.setDefaultAddress(Constant.YES_INT);
				}else{
					companyAddress.setDefaultAddress(Constant.NO_INT);
				}
				this.companyAddressMapper.updateByPrimaryKeySelective(companyAddress);
			}
		}
	}

	@CacheEvict(value = { "companyAddress" }, allEntries = true)
	@Override
	public void addAll(List<CompanyAddress> t) {
		if(CollectionUtils.isEmpty(t)){
			return;
		}
		this.companyAddressMapper.insertBatch(t);
	}
}