package com.els.base.company.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.dao.CompanyMapper;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

@Service("defaultCompanyService")
public class CompanyServiceImpl implements CompanyService {

    @Resource
    private CompanyMapper companyMapper;
    @Resource
    private CompanyPartnerMapper companyPartnerMapper;
    @Resource
    private UserService userService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ProjectService projectService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;

    @CacheEvict(value = { "company","userService" }, allEntries = true)
    @Override
    public int updateByPrimaryKeySelective(Company record) {
        return this.companyMapper.updateByPrimaryKeySelective(record);
    }

    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void deleteByExample(CompanyExample example) {
        this.companyMapper.deleteByExample(example);
    }

    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public int updateByExampleSelective(Company record, CompanyExample example) {
        return this.companyMapper.updateByExampleSelective(record,example);
    }

    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void insertSelective(Company t) {
//    	if (StringUtils.isBlank(t.getCompanyFullName())) {
//            throw new CommonException("供应商全称不能为空", "base_canot_be_null", "CompanyFullName");
//        }
//        CompanyExample companyExample = new CompanyExample();
//        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
//        companyExampleCriteria.andCompanyFullNameEqualTo(t.getCompanyFullName());
//        int count = companyMapper.countByExample(companyExample);
//        if (count > 0) {
//            throw new CommonException("公司名称 " + t.getCompanyFullName() + "已存在", "base_is_exists",
//                    "CompanyFullName");
//        }
        t.setId(null);
        t.setCreateTime(new Date());
        // 是否上线SRM（0表示否，1表示是）
        t.setIsOnline(Constant.NO_INT);
        // MDM推送来的供应商都是合格供应商，审核状态为1，供应商不能再修改基础资料
        t.setApproveStatus(Constant.YES_INT);
        t.setCompanyCode(generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(t);
        // 为供应商添加用户
        User user = new User();
        if (StringUtils.isNotBlank(t.getCompanySapCode())){
        	user.setLoginName(t.getCompanySapCode());
        } else {
        	user.setLoginName(t.getCompanyCode());
        }
        user.setNickName(t.getCompanyFullName());
        user.setIsEnable(Constant.YES_INT);
        this.userService.addUserFromMdm(user);
        // 创建供应商与用户之间的关系
        this.companyUserRefService.addUserIntoCompany(user.getId(), t.getId());

        // 分配角色
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        // MDM推送过来的供应商都是合格供应商
        roleExampleCriteria.andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
        List<Role> list = roleService.queryAllObjByExample(roleExample);
        if (CollectionUtils.isNotEmpty(list)) {
            for (Role role : list) {
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(role.getId());
                t.setCreateTime(new Date());
                userRoleService.addObj(userRole);
            }
        }
        // 添加供应商跟采购商的关系
        Project project = this.projectService.queryObjById(t.getProjectId());
        
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setProjectId(project.getId());
        companyPartner.setCompanyId(project.getCompanyId());
        companyPartner.setPartnerCompanyId(t.getId());
        companyPartner.setPartnerCompanyName(t.getCompanyFullName());
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());

        this.companyPartnerMapper.insertSelective(companyPartner);
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public Integer isFinish(Company company) {
    	company = this.queryObjById(company.getId());
    	if (!Constant.YES_INT.equals(company.getIsEnable())) {
			return Constant.NO_INT;
		}

    	if (!Constant.YES_INT.equals(company.getFinishFlag())) {
			return Constant.NO_INT;
		}
    	
    	return Constant.YES_INT;
    }

    /*@Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public Company getDefaultCompany() {
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyCriteria = companyExample.createCriteria();
        companyCriteria.andCompanyCodeEqualTo("50000000");
        List<Company> tempCompanyList = companyMapper.selectByExample(companyExample);
        if (CollectionUtils.isEmpty(tempCompanyList)) {
            throw new CommonException("找不到华阳的企业信息");
        }
        return tempCompanyList.get(0);
    }*/

    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void addObjByImport(Company t) {
        if (StringUtils.isBlank(t.getCompanyFullName())) {
            throw new CommonException("CompanyFullNam不能为空", "base_canot_be_null", "CompanyFullNam");
        }
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
        companyExampleCriteria.andCompanyFullNameEqualTo(t.getCompanyFullName());
        int count = companyMapper.countByExample(companyExample);
        if (count > 0) {
            throw new CommonException("公司名称 " + t.getCompanyFullName() + "已存在", "base_is_exists",
                    "CompanyFullName");
        }
        t.setId(null);
        t.setCompanyCode(generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(t);

        // 调用插入公司成功后需要创建一个对应的用户
        //SpringContextHolder.getApplicationContext().publishEvent(new CompanyCreatedSuccessEvent(t));
    }

    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void addObj(Company t) {
        if (StringUtils.isBlank(t.getCompanyFullName())) {
            throw new CommonException("CompanyFullNam不能为空", "base_canot_be_null", "CompanyFullNam");
        }
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
        companyExampleCriteria.andCompanyFullNameEqualTo(t.getCompanyFullName());
        int count = companyMapper.countByExample(companyExample);
        if (count > 0) {
            throw new CommonException("公司名称 " + t.getCompanyFullName() + "已存在", "base_is_exists",
                    "CompanyFullName");
        }
        t.setId(null);
        t.setCompanyCode(generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(t);

        // 调用插入公司成功后需要创建一个对应的用户
        //SpringContextHolder.getApplicationContext().publishEvent(new CompanyCreatedSuccessEvent(t));
    }


    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("id不能为空", "id_is_blank");
        }
        Company company = companyMapper.selectByPrimaryKey(id);
        if (company == null) {
            throw new CommonException("companyId不能为空", "id_is_blank");
        }
        company.setIsEnable(Constant.NO_INT);
        this.companyMapper.updateByPrimaryKey(company);
    }

    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void modifyObj(Company t) {
    	Assert.isNotBlank(t.getId(), "供应商ID为空，更新失败");
        this.companyMapper.updateByPrimaryKeySelective(t);
    }
    
    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
	public void modifyCompany(Project project, Company t) {
    	// 公司编码不做更改
        t.setCompanyCode(null);
        Assert.isNotBlank(t.getProductSupplyCycle(), "欲竞投类产品供货周期不能为空");
        if (StringUtils.isBlank(t.getId())) {
            throw new CommonException("companyId为空", "id_is_blank");
        }
        if (t.getCompanyFullName() != null) {
            if (t.getCompanyFullName().length() > 255
                    || !t.getCompanyFullName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(（\\)）]+")) {
                throw new CommonException("格式不正确", "base_invaild_format", "企业全称");
            }
        }
        if (t.getCompanyName() != null) {
            if (t.getCompanyName().length() > 255
                    || !t.getCompanyName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(（\\)）]+")) {
                throw new CommonException("格式不正确", "base_invaild_format", "企业简称");
            }
        }
        this.companyMapper.updateByPrimaryKeySelective(t);
        
//        // 查询供应商与采购商是否设置关系（从MDM系统推送过来的供应商可能没有设置关系，在填写资料的时候设置）
//        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
//        partnerExample.createCriteria().andPartnerCompanyIdEqualTo(t.getId());
//        if (this.companyPartnerMapper.countByExample(partnerExample) == 0) {
//        	// 设置供应商与采购商关系
//        	this.setCompanyPartner(project, t);
//        }
		
	}

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public Company queryObjById(String id) {
        return this.companyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public List<Company> queryAllObjByExample(CompanyExample example) {
        return this.companyMapper.selectByExample(example);
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<Company> queryObjByPage(CompanyExample example) {
        PageView<Company> pageView = example.getPageView();
        pageView.setQueryResult(this.companyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> companyList = this.companyMapper.selectSupCompanyByPage(companyExample, purCompanyId);

        pageView.setQueryResult(companyList);
        return pageView;
    }
    
    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<Company> queryPurchaseCompaniesByPage(String companyId, CompanyExample companyExample) {

        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andPartnerCompanyIdEqualTo(companyId);

        List<CompanyPartner> partnerList = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(partnerList)) {
            return companyExample.getPageView();
        }

        List<String> partnerIdList = new ArrayList<>();
        for (CompanyPartner partner : partnerList) {
            partnerIdList.add(partner.getCompanyId());
        }

        if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
            companyExample.createCriteria().andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            for (int i = 0; i < companyExample.getOredCriteria().size(); i++) {
                companyExample.getOredCriteria().get(i).andIdIn(partnerIdList)
                        .andIsEnableEqualTo(Constant.YES_INT);
            }
        }

        List<Company> companyList = this.companyMapper.selectByExampleByPage(companyExample);

        return companyExample.getPageView().setQueryResult(companyList);
    }
    
    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public List<Company> queryPurchaseCompanies(String companyId, CompanyExample companyExample) {
    	
    	CompanyPartnerExample partnerExample = new CompanyPartnerExample();
    	partnerExample.createCriteria().andPartnerCompanyIdEqualTo(companyId);
    	
    	List<CompanyPartner> partnerList = this.companyPartnerMapper.selectByExample(partnerExample);
    	if (CollectionUtils.isEmpty(partnerList)) {
    		return null;
    	}
    	
    	List<String> partnerIdList = new ArrayList<>();
    	for (CompanyPartner partner : partnerList) {
    		partnerIdList.add(partner.getCompanyId());
    	}
    	
    	if (companyExample == null) {
			companyExample = new CompanyExample();
		}
    	
    	if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
    		companyExample.createCriteria().andIdIn(partnerIdList).andIsEnableEqualTo(Constant.YES_INT);
    	} else {
    		for (int i = 0; i < companyExample.getOredCriteria().size(); i++) {
    			companyExample.getOredCriteria().get(i).andIdIn(partnerIdList)
    			.andIsEnableEqualTo(Constant.YES_INT);
    		}
    	}
    	
    	return this.companyMapper.selectByExample(companyExample);
    	
    }
    
    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
	@Override
	public Company queryPurchaseCompanies(String supCompanyId) {
		CompanyExample companyExample = new CompanyExample();
		companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
		
		List<Company> list = this.queryPurchaseCompanies(supCompanyId, companyExample);
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}
		
		if (list.size() > 1) {
			throw new CommonException("该供应商有多个采购商");
		}
		
		return list.get(0);
	}

    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void addCompanyAsSupplier(CompanyPartner companyPartner) {
        if (StringUtils.isBlank(companyPartner.getCompanyId())) {
            throw new CommonException("采购商id不能为空", "id_is_blank");
        }
        if (companyPartner.getPartner() == null) {
            throw new CommonException("供应商的信息不能为空", "base_canot_be_null", "供应商的信息");
        }

        Company partner = companyPartner.getPartner();
        this.addObj(partner);

        companyPartner.setPartnerCompanyId(partner.getId());
        this.companyPartnerMapper.insertSelective(companyPartner);
    }

    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void changeCompanyPartnerRole(String companyId, String supplierCompanyId, String roleCode) {
        CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        partnerExample.createCriteria().andCompanyIdEqualTo(companyId)
                .andPartnerCompanyIdEqualTo(supplierCompanyId);

        List<CompanyPartner> list = this.companyPartnerMapper.selectByExample(partnerExample);
        if (CollectionUtils.isEmpty(list)) {
            CompanyPartner partner = new CompanyPartner();
            partner.setCompanyId(companyId);
            partner.setPartnerCompanyId(supplierCompanyId);
            partner.setPartnerCompanyName(this.queryObjById(supplierCompanyId).getCompanyName());
            partner.setPartnerRoleCode(roleCode);
            this.companyPartnerMapper.insertSelective(partner);
        } else {

            CompanyPartner partner = new CompanyPartner();
            partner.setPartnerRoleCode(roleCode);
            this.companyPartnerMapper.updateByExampleSelective(partner, partnerExample);
        }
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public int isEnable(String companyId, Integer isEnable) {
        Company company = new Company();
        company.setId(companyId);
        company.setIsEnable(isEnable);
        return this.companyMapper.updateByPrimaryKeySelective(company);
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public List<Company> queryAllSupplerCompanies(String purCompanyId, CompanyExample companyExample) {
        // List<CompanyPartner> partnerList =
        // this.companyPartnerMapper.selectByExample(partnerExample);
        // // 供应商列表为空，则返回
        // if (CollectionUtils.isEmpty(partnerList)) {
        // return null;
        // }
        // // 获取供应商ID
        // List<String> partnerIdList = new ArrayList<String>();
        // for (CompanyPartner partner : partnerList) {
        // partnerIdList.add(partner.getPartnerCompanyId());
        // }
        // 添加查询条件
        if (CollectionUtils.isNotEmpty(companyExample.getOredCriteria())) {
            companyExample.getOredCriteria().get(0).andIsEnableEqualTo(Constant.YES_INT);
        }
        List<Company> companyList = this.companyMapper.selectSupCompany(companyExample, purCompanyId);
        return companyList;
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample,
            String roleEnum) {	
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> list = this.companyMapper.selectPartnerByExampleByPage(purCompanyId, companyExample,
                roleEnum);
        pageView.setQueryResult(list);
        return pageView;
    }
    
    
    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public List<Company> querySupplerCompaniesList(String purCompanyId, CompanyExample companyExample,
            String roleEnum) {
        List<Company> list = this.companyMapper.selectPartnerByExampleByPage(purCompanyId, companyExample,
                roleEnum);
        return list;
    }
    
    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
	public PageView<Company> querySupplerCompanyHaveSap(String purCompanyId, CompanyExample example, String roleEnum) {
    	PageView<Company> pageView = example.getPageView();
		List<Company> list = this.companyMapper.selectCompanyHaveSapByPage(purCompanyId, example, roleEnum);
		pageView.setQueryResult(list);
		return pageView;
	}

    //@Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    /**
     * 这里不用缓存,直接查数据库
     */
    @Override
    public PageView<Company> querySupplerCompaniesForApply(String purCompanyId,
            CompanyExample companyExample, String roleEnum) {
        PageView<Company> pageView = companyExample.getPageView();
        List<Company> list = this.companyMapper.selectPartnerByExampleForApplyByPage(purCompanyId,
                companyExample, roleEnum);
        pageView.setQueryResult(list);
        return pageView;
    }

    @Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
    @Override
    public Company queryCompanyByCode(String companyCode) {
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyCodeEqualTo(companyCode);

        List<Company> companyList = this.companyMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(companyList)) {
            return null;
        }

        return companyList.get(0);
    }

    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public void updatePartnerRole(CompanyPartner companyPartner, CompanyPartnerExample example) {
        companyPartner.setId(null);
        this.companyPartnerMapper.updateByExampleSelective(companyPartner, example);

    }

    @Transactional
    @CacheEvict(value = { "company" }, allEntries = true)
    @Override
    public String register(Project project, Company company) {

        // 1.校验信息
        CompanyExample companyExample = new CompanyExample();
        CompanyExample.Criteria companyExampleCriteria = companyExample.createCriteria();
        companyExampleCriteria.andCompanyFullNameEqualTo(company.getCompanyFullName());
        int count = companyMapper.countByExample(companyExample);
        if (count > 0) {
            throw new CommonException("公司名称已存在,不能重复", "base_is_exists", "公司名称");
        }

        companyExample.clear();
        companyExample.createCriteria().andMobilephoneEqualTo(company.getMobilephone());
        int count2 = companyMapper.countByExample(companyExample);
        if (count2 > 0) {
            throw new CommonException("手机号码 已存在,不能重复", "base_is_exists", "手机号码 ");
        }

        // 2.插入供应商信息
        company.setProjectId(project.getId());
        company.setIsEnable(Constant.YES_INT);
        company.setCreateTime(new Date());
        // 供应商是否上线SRM（0表示否，1表示是）
        company.setIsOnline(Constant.NO_INT);
        // 新建的供应商审核状态为0，供应商可以修改基础资料
        company.setApproveStatus(Constant.NO_INT);
        company.setId(null);
        company.setCompanyCode(generateCodeService.getNextCompanyCode());
        this.companyMapper.insertSelective(company);

        // 3.插入供应商用户基本信息，插入供应商权限信息
        User user = new User();
        user.setLoginName(company.getCompanyCode());
        user.setNickName(company.getCompanyFullName());
        user.setMobilePhone(company.getMobilephone());
        user.setPassword(company.getPassword());
        user.setEmail(company.getEmail());
        user.setIsEnable(Constant.YES_INT);
        if (project != null) {
            user.setProjectCode(project.getProjectCode());
        }
        this.userService.addObj(user);

        // 4.创建供应商与用户之间的关系
        this.companyUserRefService.addUserIntoCompany(user.getId(), company.getId());

        // 5.分配角色
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo(PartnerRoleEnum.STRANGER.getUserRoleCode());
        List<Role> list = roleService.queryAllObjByExample(roleExample);
        if (CollectionUtils.isNotEmpty(list)) {
            for (Role role : list) {
                UserRole t = new UserRole();
                t.setUserId(user.getId());
                t.setRoleId(role.getId());
                t.setCreateTime(new Date());
                userRoleService.addObj(t);
            }
        }

        // 6.插入供应商与采购商基本信息
        this.setCompanyPartner(project,company);
        
        return company.getCompanyCode();
    }
    
    /**
     * 设置供应商与采购基本信息
     * @param project
     * @param company
     */
    private void setCompanyPartner(Project project, Company company) {
    	CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setProjectId(project.getId());
        companyPartner.setCompanyId(project.getCompanyId());
        companyPartner.setPartnerCompanyId(company.getId());
        companyPartner.setPartnerCompanyName(company.getCompanyFullName());
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.STRANGER.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.STRANGER.getName());

        this.companyPartnerMapper.insertSelective(companyPartner);
		
	}

	@Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
	@Override
	public List<Company> queryChildCompany(String parentId) {
		CompanyExample example = new CompanyExample();
		example.createCriteria()
		    .andIsEnableEqualTo(Constant.YES_INT)
		    .andParentIdEqualTo(parentId);
		
		return this.queryAllObjByExample(example);
	}

	@Override
	public Integer countByExample(CompanyExample example) {
		return this.companyMapper.countByExample(example);
	}
	
	@CacheEvict(value = { "company" }, allEntries = true)
	@Override
	public void disableOnlineSrm(String companyId) {
		Company company = this.companyMapper.selectByPrimaryKey(companyId);
		Assert.isNotNull(company, "供应商不存在");
		Company com = new Company();
		com.setId(company.getId());
		if (Constant.NO_INT == company.getIsOnline()) {
			com.setIsOnline(Constant.YES_INT);
		} else {
			com.setIsOnline(Constant.NO_INT);
		}
		this.companyMapper.updateByPrimaryKeySelective(com);
		
	}

	@CacheEvict(value = { "company" }, allEntries = true)
	@Override
	public void addAll(List<Company> arg0) {
		if(CollectionUtils.isEmpty(arg0)){
			return;
		}
		this.companyMapper.insertBatch(arg0);
	}

	@Cacheable(value = "company", keyGenerator = "redisKeyGenerator")
	@Override
	public PageView<Company> querySupplerCompaniesLists(String purCompanyId, CompanyExample companyExample,
			String roleEnum, Map<String, Object> queryMap) {
		
	      PageView<Company> pageView = companyExample.getPageView();
	        List<Company> list = this.companyMapper.selectPartnerByExampleByPage(purCompanyId, companyExample,
	                roleEnum);
	        pageView.setQueryResult(list);
	        return pageView;
	}

}