package com.els.base.company.service.impl;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.els.base.company.entity.Department;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.service.user.UserExtInfoQueryService;

/**
 * 给用户的拓展信息设置部门
 * @author hzy
 *
 */
@Component
public class QueryDeptForUser implements UserExtInfoQueryService<Department> {
	
	@Resource
	private DepartmentService departmentService;

	@Override
	public String getExtKey() {
		return "department";
	}

	@Override
	public Department getData(String userId) {
		return this.departmentService.queryDepartmentOfUser(userId);
	}

}
