package com.els.base.company.utils;

import org.apache.commons.lang.StringUtils;

public enum CompanyTypeEnum {

	MANUFACTURER("1","标准件制造商"),
	AGENT("2","标准件代理商"),
	CUSTOM_PARTS("3","定制件制造商"),
	CUSTOM_AGENT("4","定制件代理商");
	
	private String code;
	private String value;
	private CompanyTypeEnum(String code, String value) {
		this.code = code;
		this.value = value;
	}
	public String getCode() {
		return code;
	}
	public String getValue() {
		return value;
	}
	
	public static String getValueForCode(String code) {
		String value = "";
		if (StringUtils.isBlank(code)) {
			return value;
		}
		switch(code) {
		case "1":
			value = CompanyTypeEnum.MANUFACTURER.getValue();
			break;
		case "2":
			value = CompanyTypeEnum.AGENT.getValue();
			break;
		case "3":
			value = CompanyTypeEnum.CUSTOM_PARTS.getValue();
			break;
		case "4":
			value = CompanyTypeEnum.CUSTOM_AGENT.getValue();
			break;
		}
		return value;
	}
	
	
}
