package com.els.base.company.utils;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.utils.SpringContextHolder;

/**
 * 企业信息工具，根据session中的用户信息，查询企业信息。
 * <p/>
 * 警告:请不要在service中使用。因为是要通过controller层的session获取的，service获取不了。
 * 
 * @author hzy
 *
 */
public abstract class CompanyUtils {

	private static CompanyPurRefService getCompanyPurRefService() {
		return SpringContextHolder.getOneBean(CompanyPurRefService.class);
	}

	private static CompanyUserRefService getCompanyUserRefService() {
		return SpringContextHolder.getOneBean(CompanyUserRefService.class);
	}

	private static CompanyService getCompanyService() {
		return SpringContextHolder.getOneBean(CompanyService.class);
	}

	/**
	 * 查询当前用户的企业
	 * 
	 * @return
	 */
	public static Company currentCompany() {
		String companyId = getCompanyUserRefService().queryCompanyIdOfUser(SpringSecurityUtils.getLoginUserId());
		Company company = getCompanyService().queryObjById(companyId);
		if (company == null) {
			throw new CommonException("用户未分配", "user_unassigned");
		}
		return company;
	}

	/**
	 * 获取当前登录的企业帐号，是否是供应商
	 * 
	 * @return
	 */
	public static boolean isSupCompany() {
		return !isPurCompany();
	}

	/**
	 * 获取当前登录帐号的企业，是否是采购商
	 */
	public static boolean isPurCompany() {
		String rootCompanyId = ProjectUtils.getProject().getCompanyId();
		String currentCompanyId = currentCompanyId();
		if (rootCompanyId.equals(currentCompanyId)) {
			return true;
		}
		List<Company> childern = getCompanyService().queryChildCompany(rootCompanyId);
		if (CollectionUtils.isEmpty(childern)) {
			return false;
		}
		for (Company company : childern) {
			if (company.getId().equals(currentCompanyId)) {
				return true;
			}

		}
		return false;
	}

	/**
	 * 查询当前用户的企业id
	 * 
	 * @return
	 */
	public static String currentCompanyId() {
		return currentCompany().getId();
	}

	/**
	 * 获取当前企业的采购商
	 * 
	 * @param supCompany
	 * @return
	 */
	public static Company getPurCompanyOfCurrentCompany() {
		return getCompanyService().queryPurchaseCompanies(currentCompanyId());
	}

	/**
	 * 获取当前采购员，管理的供应商
	 * 
	 * @return
	 */
	public static List<Company> getSupCompanyOfCurrentUser() {
		CompanyExample companyExample = new CompanyExample();
		companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);

		List<Company> companyList = getCompanyPurRefService()
				.queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(), companyExample);
		if (companyList == null) {
			return new ArrayList<>();
		}
		return companyList;
	}

	/**
	 * 获取当前采购员，管理的供应商
	 * 
	 * @return
	 */
	public static List<String> getSupCompanyIdsOfCurrentUser() {
		CompanyExample companyExample = new CompanyExample();
		companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);

		List<String> companyIds = new ArrayList<>();
		List<Company> list = getCompanyPurRefService().queryAllCompanyByUserId(SpringSecurityUtils.getLoginUserId(),
				companyExample);
		if (CollectionUtils.isEmpty(list)) {
			return companyIds;
		}

		for (Company company : list) {
			companyIds.add(company.getId());
		}
		return companyIds;
	}

}
