package com.els.base.company.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.reflect.ReflectUtils;

public abstract class FinishFlagUtils {
	
	private static Logger logger = LoggerFactory.getLogger(FinishFlagUtils.class);
	
	public static Integer getFinishFlag(Company company) {
		//Assert.isNotBlank(company.getFirstCompanyType(), "企业的第一大类不能为空");
		try {
			Class<? extends Company> objectClass = Company.class;
			Field[] fields = objectClass.getDeclaredFields();

			if (ArrayUtils.isEmpty(fields)) {
				logger.info("属性数组为null，返回false");
				return Constant.NO_INT;
			}
			List<String> list = new ArrayList<>();
			list.addAll(exculdeFieldNames());
//			String firstCompanyType = company.getFirstCompanyType();
//			if (firstCompanyType.equals(CompanyTypeEnum.AGENT.getCode())) {
//				list.add("plantArea");// 厂房面积
//				list.add("plantUseRate");// 厂房使用率
//				list.add("workerNumber");// 工人数
//				list.add("productCapacity");// 产品产能
//				list.add("monthlyCapacity");// 月产能
//			} else if(firstCompanyType.equals(CompanyTypeEnum.MANUFACTURER.getCode())) {
//				list.add("actingBrand");// 代理品牌
//				list.add("agentTime");// 代理证时间
//				list.add("actingProducts");// 代理产品
//				list.add("isFieldService");// 是否提供现场服务
//				list.add("plantArea");// 厂房面积
//				list.add("plantUseRate");// 厂房使用率
//				list.add("productCapacity");// 产品产能
//			}else {
//				list.add("actingBrand");// 代理品牌
//				list.add("agentTime");// 代理证时间
//				list.add("actingProducts");// 代理产品
//				list.add("isFieldService");// 是否提供现场服务
//				list.add("monthlyCapacity");// 月产能
//				list.add("competitionProducts");// 欲竞投产品
//			}
			for (Field field : fields) {
				field.setAccessible(true);
				if (list.contains(field.getName())) {
					continue;
				}
				if (field.get(company) == null) {
					// 有一个为空，就是没有填完
					return Constant.NO_INT;
				}
				// 如果类型是String
				if (field.getType().equals(String.class)) {
					String val = (String) ReflectUtils.getValue(company, field.getName());
					logger.debug("属性[{}]的值是[{}]", field.getName(), val);
					if (StringUtils.isBlank(val)) {
						logger.debug("字符串的值为空，返回false");
						return Constant.NO_INT;
					}
				}
			}
		} catch (IllegalAccessException e) {
			throw new CommonException("检查是否填完资料失败");
		}
		return Constant.YES_INT;
	}

	protected static List<String> exculdeFieldNames() {
		List<String> filedNameList = new ArrayList<>();
		filedNameList.add("id");
		filedNameList.add("extInfo");
		filedNameList.add("password");
		filedNameList.add("userList");
		filedNameList.add("companyAddressList");
		filedNameList.add("parentId");
		filedNameList.add("projectId");
		filedNameList.add("industry");
		filedNameList.add("subIndustry");
		filedNameList.add("companyCode");
		filedNameList.add("companySapCode");
		filedNameList.add("companyType");
		filedNameList.add("businessScop");
		filedNameList.add("taxCert");
		filedNameList.add("organzationCert");
		filedNameList.add("businessLicence");
		filedNameList.add("country");
		filedNameList.add("province");
		filedNameList.add("city");
		filedNameList.add("mobilephone");
		filedNameList.add("email");
		filedNameList.add("website");
		filedNameList.add("remark");
		filedNameList.add("contacts");
		filedNameList.add("status");
		filedNameList.add("isEnable");
		filedNameList.add("externalManufacturer");
		filedNameList.add("purchasingStaff");
		filedNameList.add("groupCode");
		filedNameList.add("delegateType");
		filedNameList.add("industrialType");
		filedNameList.add("reconciliationAccountCode");
		filedNameList.add("reconciliationAccountName");
		filedNameList.add("payConditionsDesc");
		filedNameList.add("internationalTradeCondition");
		filedNameList.add("salesman");
		filedNameList.add("salesmanPhone");
		filedNameList.add("invoiceVerify");
		filedNameList.add("automaticPurchaseOrder");
		filedNameList.add("purchasingGroup");
		filedNameList.add("plannedDeliveryTime");
		filedNameList.add("supplyProperties");
		filedNameList.add("createTime");
		filedNameList.add("firstCompanyTypeExplain");
		filedNameList.add("secondCompanyTypeExplain");
		filedNameList.add("approveTime");
		filedNameList.add("approveStatus");
		filedNameList.add("approveUserName");
		filedNameList.add("corporationLegalPerson");
		filedNameList.add("secondCompanyType");
		filedNameList.add("firstCompanyType");
		filedNameList.add("classificationThree");
		filedNameList.add("grade");
		filedNameList.add("businessScope");
		filedNameList.add("productionAddress");
		filedNameList.add("classificationThree");
		filedNameList.add("grade");

		return filedNameList;
	}
}
