package com.els.base.company.web.controller;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="采购用户管理的供应商")
@Controller
@RequestMapping("companyPurRef")
public class CompanyPurRefController {
	
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="创建采购用户管理的供应商")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyPurRef companyPurRef) {
    	companyPurRef.setId(null);
    	companyPurRef.setProjectId(ProjectUtils.getProjectId());
    	companyPurRef.setUserId(SpringSecurityUtils.getLoginUserId());
        this.companyPurRefService.addObj(companyPurRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑采购用户及其管理供应商关联关系")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyPurRef companyPurRef) {
        if (StringUtils.isBlank(companyPurRef.getId())) {
            throw new CommonException("Id为空","id_is_blank");
        }
        this.companyPurRefService.modifyObj(companyPurRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除采购用户及其管理供应商关联关系")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("Id为空","id_is_blank");
        }
        this.companyPurRefService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="分页查询采购用户及其管理供应商列表")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyPurRef>> findByPage(
    		@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, 
    		@ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件,属性名请参考 CompanyPurRef") 
    		@RequestBody(required=false) QueryParamWapper wapper) {
    	
        CompanyPurRefExample example = new CompanyPurRefExample();
        example.setPageView(new PageView<CompanyPurRef>(pageNo, pageSize));
        CompanyPurRefExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        PageView<CompanyPurRef> pageData = this.companyPurRefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
  /*  @ApiOperation(httpMethod="POST", value="通过采购用户查询其管理的供应商用户")
    @RequestMapping("service/findAllCompanyPurRefByUserId")
    @ResponseBody
    public ResponseResult<List<CompanyPurRef>> findAllCompanyPurRefByUserId(@RequestParam(required=true)String  userId) {
    	if(StringUtils.isBlank(userId)){
    		 throw new CommonException("Id为空","id_is_blank");
    	}
        List<CompanyPurRef> companyPurRefList = this.companyPurRefService.findAllCompanyPurRefByUserId(userId);
        return ResponseResult.success(companyPurRefList);
    }*/
    
    @ApiOperation(httpMethod="POST", value="通过采购用户查询其负责的供应商详细信息")
    @RequestMapping("service/findAllCompanyByUserId")
    @ResponseBody
    public ResponseResult<List<Company>> findAllCompanyByUserId(@RequestParam(required=true)String  userId) {
    	if(StringUtils.isBlank(userId)){
    		 throw new CommonException("Id为空","id_is_blank");
    	}
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(userId, null);
        return ResponseResult.success(companyList);
    }
    
    @ApiOperation(httpMethod="POST", value="通过采购用户查询其负责的供应商详细信息,供交货计划和采购预测使用")
    @RequestMapping("service/findAllCompanyForMaterialPlan")
    @ResponseBody
    public ResponseResult<PageView<Company>> findAllCompanyForMaterialPlan(
    		@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo,
			@ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize,
    		@RequestBody(required = false) QueryParamWapper queryParams){
    	CompanyExample example = new CompanyExample();
    	example.setPageView(new PageView<Company>(pageNo, pageSize));
    	
    	CompanyExample.Criteria cri = example.createCriteria();
    	CriteriaUtils.addCriterion(cri, queryParams);
    	PageView<Company> companyList = this.companyPurRefService.queryAllCompanyForPageView(SpringSecurityUtils.getLoginUserId(), example);
    	if(companyList == null){
    		List<Company> data = new ArrayList<>();
    		PageView<Company>  pageView = new PageView<>(pageNo,pageSize);
    		pageView.setRowCount(0);
			pageView.setQueryResult(data);
			return ResponseResult.success(pageView);
    	}
    	return ResponseResult.success(companyList);
    }
    
    @ApiOperation(httpMethod="POST", value="根据供应商ID查询其负责的全部采购员基本信息及其所在公司的详细信息")
    @RequestMapping("service/findCompanyContactUserInfo")
    @ResponseBody
    public ResponseResult<List<FriendGroup>> findAllPurchaserUserInfo() {
    	String  companyId=CompanyUtils.currentCompanyId();
//        return ResponseResult.success(this.companyPurRefService.findCompanyContactUserInfoByCompanyId(companyId));
    	List<FriendGroup> friendGroupList = this.companyPurRefService.queryPurchaseFriendGroup(companyId);
    	return ResponseResult.success(friendGroupList);
    }
    
    
}