package com.els.base.company.web.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.els.base.core.entity.user.UserExample;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="企业用户关联表")
@Controller
@RequestMapping("companyUserRef")
public class CompanyUserRefController {
	
    @Resource
    protected CompanyUserRefService companyUserRefService;
    
    @Resource
    private UserService userService;

    @ApiOperation(httpMethod="POST", value="创建企业用户关联表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyUserRef companyUserRef) {
        this.companyUserRefService.addObj(companyUserRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑企业用户关联表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyUserRef companyUserRef) {
        if (StringUtils.isBlank(companyUserRef.getId())) {
            throw new CommonException("Id为空","id_is_blank");
        }
        this.companyUserRefService.modifyObj(companyUserRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除企业用户关联表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("Id为空","id_is_blank");
        }
        this.companyUserRefService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询企业用户关联表")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyUserRef>> findByPage(
    		@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, 
    		@ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, 
    		@ApiParam(value="查询条件,属性名请参考 CompanyUserRef") 
    		@RequestBody(required=false) QueryParamWapper wapper) {
    	
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.setPageView(new PageView<CompanyUserRef>(pageNo, pageSize));
        
        if (wapper != null) {
            CompanyUserRefExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CompanyUserRef> pageData = this.companyUserRefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="通过供应商公司id分页查询用户")
    @RequestMapping("service/queryUserListOfCompanyByPage")
    @ResponseBody
    public ResponseResult<PageView<User>> queryUserListOfCompanyByPage(
    		@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo,
    		@ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize,
    		@ApiParam(value = "companyId") @RequestParam String companyId) {
        if (StringUtils.isBlank(companyId)) {
            throw new CommonException("Id为空","id_is_blank");
        }
        CompanyUserRefExample refExample = new CompanyUserRefExample();
        refExample.createCriteria().andCompanyIdEqualTo(companyId);
        List<CompanyUserRef> listCompanyUserRef = this.companyUserRefService.queryAllObjByExample(refExample);
        if (CollectionUtils.isEmpty(listCompanyUserRef)) {
            return null;
        }
        List<String> userIds = new ArrayList<>();
        for(CompanyUserRef ref: listCompanyUserRef){
            userIds.add(ref.getUserId());
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIdIn(userIds);
        userExample.setOrderByClause("CREATE_TIME ASC");
        userExample.setPageView(new PageView<>(pageNo, pageSize));
        PageView<User> pageData = this.userService.queryObjByPage(userExample);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="通过供应商公司id查询用户")
    @RequestMapping("service/queryUserListOfCompany")
    @ResponseBody
    public ResponseResult<List<User>> queryUserListOfCompany(
    		@ApiParam(value = "companyId") @RequestParam String companyId,
    		@ApiParam(value = "userName") @RequestParam(required = false) String userName
    ) {
        if (StringUtils.isBlank(companyId)) {
            throw new CommonException("Id为空","id_is_blank");
        }
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);

        List<CompanyUserRef> listCompanyUserRef = this.companyUserRefService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(listCompanyUserRef)) {
            return ResponseResult.success(new ArrayList<>());
        }
        List<String> userIds = new ArrayList<>();
        for(CompanyUserRef ref: listCompanyUserRef){
            userIds.add(ref.getUserId());
        }

        UserExample userExample = new UserExample();
        UserExample.Criteria criteria = userExample.createCriteria();
        criteria.andIdIn(userIds);
        if (StringUtils.isNotBlank(userName)){
            criteria.andNickNameLike(userName);
        }
        example.setOrderByClause("CREATE_TIME ASC");
        List<User> userList = this.userService.queryAllObjByExample(userExample);
        return ResponseResult.success(userList);
    }

    @ApiOperation(value="添加用户帐号", httpMethod="POST")
   	@RequestMapping("service/addUser")
   	@ResponseBody
   	public ResponseResult<String> addUser(@RequestBody User user) {
       	
    	//检查账号不能为空
		if (StringUtils.isBlank(user.getEmail())) {
			throw new CommonException("Email值不能为空", "base_canot_be_null","Email");
		}
		if (StringUtils.isBlank(user.getLoginName())) {
			throw new CommonException("账号不能为空", "base_canot_be_null","账号");
		}
		if (StringUtils.isBlank(user.getMobilePhone())) {
			throw new CommonException("手机号不能为空", "base_canot_be_null","手机号");
		}
		if (StringUtils.isBlank(user.getPassword())) {
			throw new CommonException("密码不能为空", "base_canot_be_null","密码");
		}
		
    	//检查用户名长度
		if(user.getLoginName().length()>255){
			throw new CommonException("用户账号名称不能超过规定长度","length_canot_exceed","用户账号名称",255);
     	}
		if(user.getMobilePhone().length()>11){
			throw new CommonException("用户手机号不能超过规定长度","length_canot_exceed","用户手机号",11);
     	}
		if(user.getEmail().length()>255){
			throw new CommonException("用户邮箱号不能超过规定长度","length_canot_exceed","用户邮箱号",255);
     	}
    	
   	    //创建用户
       	user.setId(null);
   		user.setIsEnable(Constant.YES_INT);
   		user.setProjectCode(ProjectUtils.getProject().getProjectCode());
   		
       	this.userService.addObj(user);
   		
   		//创建成功之后需要进行创建公司以及用户之间的依赖关系
   		CompanyUserRef companyUserRef=new CompanyUserRef();
   		companyUserRef.setProjectId(ProjectUtils.getProjectId());
   		companyUserRef.setCompanyId(CompanyUtils.currentCompanyId());
   		companyUserRef.setUserId(user.getId());
   		companyUserRef.setCreateTime(new Date());
   		companyUserRefService.addObj(companyUserRef);
   		
   		return ResponseResult.success();
   	}
    
}