/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanyPurRefMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCompanyPurRefService")
public class CompanyPurRefServiceImpl
implements CompanyPurRefService {
    @Resource
    protected CompanyPurRefMapper companyPurRefMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;
    @Resource
    protected CompanyUserRefService companyUserRefService;

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    public void addObj(CompanyPurRef t) {
        this.companyPurRefMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyPurRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    public void modifyObj(CompanyPurRef t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyPurRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyPurRef"}, keyGenerator="redisKeyGenerator")
    public CompanyPurRef queryObjById(String id) {
        return this.companyPurRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyPurRef"}, keyGenerator="redisKeyGenerator")
    public List<CompanyPurRef> queryAllObjByExample(CompanyPurRefExample example) {
        return this.companyPurRefMapper.selectByExample(example);
    }

    @Cacheable(value={"companyPurRef"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyPurRef> queryObjByPage(CompanyPurRefExample example) {
        PageView<CompanyPurRef> pageView = example.getPageView();
        pageView.setQueryResult(this.companyPurRefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"companyPurRef"}, keyGenerator="redisKeyGenerator")
    public List<CompanyPurRef> queryAllCompanyPurRefByUserId(String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        CompanyPurRefExample example = new CompanyPurRefExample();
        example.createCriteria().andUserIdEqualTo(userId);
        return this.queryAllObjByExample(example);
    }

    @Override
    public List<Company> queryAllCompanyByUserId(String purUserId, CompanyExample companyExample) {
        if (StringUtils.isBlank((String)purUserId)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", "id_is_blank");
        }
        CompanyPurRefExample example = new CompanyPurRefExample();
        example.createCriteria().andUserIdEqualTo(purUserId);
        List<CompanyPurRef> companyPurRefList = ((CompanyPurRefServiceImpl)SpringContextHolder.getOneBean(CompanyPurRefServiceImpl.class)).queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(companyPurRefList)) {
            return null;
        }
        ArrayList<String> companyIdList = new ArrayList<String>();
        for (CompanyPurRef companyPurRef : companyPurRefList) {
            if (StringUtils.isBlank((String)companyPurRef.getSupCompanyId())) continue;
            companyIdList.add(companyPurRef.getSupCompanyId());
        }
        if (CollectionUtils.isEmpty(companyIdList)) {
            return null;
        }
        if (companyExample == null) {
            companyExample = new CompanyExample();
        }
        if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
            companyExample.createCriteria().andIdIn(companyIdList);
        } else {
            Iterator<CompanyExample.Criteria> iterator = companyExample.getOredCriteria().iterator();
            while (iterator.hasNext()) {
                iterator.next().andIdIn(companyIdList);
            }
        }
        return this.companyService.queryAllObjByExample((IExample)companyExample);
    }

    @Override
    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    public void addSupplierIntoPurchaser(String userId, Company purCompany, List<Company> supCompanyList) {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("userId\u4e3a\u7a7a", "id_is_blank");
        }
        User user = (User)this.userService.queryObjById((Object)userId);
        if (user == null) {
            throw new CommonException("\u7528\u6237\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u7528\u6237"});
        }
        if (CollectionUtils.isEmpty(supCompanyList)) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4f9b\u5e94\u5546\u5217\u8868"});
        }
        CompanyPurRefExample companyPurRefExample = new CompanyPurRefExample();
        CompanyPurRefExample.Criteria companyPurRefCriteria = companyPurRefExample.createCriteria();
        companyPurRefCriteria.andProjectIdEqualTo(purCompany.getProjectId());
        companyPurRefCriteria.andUserIdEqualTo(userId);
        this.companyPurRefMapper.deleteByExample(companyPurRefExample);
        for (Company company : supCompanyList) {
            CompanyPurRef companyPurRef = new CompanyPurRef();
            companyPurRef.setUserId(userId);
            companyPurRef.setSupCompanyId(company.getId());
            companyPurRef.setPurCompanyId(purCompany.getId());
            companyPurRef.setProjectId(purCompany.getProjectId());
            companyPurRef.setId(UUIDGenerator.generateUUID());
            companyPurRef.setCreateTime(new Date());
            this.companyPurRefMapper.insertSelective(companyPurRef);
        }
    }

    @Override
    @Cacheable(value={"companyPurRef"}, keyGenerator="redisKeyGenerator")
    public List<FriendGroup> queryPurchaseUser(CompanyPurRefExample companyPurRefExample) {
        List<CompanyPurRef> companyPurRefList = this.companyPurRefMapper.selectByExample(companyPurRefExample);
        ArrayList<FriendGroup> friendGroupList = new ArrayList<FriendGroup>();
        if (CollectionUtils.isEmpty(companyPurRefList)) {
            return friendGroupList;
        }
        for (CompanyPurRef companyPurRef : companyPurRefList) {
            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample.createCriteria();
            companyUserRefExampleCriteria.andCompanyIdEqualTo(companyPurRef.getSupCompanyId());
            companyUserRefExampleCriteria.andProjectIdEqualTo(companyPurRef.getProjectId());
            List companyUserRefList = this.companyUserRefService.queryAllObjByExample((IExample)companyUserRefExample);
            if (CollectionUtils.isEmpty((Collection)companyUserRefList)) continue;
            FriendGroup friendGroup = new FriendGroup();
            CompanyUserRef companyUserRef = (CompanyUserRef)companyUserRefList.get(0);
            friendGroup.setCompany((Company)this.companyService.queryObjById(companyUserRef.getCompanyId()));
            ArrayList<User> userList = new ArrayList<User>();
            for (CompanyUserRef companyUser : companyUserRefList) {
                User user = (User)this.userService.queryObjById((Object)companyUser.getUserId());
                if (user == null) continue;
                userList.add(user);
            }
            friendGroup.setUserList(userList);
            friendGroupList.add(friendGroup);
        }
        return friendGroupList;
    }

    @Override
    public List<FriendGroup> queryPurchaseFriendGroup(String companyId) {
        CompanyPurRefExample example = new CompanyPurRefExample();
        example.createCriteria().andSupCompanyIdEqualTo(companyId);
        CompanyPurRefService service = (CompanyPurRefService)SpringContextHolder.getBean((String)"defaultCompanyPurRefService");
        List purRefs = service.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)purRefs)) {
            return null;
        }
        HashMap<String, ArrayList<String>> companyAndUserMap = new HashMap<String, ArrayList<String>>();
        for (CompanyPurRef ref : purRefs) {
            ArrayList<String> userIdList = (ArrayList<String>)companyAndUserMap.get(ref.getPurCompanyId());
            if (userIdList == null) {
                userIdList = new ArrayList<String>();
            }
            userIdList.add(ref.getUserId());
            companyAndUserMap.put(ref.getPurCompanyId(), userIdList);
        }
        if (MapUtils.isEmpty(companyAndUserMap)) {
            return null;
        }
        ArrayList<FriendGroup> friendGroupVOs = new ArrayList<FriendGroup>();
        for (String purCompanyId : companyAndUserMap.keySet()) {
            Company purCompany = (Company)this.companyService.queryObjById(purCompanyId);
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn((List)companyAndUserMap.get(purCompanyId)).andIsEnableEqualTo(Constant.YES_INT);
            FriendGroup friendGroup = new FriendGroup();
            friendGroup.setCompany(purCompany);
            friendGroup.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
            friendGroupVOs.add(friendGroup);
        }
        return friendGroupVOs;
    }

    @Override
    public FriendGroup queryPurchaseFriendGroup(String supCompanyId, String purCompanyId) {
        CompanyPurRefExample example = new CompanyPurRefExample();
        example.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andPurCompanyIdEqualTo(purCompanyId);
        CompanyPurRefService service = (CompanyPurRefService)SpringContextHolder.getBean((String)"defaultCompanyPurRefService");
        List purRefs = service.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)purRefs)) {
            return null;
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        for (CompanyPurRef ref : purRefs) {
            userIdList.add(ref.getUserId());
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIdIn(userIdList).andIsEnableEqualTo(Constant.YES_INT);
        FriendGroup friendGroup = new FriendGroup();
        friendGroup.setCompany((Company)this.companyService.queryObjById(purCompanyId));
        friendGroup.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
        return friendGroup;
    }

    @Override
    public List<FriendGroup> querySupplyFriendGroup(String purUserId) {
        CompanyPurRefExample purRefExample = new CompanyPurRefExample();
        purRefExample.createCriteria().andUserIdEqualTo(purUserId);
        CompanyPurRefService service = (CompanyPurRefService)SpringContextHolder.getBean((String)"defaultCompanyPurRefService");
        List purRefs = service.queryAllObjByExample((IExample)purRefExample);
        if (CollectionUtils.isEmpty((Collection)purRefs)) {
            return null;
        }
        ArrayList<FriendGroup> friendGroups = new ArrayList<FriendGroup>();
        for (CompanyPurRef ref : purRefs) {
            String supCompanyId = ref.getSupCompanyId();
            Company supCompany = (Company)this.companyService.queryObjById(supCompanyId);
            if (supCompany == null) continue;
            FriendGroup friendGroup = new FriendGroup();
            friendGroup.setCompany(supCompany);
            List<String> userIdList = this.companyUserRefService.queryUserOfCompany(supCompanyId);
            if (CollectionUtils.isNotEmpty(userIdList)) {
                UserExample userExample = new UserExample();
                userExample.createCriteria().andIdIn(userIdList).andIsEnableEqualTo(Constant.YES_INT);
                friendGroup.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
            }
            friendGroups.add(friendGroup);
        }
        return friendGroups;
    }

    @Override
    public PageView<Company> queryAllCompanyForPageView(String purUserId, CompanyExample companyExample) {
        if (StringUtils.isBlank((String)purUserId)) {
            return null;
        }
        CompanyPurRefExample example = new CompanyPurRefExample();
        example.createCriteria().andUserIdEqualTo(purUserId);
        List<CompanyPurRef> companyPurRefList = ((CompanyPurRefServiceImpl)SpringContextHolder.getOneBean(CompanyPurRefServiceImpl.class)).queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(companyPurRefList)) {
            return null;
        }
        ArrayList<String> companyIdList = new ArrayList<String>();
        for (CompanyPurRef companyPurRef : companyPurRefList) {
            if (StringUtils.isBlank((String)companyPurRef.getSupCompanyId())) continue;
            companyIdList.add(companyPurRef.getSupCompanyId());
        }
        if (CollectionUtils.isEmpty(companyIdList)) {
            return null;
        }
        if (companyExample == null) {
            companyExample = new CompanyExample();
        }
        if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
            companyExample.createCriteria().andIdIn(companyIdList);
        } else {
            Iterator<CompanyExample.Criteria> iterator = companyExample.getOredCriteria().iterator();
            while (iterator.hasNext()) {
                iterator.next().andIdIn(companyIdList);
            }
        }
        return this.companyService.queryObjByPage((IExample)companyExample);
    }

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    public void addAll(List<CompanyPurRef> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        this.companyPurRefMapper.insertBatch(arg0);
    }

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    public void deleteByExample(CompanyPurRefExample arg0) {
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u5220\u9664\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.companyPurRefMapper.deleteByExample(arg0);
    }
}

