/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.company.dao.CompanyUserRefMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.dao.user.UserMapper;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyUserRefService")
public class CompanyUserRefServiceImpl
implements CompanyUserRefService {
    @Resource
    protected CompanyUserRefMapper companyUserRefMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected UserService userService;
    @Resource
    protected RoleService roleService;
    @Resource
    protected UserRoleService userRoleService;
    @Autowired
    private UserMapper userMapper;

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void addObj(CompanyUserRef t) {
        this.companyUserRefMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyUserRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void modifyObj(CompanyUserRef t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyUserRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public CompanyUserRef queryObjById(String id) {
        return this.companyUserRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public List<CompanyUserRef> queryAllObjByExample(CompanyUserRefExample example) {
        return this.companyUserRefMapper.selectByExample(example);
    }

    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyUserRef> queryObjByPage(CompanyUserRefExample example) {
        PageView<CompanyUserRef> pageView = example.getPageView();
        pageView.setQueryResult(this.companyUserRefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void addUserIntoCompany(String userId, String companyId) {
        Company company = (Company)this.companyService.queryObjById(companyId);
        if (company == null) {
            throw new CommonException("companyId\u6ca1\u6709\u5bf9\u5e94\u7684\u5bf9\u8c61", "do_not_exists", new Object[]{"\u8be5\u516c\u53f8"});
        }
        CompanyUserRef ref = new CompanyUserRef();
        ref.setUserId(userId);
        ref.setProjectId(company.getProjectId());
        ref.setCompanyId(companyId);
        ref.setCreateTime(new Date());
        this.companyUserRefMapper.insertSelective(ref);
    }

    @Override
    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public String queryCompanyIdOfUser(String userId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List<CompanyUserRef> list = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0).getCompanyId();
    }

    @Override
    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public List<String> queryUserOfCompany(String companyId) {
        ArrayList<String> list = new ArrayList<String>();
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);
        List<CompanyUserRef> listCompanyUserRef = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(listCompanyUserRef)) {
            return null;
        }
        for (CompanyUserRef companyUserRef : listCompanyUserRef) {
            String userId = companyUserRef.getUserId();
            if (!StringUtils.isNotBlank((String)userId)) continue;
            list.add(userId);
        }
        return list;
    }

    @Override
    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    @Transactional
    public void addSupplierIntoUser(Company company, User user) {
        UserExample userEx1 = new UserExample();
        userEx1.createCriteria().andLoginNameEqualTo(user.getLoginName());
        if (this.userMapper.countByExample(userEx1) > 0) {
            throw new CommonException("\u76f8\u540c\u7528\u6237\u5df2\u5b58\u5728", "base_the_same_account");
        }
        UserExample userEx2 = new UserExample();
        userEx2.createCriteria().andMobilePhoneEqualTo(user.getMobilePhone());
        if (this.userMapper.countByExample(userEx2) > 0) {
            throw new CommonException("\u624b\u673a\u53f7\u5df2\u5b58\u5728", "base_the_same_mobile");
        }
        UserExample userEx3 = new UserExample();
        userEx3.createCriteria().andEmailEqualTo(user.getEmail());
        if (this.userMapper.countByExample(userEx3) > 0) {
            throw new CommonException("\u90ae\u7bb1\u5df2\u5b58\u5728", "base_the_same_email");
        }
        if (user.getLoginName().length() > 255 || user.getQq().length() > 255 || user.getNickName().length() > 255 || user.getWechat().length() > 255 || user.getFax().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        user.setIsEnable(Constant.YES_INT);
        try {
            this.userService.addObj((Serializable)user);
        }
        catch (Exception e) {
            throw new CommonException("\u8bf7\u6c42\u5931\u8d25", "base_fail");
        }
        CompanyUserRef companyUserRef = new CompanyUserRef();
        companyUserRef.setProjectId(company.getProjectId());
        companyUserRef.setCompanyId(company.getId());
        companyUserRef.setUserId(user.getId());
        this.companyUserRefMapper.insertSelective(companyUserRef);
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo("supplier");
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            UserRole t = new UserRole();
            t.setUserId(user.getId());
            t.setRoleId(((Role)list.get(0)).getId());
            t.setCreateTime(new Date());
            this.userRoleService.addObj((Serializable)t);
        }
    }

    @Override
    @Cacheable(value={"companyUserRef"}, keyGenerator="redisKeyGenerator")
    public List<FriendGroup> findSupplierUser(CompanyUserRefExample companyUserRefExample) {
        List<CompanyUserRef> companyUserRefList = this.companyUserRefMapper.selectByExample(companyUserRefExample);
        ArrayList<FriendGroup> friendGroupList = new ArrayList<FriendGroup>();
        if (CollectionUtils.isNotEmpty(companyUserRefList)) {
            FriendGroup friendGroup = new FriendGroup();
            CompanyUserRef companyUserRef = companyUserRefList.get(0);
            if (companyUserRef != null) {
                friendGroup.setCompany((Company)this.companyService.queryObjById(companyUserRef.getCompanyId()));
                ArrayList<User> userList = new ArrayList<User>();
                for (CompanyUserRef companyUser : companyUserRefList) {
                    User user = (User)this.userService.queryObjById((Object)companyUser.getUserId());
                    if (user == null) continue;
                    userList.add(user);
                }
                if (CollectionUtils.isNotEmpty(userList)) {
                    friendGroup.setUserList(userList);
                }
                friendGroupList.add(friendGroup);
            }
            return friendGroupList;
        }
        return friendGroupList;
    }

    @Override
    public List<User> queryUserListOfCompany(String supCompanyId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdEqualTo(supCompanyId);
        List<CompanyUserRef> listCompanyUserRef = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(listCompanyUserRef)) {
            return null;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (CompanyUserRef ref : listCompanyUserRef) {
            userIds.add(ref.getUserId());
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIdIn(userIds);
        example.setOrderByClause("CREATE_TIME ASC");
        List userList = this.userService.queryAllObjByExample((IExample)userExample);
        return userList;
    }

    @Override
    public User queryMainUserOfCompany(String companyId) {
        CompanyUserRefExample refExample = new CompanyUserRefExample();
        refExample.createCriteria().andCompanyIdEqualTo(companyId);
        List<CompanyUserRef> userRef = this.companyUserRefMapper.selectByExample(refExample);
        if (CollectionUtils.isEmpty(userRef)) {
            return null;
        }
        User user = (User)this.userService.queryObjById((Object)userRef.get(0).getUserId());
        if (user == null) {
            return null;
        }
        return user;
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void addAll(List<CompanyUserRef> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        this.companyUserRefMapper.insertBatch(arg0);
    }

    @CacheEvict(value={"companyUserRef"}, allEntries=true)
    public void deleteByExample(CompanyUserRefExample arg0) {
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u5220\u9664\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.companyUserRefMapper.deleteByExample(arg0);
    }
}

